/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.FormInput;
import java.beans.PropertyVetoException;

public class TextFormInput
extends FormInput {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 2550648845459385938L;
    private int maxLength_ = -1;

    public TextFormInput() {
    }

    public TextFormInput(String name) {
        super(name);
    }

    public TextFormInput(String name, String value) {
        super(name, value);
    }

    public int getMaxLength() {
        return this.maxLength_;
    }

    String getMaxLengthAttributeTag() {
        if (this.maxLength_ > 0) {
            return " maxlength=\"" + this.maxLength_ + "\"";
        }
        return "";
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- A TextFormInput was here -->";
    }

    @Override
    public String getTag() {
        if (this.getName() == null) {
            Trace.log(2, "Attempting to get tag before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        StringBuffer s = new StringBuffer("<input type=\"text\"");
        s.append(this.getNameAttributeTag());
        s.append(this.getValueAttributeTag(false));
        s.append(this.getMaxLengthAttributeTag());
        s.append(this.getSizeAttributeTag());
        s.append(this.getLanguageAttributeTag());
        s.append(this.getDirectionAttributeTag());
        s.append(this.getAttributeString());
        s.append(" />");
        return s.toString();
    }

    public void setMaxLength(int length) throws PropertyVetoException {
        if (length < 0) {
            throw new ExtendedIllegalArgumentException("maxLength", 4);
        }
        int old = this.maxLength_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("maxLength", (Object)old, (Object)length);
        }
        this.maxLength_ = length;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("maxLength", (Object)old, (Object)length);
        }
    }
}

