/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.servlet.RecordFormatMetaData;
import com.ibm.as400.util.servlet.RowData;
import com.ibm.as400.util.servlet.RowDataException;
import com.ibm.as400.util.servlet.RowDataListener;
import com.ibm.as400.util.servlet.RowDataSupport;
import com.ibm.as400.util.servlet.RowMetaData;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class RecordListRowData
extends RowData
implements Serializable {
    static final long serialVersionUID = 7785461189425222072L;
    private RecordFormat recordFormat_;
    private RecordFormatMetaData metadata_;
    private transient RowDataSupport rowdataSupport_;
    private transient Record currentRecord_;
    private transient int currentRecordIndex_ = -1;

    public RecordListRowData() {
    }

    public RecordListRowData(RecordFormat recordFormat) {
        this();
        try {
            this.setRecordFormat(recordFormat);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addRow(Record record) throws RowDataException {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.addRow(record, new Vector[record.getRecordFormat().getNumberOfFields()]);
    }

    public void addRow(Record record, Vector[] properties) {
        this.validateRecord(record);
        this.validateProperties(properties);
        this.rows_.addElement(record);
        this.rowProperties_.addElement(properties);
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.fireAdded();
        }
    }

    public void addRow(Record record, int rowIndex) throws RowDataException {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.addRow(record, rowIndex, new Vector[record.getRecordFormat().getNumberOfFields()]);
    }

    public void addRow(Record record, int rowIndex, Vector[] properties) {
        this.validateRecord(record);
        this.validateRowIndex(rowIndex);
        this.validateProperties(properties);
        this.rows_.insertElementAt(record, rowIndex);
        this.rowProperties_.insertElementAt(properties, rowIndex);
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.fireAdded();
        }
    }

    public void addRowDataListener(RowDataListener listener) {
        if (this.rowdataSupport_ == null) {
            this.rowdataSupport_ = new RowDataSupport(this);
        }
        this.rowdataSupport_.addRowDataListener(listener);
    }

    @Override
    public RowMetaData getMetaData() {
        return this.metadata_;
    }

    @Override
    public Object getObject(int columnIndex) throws RowDataException {
        String action = "Attempting to get the column object";
        this.validateRowList(action);
        if (columnIndex < 0 || columnIndex >= this.metadata_.getColumnCount()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        this.validateListPosition(action);
        if (this.currentRecordIndex_ != this.position_) {
            this.currentRecord_ = (Record)this.rows_.elementAt(this.position_);
            this.currentRecordIndex_ = this.position_;
        }
        try {
            return this.currentRecord_.getField(columnIndex);
        }
        catch (UnsupportedEncodingException e) {
            Trace.log(2, "Rethrowing UnsupportedEncodingException");
            throw new RowDataException(e);
        }
    }

    public RecordFormat getRecordFormat() {
        return this.recordFormat_;
    }

    public Record getRow() {
        String action = "Attempting to get the row object";
        this.validateRowList(action);
        this.validateListPosition(action);
        return (Record)this.rows_.elementAt(this.position_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, RowDataException, PropertyVetoException {
        in.defaultReadObject();
        this.currentRecordIndex_ = -1;
    }

    public void removeRowDataListener(RowDataListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.removeRowDataListener(listener);
        }
    }

    public void removeRow(int rowIndex) {
        this.validateRowList("Attempting to remove a row");
        if (rowIndex < 0 || rowIndex >= this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
        this.rows_.removeElementAt(rowIndex);
        this.rowProperties_.removeElementAt(rowIndex);
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.fireRemoved();
        }
    }

    public void setRow(Record record, int rowIndex) {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.setRow(record, rowIndex, new Vector[record.getRecordFormat().getNumberOfFields()]);
    }

    public void setRow(Record record, int rowIndex, Vector[] properties) {
        this.validateRowList("Attempting to change the row");
        this.validateRecord(record);
        if (rowIndex < 0 || rowIndex >= this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
        this.validateProperties(properties);
        this.rows_.setElementAt(record, rowIndex);
        this.rowProperties_.setElementAt(properties, rowIndex);
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.fireChanged();
        }
    }

    public void setRecordFormat(RecordFormat recordFormat) throws PropertyVetoException {
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        RecordFormat old = this.recordFormat_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("recordFormat", old, recordFormat);
        }
        this.recordFormat_ = recordFormat;
        if (!this.rows_.isEmpty()) {
            this.rows_ = new Vector();
            this.rowProperties_ = new Vector();
        }
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("recordFormat", old, recordFormat);
        }
        if (this.metadata_ == null) {
            this.metadata_ = new RecordFormatMetaData(this.recordFormat_);
        } else {
            this.metadata_.setRecordFormat(this.recordFormat_);
        }
    }

    private void validateProperties(Vector[] properties) {
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        if (properties.length != this.metadata_.getColumnCount()) {
            throw new ExtendedIllegalArgumentException("properties", 1);
        }
    }

    private void validateRecord(Record record) {
        if (record == null) {
            throw new NullPointerException("record");
        }
        try {
            if (this.recordFormat_ == null) {
                this.setRecordFormat(record.getRecordFormat());
            } else if (record.getRecordFormat() != this.recordFormat_) {
                Trace.log(2, "Parameter 'record' does not contain the correct record format.");
                throw new ExtendedIllegalArgumentException("record", 2);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void validateRowIndex(int rowIndex) {
        if (rowIndex < 0 || rowIndex > this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
    }
}

