/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import java.io.File;
import java.io.InputStream;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.element.office.OfficeImageElement;
import org.odftoolkit.odfdom.pkg.MediaType;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.xml.sax.SAXException;

public class OdfImageDocument
extends OdfDocument {
    private static final String EMPTY_IMAGE_DOCUMENT_PATH = "/OdfImageDocument.odi";
    static final OdfPackageDocument.Resource EMPTY_IMAGE_DOCUMENT_RESOURCE = new OdfPackageDocument.Resource("/OdfImageDocument.odi");

    public static OdfImageDocument newImageDocument() throws Exception {
        return (OdfImageDocument)OdfDocument.loadTemplate(EMPTY_IMAGE_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.IMAGE);
    }

    public static OdfImageDocument newImageTemplateDocument() throws Exception {
        OdfImageDocument doc = (OdfImageDocument)OdfDocument.loadTemplate(EMPTY_IMAGE_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.IMAGE_TEMPLATE);
        doc.changeMode(OdfMediaType.IMAGE_TEMPLATE);
        return doc;
    }

    protected OdfImageDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType) throws SAXException {
        super(pkg, internalPath, odfMediaType.mMediaType);
    }

    public static OdfImageDocument loadDocument(InputStream inputStream) throws Exception {
        return (OdfImageDocument)OdfDocument.loadDocument(inputStream);
    }

    public static OdfImageDocument loadDocument(String documentPath) throws Exception {
        return (OdfImageDocument)OdfDocument.loadDocument(documentPath);
    }

    public static OdfImageDocument loadDocument(File file) throws Exception {
        return (OdfImageDocument)OdfDocument.loadDocument(file);
    }

    public OfficeImageElement getContentRoot() throws Exception {
        return super.getContentRoot(OfficeImageElement.class);
    }

    public void changeMode(OdfMediaType mediaType) {
        this.setOdfMediaType(mediaType.mMediaType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType implements MediaType
    {
        IMAGE(OdfDocument.OdfMediaType.IMAGE),
        IMAGE_TEMPLATE(OdfDocument.OdfMediaType.IMAGE_TEMPLATE);

        private final OdfDocument.OdfMediaType mMediaType;

        private OdfMediaType(OdfDocument.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        @Override
        public String getMediaTypeString() {
            return this.mMediaType.getMediaTypeString();
        }

        @Override
        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static OdfDocument.OdfMediaType getOdfMediaType(String mediaType) {
            return OdfDocument.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

