/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.workflow.WorkflowConfiguration;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEngineFactory;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.WebResult;
import org.apache.hop.www.WorkflowMap;
import org.owasp.encoder.Encode;

@HopServerServlet(id="startWorkflow", name="Start a workflow")
public class StartWorkflowServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = StartWorkflowServlet.class;
    private static final long serialVersionUID = -8487225953910464032L;
    public static final String CONTEXT_PATH = "/hop/startWorkflow";

    public StartWorkflowServlet() {
    }

    public StartWorkflowServlet(WorkflowMap workflowMap) {
        super(workflowMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out;
        boolean useXML;
        block17: {
            if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
                return;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"StartWorkflowServlet.Log.StartWorkflowRequested", (String[])new String[0]));
            }
            String workflowName = request.getParameter("name");
            String id = request.getParameter("id");
            useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
            response.setStatus(200);
            out = response.getWriter();
            if (useXML) {
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                out.print(XmlHandler.getXmlHeader((String)"UTF-8"));
            } else {
                response.setContentType("text/html;charset=UTF-8");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>Start workflow</TITLE>");
                out.println("<META http-equiv=\"Refresh\" content=\"2;url=" + this.convertContextPath("/hop/status") + "?name=" + URLEncoder.encode(workflowName, "UTF-8") + "\">");
                out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                out.println("<link rel=\"icon\" type=\"image/svg+xml\" href=\"/static/images/favicon.svg\">");
                out.println("</HEAD>");
                out.println("<BODY>");
            }
            try {
                IWorkflowEngine<WorkflowMeta> workflow = this.getWorkflowMap().findWorkflow(workflowName, id);
                if (workflow != null) {
                    if (workflow.isInitialized() && !workflow.isActive()) {
                        StartWorkflowServlet startWorkflowServlet = this;
                        synchronized (startWorkflowServlet) {
                            WorkflowConfiguration workflowConfiguration = this.getWorkflowMap().getConfiguration(workflowName);
                            MultiMetadataProvider metadataProvider = new MultiMetadataProvider(this.variables, new IHopMetadataProvider[]{this.getServerConfig().getMetadataProvider(), workflowConfiguration.getMetadataProvider()});
                            String containerId = UUID.randomUUID().toString();
                            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.HOP_SERVER, null);
                            servletLoggingObject.setContainerObjectId(containerId);
                            String runConfigurationName = workflowConfiguration.getWorkflowExecutionConfiguration().getRunConfiguration();
                            IWorkflowEngine<WorkflowMeta> newWorkflow = WorkflowEngineFactory.createWorkflowEngine(this.variables, this.variables.resolve(runConfigurationName), (IHopMetadataProvider)metadataProvider, workflow.getWorkflowMeta(), (ILoggingObject)servletLoggingObject);
                            newWorkflow.setLogLevel(workflow.getLogLevel());
                            newWorkflow.activateParameters(newWorkflow);
                            newWorkflow.setContainerId(containerId);
                            HopLogStore.discardLines((String)workflow.getLogChannelId(), (boolean)true);
                            this.getWorkflowMap().replaceWorkflow(workflow, newWorkflow, workflowConfiguration);
                            workflow = newWorkflow;
                        }
                    }
                    this.runWorkflow(workflow);
                    String message = BaseMessages.getString(PKG, (String)"StartWorkflowServlet.Log.WorkflowStarted", (String[])new String[]{workflowName});
                    if (useXML) {
                        out.println(new WebResult("OK", message, workflow.getContainerId()).getXml());
                    } else {
                        out.println("<H1>" + Encode.forHtml((String)message) + "</H1>");
                        out.println("<a href=\"" + this.convertContextPath("/hop/workflowStatus") + "?name=" + URLEncoder.encode(workflowName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">" + BaseMessages.getString(PKG, (String)"WorkflowStatusServlet.BackToWorkflowStatusPage", (String[])new String[0]) + "</a><p>");
                    }
                    break block17;
                }
                String message = BaseMessages.getString(PKG, (String)"StartWorkflowServlet.Log.SpecifiedWorkflowNotFound", (String[])new String[]{workflowName});
                if (useXML) {
                    out.println(new WebResult("ERROR", message));
                } else {
                    out.println("<H1>" + Encode.forHtml((String)message) + "</H1>");
                    out.println("<a href=\"" + this.convertContextPath("/hop/status") + "\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
                    response.setStatus(400);
                }
            }
            catch (Exception ex) {
                if (useXML) {
                    out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"StartWorkflowServlet.Error.UnexpectedError", (String[])new String[]{Const.CR + Const.getStackTracker((Throwable)ex)})));
                }
                out.println("<p>");
                out.println("<pre>");
                out.println(Encode.forHtml((String)Const.getStackTracker((Throwable)ex)));
                out.println("</pre>");
                response.setStatus(400);
            }
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Start workflow";
    }

    @Override
    public String getService() {
        return "/hop/startWorkflow (" + this.toString() + ")";
    }

    protected void runWorkflow(IWorkflowEngine workflow) throws HopException {
        new Thread(() -> workflow.startExecution()).start();
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

