/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.concatfields;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.concatfields.ConcatField;
import org.apache.hop.pipeline.transforms.concatfields.ConcatFieldsMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ConcatFieldsDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = ConcatFieldsMeta.class;
    private TextVar wTargetFieldName;
    private Text wTargetFieldLength;
    private TextVar wSeparator;
    private TextVar wEnclosure;
    private Button wRemove;
    private TableView wFields;
    private final ConcatFieldsMeta input;
    private ColumnInfo[] fieldColumns;
    private final List<String> inputFields = new ArrayList<String>();

    public ConcatFieldsDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (ConcatFieldsMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlTargetFieldName = new Label((Composite)this.shell, 131072);
        wlTargetFieldName.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TargetFieldName.Label", (String[])new String[0]));
        wlTargetFieldName.setToolTipText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TargetFieldName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTargetFieldName);
        FormData fdlTargetFieldName = new FormData();
        fdlTargetFieldName.left = new FormAttachment(0, 0);
        fdlTargetFieldName.top = new FormAttachment((Control)lastControl, margin);
        fdlTargetFieldName.right = new FormAttachment(middle, -margin);
        wlTargetFieldName.setLayoutData((Object)fdlTargetFieldName);
        this.wTargetFieldName = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTargetFieldName);
        FormData fdTargetFieldName = new FormData();
        fdTargetFieldName.left = new FormAttachment(middle, 0);
        fdTargetFieldName.top = new FormAttachment((Control)wlTargetFieldName, 0, 0x1000000);
        fdTargetFieldName.right = new FormAttachment(100, 0);
        this.wTargetFieldName.setLayoutData((Object)fdTargetFieldName);
        lastControl = this.wTargetFieldName;
        Label wlTargetFieldLength = new Label((Composite)this.shell, 131072);
        wlTargetFieldLength.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TargetFieldLength.Label", (String[])new String[0]));
        wlTargetFieldLength.setToolTipText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TargetFieldLength.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTargetFieldLength);
        FormData fdlTargetFieldLength = new FormData();
        fdlTargetFieldLength.left = new FormAttachment(0, 0);
        fdlTargetFieldLength.top = new FormAttachment((Control)this.wTargetFieldName, margin);
        fdlTargetFieldLength.right = new FormAttachment(middle, -margin);
        wlTargetFieldLength.setLayoutData((Object)fdlTargetFieldLength);
        this.wTargetFieldLength = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTargetFieldLength);
        FormData fdTargetFieldLength = new FormData();
        fdTargetFieldLength.left = new FormAttachment(middle, 0);
        fdTargetFieldLength.top = new FormAttachment((Control)wlTargetFieldLength, 0, 0x1000000);
        fdTargetFieldLength.right = new FormAttachment(100, 0);
        this.wTargetFieldLength.setLayoutData((Object)fdTargetFieldLength);
        lastControl = this.wTargetFieldLength;
        Label wlSeparator = new Label((Composite)this.shell, 131072);
        wlSeparator.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.Separator.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSeparator);
        FormData fdlSeparator = new FormData();
        fdlSeparator.left = new FormAttachment(0, 0);
        fdlSeparator.top = new FormAttachment((Control)lastControl, margin);
        fdlSeparator.right = new FormAttachment(middle, -margin);
        wlSeparator.setLayoutData((Object)fdlSeparator);
        Button wbSeparator = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbSeparator);
        wbSeparator.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.Separator.Button", (String[])new String[0]));
        FormData fdbSeparator = new FormData();
        fdbSeparator.right = new FormAttachment(100, 0);
        fdbSeparator.top = new FormAttachment((Control)wlSeparator, 0, 0x1000000);
        wbSeparator.setLayoutData((Object)fdbSeparator);
        wbSeparator.addListener(13, se -> this.wSeparator.getTextWidget().insert("\t"));
        this.wSeparator = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSeparator);
        FormData fdSeparator = new FormData();
        fdSeparator.left = new FormAttachment(middle, 0);
        fdSeparator.top = new FormAttachment((Control)wlSeparator, 0, 0x1000000);
        fdSeparator.right = new FormAttachment((Control)wbSeparator, -margin);
        this.wSeparator.setLayoutData((Object)fdSeparator);
        lastControl = wbSeparator;
        Label wlEnclosure = new Label((Composite)this.shell, 131072);
        wlEnclosure.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.Enclosure.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEnclosure);
        FormData fdlEnclosure = new FormData();
        fdlEnclosure.left = new FormAttachment(0, 0);
        fdlEnclosure.top = new FormAttachment((Control)lastControl, margin);
        fdlEnclosure.right = new FormAttachment(middle, -margin);
        wlEnclosure.setLayoutData((Object)fdlEnclosure);
        this.wEnclosure = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wEnclosure);
        FormData fdEnclosure = new FormData();
        fdEnclosure.left = new FormAttachment(middle, 0);
        fdEnclosure.top = new FormAttachment((Control)wlEnclosure, 0, 0x1000000);
        fdEnclosure.right = new FormAttachment(100, 0);
        this.wEnclosure.setLayoutData((Object)fdEnclosure);
        lastControl = this.wEnclosure;
        Label wlRemove = new Label((Composite)this.shell, 131072);
        wlRemove.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.Remove.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRemove);
        FormData fdlRemove = new FormData();
        fdlRemove.left = new FormAttachment(0, 0);
        fdlRemove.top = new FormAttachment((Control)lastControl, margin);
        fdlRemove.right = new FormAttachment(middle, -margin);
        wlRemove.setLayoutData((Object)fdlRemove);
        this.wRemove = new Button((Composite)this.shell, 16416);
        PropsUi.setLook((Widget)this.wRemove);
        FormData fdRemove = new FormData();
        fdRemove.left = new FormAttachment(middle, 0);
        fdRemove.top = new FormAttachment((Control)wlRemove, 0, 0x1000000);
        fdRemove.right = new FormAttachment(100, 0);
        this.wRemove.setLayoutData((Object)fdRemove);
        lastControl = wlRemove;
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.FieldsTab.TabTitle", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = PropsUi.getFormMargin();
        fieldsLayout.marginHeight = PropsUi.getFormMargin();
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        PropsUi.setLook((Widget)wFieldsComp);
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.get());
        Button wMinWidth = new Button(wFieldsComp, 8);
        wMinWidth.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.MinWidth.Button", (String[])new String[0]));
        wMinWidth.setToolTipText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.MinWidth.Tooltip", (String[])new String[0]));
        wMinWidth.addListener(13, e -> this.setMinimalWidth());
        this.setButtonPositions(new Button[]{this.wGet, wMinWidth}, margin, null);
        int FieldsCols = 10;
        int FieldsRows = this.input.getOutputFields().size();
        String[] dats = Const.getDateFormats();
        String[] nums = Const.getNumberFormats();
        int totalSize = dats.length + nums.length;
        String[] formats = new String[totalSize];
        System.arraycopy(dats, 0, formats, 0, dats.length);
        System.arraycopy(nums, 0, formats, dats.length + 0, nums.length);
        this.fieldColumns = new ColumnInfo[10];
        this.fieldColumns[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.NameColumn.Column", (String[])new String[0]), 2, new String[]{""}, false);
        this.fieldColumns[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TypeColumn.Column", (String[])new String[0]), 2, ValueMetaBase.getTypes());
        this.fieldColumns[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.FormatColumn.Column", (String[])new String[0]), 2, formats);
        this.fieldColumns[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.LengthColumn.Column", (String[])new String[0]), 1, false);
        this.fieldColumns[4] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.PrecisionColumn.Column", (String[])new String[0]), 1, false);
        this.fieldColumns[5] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.CurrencyColumn.Column", (String[])new String[0]), 1, false);
        this.fieldColumns[6] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.DecimalColumn.Column", (String[])new String[0]), 1, false);
        this.fieldColumns[7] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.GroupColumn.Column", (String[])new String[0]), 1, false);
        this.fieldColumns[8] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TrimTypeColumn.Column", (String[])new String[0]), 2, ValueMetaBase.trimTypeDesc, true);
        this.fieldColumns[9] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.NullColumn.Column", (String[])new String[0]), 1, false);
        this.wFields = new TableView(this.variables, wFieldsComp, 67586, this.fieldColumns, FieldsRows, null, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wGet, -margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)lastControl, 2 * margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wTargetFieldName.addModifyListener(e -> this.wTargetFieldName.setToolTipText(this.variables.resolve(this.wTargetFieldName.getText())));
        this.lsResize = event -> {
            Point size = this.shell.getSize();
            this.wFields.setSize(size.x - 10, size.y - 50);
            this.wFields.table.setSize(size.x - 10, size.y - 50);
            this.wFields.redraw();
        };
        this.shell.addListener(11, this.lsResize);
        wTabFolder.setSelection(0);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.fieldColumns[0].setComboValues(fieldNames);
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        this.wTargetFieldName.setText(Const.NVL((String)this.input.getExtraFields().getTargetFieldName(), (String)""));
        this.wTargetFieldLength.setText("" + this.input.getExtraFields().getTargetFieldLength());
        this.wSeparator.setText(Const.NVL((String)this.input.getSeparator(), (String)""));
        this.wEnclosure.setText(Const.NVL((String)this.input.getEnclosure(), (String)""));
        this.wRemove.setSelection(this.input.getExtraFields().isRemoveSelectedFields());
        this.logDebug("getting fields info...");
        for (int i = 0; i < this.input.getOutputFields().size(); ++i) {
            ConcatField field = this.input.getOutputFields().get(i);
            TableItem item = this.wFields.table.getItem(i);
            item.setText(1, Const.NVL((String)field.getName(), (String)""));
            item.setText(2, Const.NVL((String)field.getType(), (String)""));
            item.setText(3, Const.NVL((String)field.getFormat(), (String)""));
            if (field.getLength() >= 0) {
                item.setText(4, "" + field.getLength());
            }
            if (field.getPrecision() >= 0) {
                item.setText(5, "" + field.getPrecision());
            }
            item.setText(6, Const.NVL((String)field.getCurrencySymbol(), (String)""));
            item.setText(7, Const.NVL((String)field.getDecimalSymbol(), (String)""));
            item.setText(8, Const.NVL((String)field.getGroupingSymbol(), (String)""));
            item.setText(9, Const.NVL((String)field.getTrimType(), (String)""));
            item.setText(10, Const.NVL((String)field.getNullString(), (String)""));
        }
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void getInfo(ConcatFieldsMeta meta) {
        meta.getExtraFields().setTargetFieldName(this.wTargetFieldName.getText());
        meta.getExtraFields().setTargetFieldLength(Const.toInt((String)this.wTargetFieldLength.getText(), (int)0));
        meta.setSeparator(this.wSeparator.getText());
        meta.setEnclosure(this.wEnclosure.getText());
        meta.getExtraFields().setRemoveSelectedFields(this.wRemove.getSelection());
        this.input.getOutputFields().clear();
        for (TableItem item : this.wFields.getNonEmptyItems()) {
            ConcatField field = new ConcatField();
            field.setName(item.getText(1));
            field.setType(item.getText(2));
            field.setFormat(item.getText(3));
            field.setLength(Const.toInt((String)item.getText(4), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(5), (int)-1));
            field.setCurrencySymbol(item.getText(6));
            field.setDecimalSymbol(item.getText(7));
            field.setGroupingSymbol(item.getText(8));
            field.setTrimType(item.getText(9));
            field.setNullString(item.getText(10));
            this.input.getOutputFields().add(field);
        }
    }

    private void ok() {
        if (StringUtil.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.input.setChanged();
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    if (v.isNumber() && v.getLength() > 0) {
                        int le = v.getLength();
                        int pr = v.getPrecision();
                        if (v.getPrecision() <= 0) {
                            pr = 0;
                        }
                        StringBuilder mask = new StringBuilder();
                        mask.append("0".repeat(Math.max(0, le - pr)));
                        if (pr > 0) {
                            mask.append(".");
                        }
                        mask.append("0".repeat(Math.max(0, pr)));
                        tableItem.setText(3, mask.toString());
                    }
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[]{2}, (int)4, (int)5, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void setMinimalWidth() {
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        block6: for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            item.setText(4, "");
            item.setText(5, "");
            item.setText(9, ValueMetaBase.getTrimTypeDesc((int)3));
            int type = ValueMetaBase.getType((String)item.getText(2));
            switch (type) {
                case 2: {
                    item.setText(3, "");
                    continue block6;
                }
                case 5: {
                    item.setText(3, "0");
                    continue block6;
                }
                case 1: {
                    item.setText(3, "0.#####");
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
        }
        this.wFields.optWidth(true);
    }
}

