/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.grpc.okhttp.internal.proxy;

import com.clickhouse.client.internal.grpc.okhttp.internal.Headers;
import com.clickhouse.client.internal.grpc.okhttp.internal.proxy.HttpUrl;

public final class Request {
    private final HttpUrl url;
    private final Headers headers;

    private Request(Builder builder) {
        this.url = builder.url;
        this.headers = builder.headers.build();
    }

    public HttpUrl httpUrl() {
        return this.url;
    }

    public Headers headers() {
        return this.headers;
    }

    public Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "Request{url=" + this.url + '}';
    }

    public static class Builder {
        private HttpUrl url;
        private Headers.Builder headers = new Headers.Builder();

        public Builder url(HttpUrl url) {
            if (url == null) {
                throw new IllegalArgumentException("url == null");
            }
            this.url = url;
            return this;
        }

        public Builder header(String name, String value) {
            this.headers.set(name, value);
            return this;
        }

        public Request build() {
            if (this.url == null) {
                throw new IllegalStateException("url == null");
            }
            return new Request(this);
        }
    }
}

