/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.banner;

import io.micronaut.context.banner.Banner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBanner
implements Banner {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceBanner.class);
    private final URL resource;
    private final PrintStream out;

    public ResourceBanner(URL resource, PrintStream out) {
        this.resource = resource;
        this.out = out;
    }

    @Override
    public void print() {
        block7: {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.resource.openStream(), StandardCharsets.UTF_8));){
                String banner = reader.lines().collect(Collectors.joining("\n"));
                this.out.println(banner + "\n");
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error("There was an error printing the banner.");
            }
        }
    }
}

