/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.api;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.lang.IgniteExceptionUtils;
import org.apache.ignite.internal.sql.api.AsyncResultSetImpl;
import org.apache.ignite.internal.sql.api.SessionBuilderImpl;
import org.apache.ignite.internal.sql.engine.AsyncCursor;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.QueryContext;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.sql.engine.QueryProperty;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.sql.engine.property.PropertiesHolder;
import org.apache.ignite.internal.sql.engine.property.Property;
import org.apache.ignite.internal.sql.engine.session.SessionId;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.sql.BatchedArguments;
import org.apache.ignite.sql.Session;
import org.apache.ignite.sql.SqlBatchException;
import org.apache.ignite.sql.SqlException;
import org.apache.ignite.sql.Statement;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.apache.ignite.sql.reactive.ReactiveResultSet;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class SessionImpl
implements Session {
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final QueryProcessor qryProc;
    private final SessionId sessionId;
    private final int pageSize;
    private final long sessionTimeout;
    private final PropertiesHolder props;

    SessionImpl(SessionId sessionId, QueryProcessor qryProc, int pageSize, long sessionTimeoutMs, PropertiesHolder props) {
        this.qryProc = qryProc;
        this.sessionId = sessionId;
        this.pageSize = pageSize;
        this.sessionTimeout = sessionTimeoutMs;
        this.props = props;
    }

    public long[] executeBatch(@Nullable Transaction transaction, Statement dmlStatement, BatchedArguments batch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void executeScript(String query, Object ... arguments) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public long defaultQueryTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.props.get(QueryProperty.QUERY_TIMEOUT), TimeUnit.MILLISECONDS);
    }

    public long idleTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.sessionTimeout, TimeUnit.MILLISECONDS);
    }

    public String defaultSchema() {
        return this.props.get(QueryProperty.DEFAULT_SCHEMA);
    }

    public int defaultPageSize() {
        return this.pageSize;
    }

    @Nullable
    public Object property(String name) {
        Property<?> prop = QueryProperty.byName(name);
        if (prop == null) {
            return null;
        }
        return this.props.get(prop);
    }

    public Session.SessionBuilder toBuilder() {
        return new SessionBuilderImpl(this.qryProc, new HashMap(this.props.toMap())).defaultPageSize(this.pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<AsyncResultSet> executeAsync(@Nullable Transaction transaction, String query, Object ... arguments) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new SqlException(ErrorGroups.Sql.SESSION_NOT_FOUND_ERR, "Session is closed."));
        }
        try {
            QueryContext ctx = QueryContext.of(transaction);
            CompletionStage result = this.qryProc.querySingleAsync(this.sessionId, ctx, query, arguments).thenCompose(cur -> cur.requestNextAsync(this.pageSize).thenApply(batchRes -> new AsyncResultSetImpl((AsyncSqlCursor<List<Object>>)cur, (AsyncCursor.BatchedResult<List<Object>>)batchRes, this.pageSize, () -> {})));
            ((CompletableFuture)result).whenComplete((rs, th) -> {
                if (Objects.equals(IgniteExceptionUtils.getIgniteErrorCode((Throwable)th), ErrorGroups.Sql.SESSION_NOT_FOUND_ERR)) {
                    this.closeInternal();
                }
            });
            CompletionStage completionStage = result;
            return completionStage;
        }
        catch (Exception e) {
            CompletableFuture<AsyncResultSet> completableFuture = CompletableFuture.failedFuture(e);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CompletableFuture<AsyncResultSet> executeAsync(@Nullable Transaction transaction, Statement statement, Object ... arguments) {
        return this.executeAsync(transaction, statement.query(), arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, String query, BatchedArguments batch) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new SqlException(ErrorGroups.Sql.SESSION_NOT_FOUND_ERR, "Session is closed."));
        }
        try {
            QueryContext ctx = QueryContext.of(transaction, plan -> {
                if (plan.type() != QueryPlan.Type.DML) {
                    throw new SqlException(ErrorGroups.Sql.QUERY_INVALID_ERR, "Invalid SQL statement type in the batch [plan=" + plan + "]");
                }
            });
            LongArrayList counters = new LongArrayList(batch.size());
            CompletionStage<Object> tail = CompletableFuture.completedFuture(null);
            ArrayList<CompletableFuture<Object>> batchFuts = new ArrayList<CompletableFuture<Object>>(batch.size());
            for (int i = 0; i < batch.size(); ++i) {
                Object[] args = ((List)batch.get(i)).toArray();
                CompletionStage qryFut = tail.thenCompose(v -> this.qryProc.querySingleAsync(this.sessionId, ctx, query, args));
                tail = ((CompletableFuture)((CompletableFuture)((CompletableFuture)qryFut).thenCompose(cur -> cur.requestNextAsync(1))).thenAccept(page -> {
                    SessionImpl.validateDmlResult(page);
                    counters.add(((Long)((List)page.items().get(0)).get(0)).longValue());
                })).whenComplete((arg_0, arg_1) -> SessionImpl.lambda$executeBatchAsync$8((CompletableFuture)qryFut, arg_0, arg_1));
                batchFuts.add((CompletableFuture<Object>)tail);
            }
            CompletionStage resFut = ((CompletableFuture)tail.exceptionally(ex -> {
                Throwable cause = ExceptionUtils.unwrapCause((Throwable)ex);
                throw new SqlBatchException(cause instanceof IgniteException ? ((IgniteException)cause).code() : ErrorGroups.Common.UNEXPECTED_ERR, counters.toArray(ArrayUtils.LONG_EMPTY_ARRAY), ex);
            })).thenApply(v -> counters.toArray(ArrayUtils.LONG_EMPTY_ARRAY));
            ((CompletableFuture)resFut).whenComplete((cur, ex) -> {
                if (ex instanceof CancellationException) {
                    batchFuts.forEach(f -> f.cancel(false));
                }
            });
            CompletionStage completionStage = resFut;
            return completionStage;
        }
        catch (Exception e) {
            CompletableFuture<long[]> completableFuture = CompletableFuture.failedFuture(e);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, Statement statement, BatchedArguments batch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public CompletableFuture<Void> executeScriptAsync(String query, Object ... arguments) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public ReactiveResultSet executeReactive(@Nullable Transaction transaction, String query, Object ... arguments) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public ReactiveResultSet executeReactive(@Nullable Transaction transaction, Statement statement, Object ... arguments) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public Flow.Publisher<Long> executeBatchReactive(@Nullable Transaction transaction, String query, BatchedArguments batch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public Flow.Publisher<Long> executeBatchReactive(@Nullable Transaction transaction, Statement statement, BatchedArguments batch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void close() {
        SessionImpl.await(this.closeAsync());
    }

    public CompletableFuture<Void> closeAsync() {
        this.closeInternal();
        return this.qryProc.closeSession(this.sessionId);
    }

    public Flow.Publisher<Void> closeReactive() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public static <T> T await(CompletionStage<T> stage) {
        try {
            return stage.toCompletableFuture().get();
        }
        catch (ExecutionException e) {
            throw new SqlException(ErrorGroups.Sql.OPERATION_INTERRUPTED_ERR, e.getCause());
        }
        catch (Throwable e) {
            throw new SqlException(ErrorGroups.Sql.OPERATION_INTERRUPTED_ERR, e);
        }
    }

    private void closeInternal() {
        if (this.closed.compareAndSet(false, true)) {
            this.busyLock.block();
        }
    }

    private static void validateDmlResult(AsyncCursor.BatchedResult<List<Object>> page) {
        if (page == null || page.items() == null || page.items().size() != 1 || page.items().get(0).size() != 1 || page.hasMore()) {
            throw new SqlException(ErrorGroups.Sql.INVALID_DML_RESULT_ERR, "Invalid DML results: " + page);
        }
    }

    private static /* synthetic */ void lambda$executeBatchAsync$8(CompletableFuture qryFut, Void v, Throwable ex) {
        if (ex instanceof CancellationException) {
            qryFut.cancel(false);
        }
    }
}

