/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Spool;
import org.apache.ignite.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.sql.engine.rel.IgniteFilter;
import org.apache.ignite.internal.sql.engine.rel.IgniteSortedIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableSpool;
import org.apache.ignite.internal.sql.engine.rule.ImmutableFilterSpoolMergeToSortedIndexSpoolRule;
import org.apache.ignite.internal.sql.engine.trait.CorrelationTrait;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.immutables.value.Value;

@Value.Enclosing
public class FilterSpoolMergeToSortedIndexSpoolRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    private FilterSpoolMergeToSortedIndexSpoolRule(Config cfg) {
        super((RelRule.Config)cfg);
    }

    public void onMatch(RelOptRuleCall call) {
        RelCollation searchCollation;
        RelCollation traitCollation;
        RelNode input;
        RelCollation inCollation;
        List<SearchBounds> searchBounds;
        IgniteFilter filter = (IgniteFilter)call.rel(0);
        IgniteTableSpool spool = (IgniteTableSpool)call.rel(1);
        RelOptCluster cluster = spool.getCluster();
        RelTraitSet trait = spool.getTraitSet();
        CorrelationTrait filterCorr = TraitUtils.correlation((RelNode)filter);
        if (filterCorr.correlated()) {
            trait = trait.replace((RelTrait)filterCorr);
        }
        if (CollectionUtils.nullOrEmpty(searchBounds = RexUtils.buildSortedIndexConditions(cluster, inCollation = TraitUtils.collation(input = spool.getInput()), filter.getCondition(), spool.getRowType(), null))) {
            return;
        }
        if (inCollation == null || inCollation.isDefault()) {
            IntArrayList equalsFields = new IntArrayList(searchBounds.size());
            IntArrayList otherFields = new IntArrayList(searchBounds.size());
            for (int i = 0; i < searchBounds.size(); ++i) {
                if (searchBounds.get(i) == null) continue;
                (searchBounds.get(i).type() == SearchBounds.Type.EXACT ? equalsFields : otherFields).add(i);
            }
            equalsFields.addAll((IntList)otherFields);
            searchCollation = traitCollation = TraitUtils.createCollation((Collection<Integer>)equalsFields);
        } else {
            traitCollation = inCollation;
            IntOpenHashSet searchKeys = new IntOpenHashSet();
            Ord.zip(searchBounds).stream().filter(v -> v.e != null).mapToInt(v -> v.i).forEach(arg_0 -> ((IntSet)searchKeys).add(arg_0));
            List collationFields = inCollation.getFieldCollations().subList(0, searchKeys.size());
            assert (searchKeys.containsAll((Collection)collationFields.stream().map(RelFieldCollation::getFieldIndex).collect(Collectors.toSet()))) : "Search condition should be a prefix of collation [searchKeys=" + (IntSet)searchKeys + ", collation=" + inCollation + "]";
            searchCollation = RelCollations.of(collationFields);
        }
        IgniteSortedIndexSpool res = new IgniteSortedIndexSpool(cluster, trait.replace((RelTrait)traitCollation), FilterSpoolMergeToSortedIndexSpoolRule.convert((RelNode)input, (RelTraitSet)input.getTraitSet().replace((RelTrait)traitCollation)), searchCollation, filter.getCondition(), searchBounds);
        call.transformTo((RelNode)res);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableFilterSpoolMergeToSortedIndexSpoolRule.Config.of().withDescription("FilterSpoolMergeToSortedIndexSpoolRule").withOperandFor(IgniteFilter.class, IgniteTableSpool.class);

        default public Config withOperandFor(Class<? extends Filter> filterClass, Class<? extends Spool> spoolClass) {
            return (Config)this.withOperandSupplier(o0 -> o0.operand(filterClass).oneInput(o1 -> o1.operand(spoolClass).anyInputs())).as(Config.class);
        }

        default public FilterSpoolMergeToSortedIndexSpoolRule toRule() {
            return new FilterSpoolMergeToSortedIndexSpoolRule(this);
        }
    }
}

