/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.session;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.CurrentTimeProvider;
import org.apache.ignite.internal.sql.engine.exec.LifecycleAware;
import org.apache.ignite.internal.sql.engine.property.PropertiesHolder;
import org.apache.ignite.internal.sql.engine.session.Session;
import org.apache.ignite.internal.sql.engine.session.SessionId;
import org.apache.ignite.internal.sql.engine.session.SessionInfo;
import org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.internal.util.worker.IgniteWorker;
import org.jetbrains.annotations.Nullable;

public class SessionManager
implements LifecycleAware {
    private static final IgniteLogger LOG = Loggers.forClass(SessionManager.class);
    private final Map<SessionId, Session> activeSessions = new ConcurrentHashMap<SessionId, Session>();
    private final CurrentTimeProvider timeProvider;
    private final IgniteWorker expirationWorker;
    private final AtomicBoolean startedFlag = new AtomicBoolean(false);

    public SessionManager(String igniteInstanceName, final long expirationCheckPeriod, CurrentTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        this.expirationWorker = new IgniteWorker(LOG, igniteInstanceName, "session_cleanup-thread", null){

            protected void body() throws InterruptedException {
                while (!this.isCancelled()) {
                    this.blockingSectionBegin();
                    try {
                        Thread.sleep(expirationCheckPeriod);
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                    SessionManager.this.activeSessions.values().stream().filter(Session::expired).forEach(s -> SessionManager.this.destroySession((Session)s));
                    LOG.debug("Expired SQL sessions has been cleaned up. Active sessions [count={}]", new Object[]{SessionManager.this.activeSessions.size()});
                }
            }
        };
    }

    public SessionId createSession(long idleTimeoutMs, PropertiesHolder queryProperties) {
        SessionId sessionId;
        AtomicBoolean applied = new AtomicBoolean(false);
        do {
            sessionId = this.nextSessionId();
            this.activeSessions.computeIfAbsent(sessionId, key -> {
                applied.set(true);
                return new Session((SessionId)key, this.timeProvider, idleTimeoutMs, queryProperties);
            });
        } while (!applied.get());
        return sessionId;
    }

    @Nullable
    public Session session(SessionId sessionId) {
        Session session = this.activeSessions.get(sessionId);
        if (session != null && !session.touch()) {
            this.destroySession(session);
            session = null;
        }
        return session;
    }

    public List<SessionInfo> liveSessions() {
        return this.activeSessions.values().stream().filter(s -> !s.expired()).map(SessionInfo::new).collect(Collectors.toList());
    }

    private void destroySession(Session session) {
        session.closeAsync();
        this.activeSessions.remove(session.sessionId());
    }

    private SessionId nextSessionId() {
        return new SessionId(UUID.randomUUID());
    }

    @Override
    public void start() {
        if (this.startedFlag.compareAndSet(false, true)) {
            IgniteThread expirationThread = new IgniteThread(this.expirationWorker);
            expirationThread.setDaemon(true);
            expirationThread.start();
        }
    }

    @Override
    public void stop() {
        this.expirationWorker.cancel();
    }
}

