/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite.internal.sql.engine.sql.IgniteAbstractSqlAlterTable;

public class IgniteSqlAlterTableAddColumn
extends IgniteAbstractSqlAlterTable {
    private final boolean ifNotExistsColumn;
    private final SqlNodeList columns;

    public IgniteSqlAlterTableAddColumn(SqlParserPos pos, boolean ifExists, SqlIdentifier tblName, boolean ifNotExistsColumn, SqlNodeList columns) {
        super(pos, ifExists, tblName);
        this.ifNotExistsColumn = ifNotExistsColumn;
        this.columns = Objects.requireNonNull(columns, "columns list");
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.columns);
    }

    @Override
    protected void unparseAlterTableOperation(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ADD");
        writer.keyword("COLUMN");
        if (this.ifNotExistsColumn) {
            writer.keyword("IF NOT EXISTS");
        }
        this.columns.unparse(writer, leftPrec, rightPrec);
    }

    public boolean ifNotExistsColumn() {
        return this.ifNotExistsColumn;
    }

    public SqlNodeList columns() {
        return this.columns;
    }
}

