/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.sql;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.client.sql.ClientStatement;
import org.apache.ignite.sql.Statement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientStatementBuilder
implements Statement.StatementBuilder {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private String query;
    private String defaultSchema;
    private Long queryTimeoutMs;
    private Integer pageSize;

    @NotNull
    public String query() {
        return this.query;
    }

    public Statement.StatementBuilder query(String sql) {
        this.query = sql;
        return this;
    }

    public long queryTimeout(@NotNull TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit);
        return timeUnit.convert(this.queryTimeoutMs == null ? 0L : this.queryTimeoutMs, TimeUnit.MILLISECONDS);
    }

    public Statement.StatementBuilder queryTimeout(long timeout, @NotNull TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit);
        this.queryTimeoutMs = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        return this;
    }

    public String defaultSchema() {
        return this.defaultSchema;
    }

    public Statement.StatementBuilder defaultSchema(@NotNull String schema) {
        this.defaultSchema = schema;
        return this;
    }

    public int pageSize() {
        return this.pageSize == null ? 0 : this.pageSize;
    }

    public Statement.StatementBuilder pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Nullable
    public Object property(@NotNull String name) {
        return this.properties.get(name);
    }

    public Statement.StatementBuilder property(@NotNull String name, @Nullable Object value) {
        this.properties.put(name, value);
        return this;
    }

    public Statement build() {
        return new ClientStatement(this.query, this.defaultSchema, this.queryTimeoutMs, this.pageSize, new HashMap<String, Object>(this.properties));
    }
}

