/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.client.ClientUtils;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.table.ClientTupleSerializer;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.NullableValue;
import org.apache.ignite.table.InvokeProcessor;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientKeyValueBinaryView
implements KeyValueView<Tuple, Tuple> {
    private final ClientTable tbl;
    private final ClientTupleSerializer ser;

    public ClientKeyValueBinaryView(ClientTable tbl) {
        assert (tbl != null);
        this.tbl = tbl;
        this.ser = new ClientTupleSerializer(tbl.tableId());
    }

    public Tuple get(@Nullable Transaction tx, @NotNull Tuple key) {
        return ClientUtils.sync(this.getAsync(tx, key));
    }

    @NotNull
    public CompletableFuture<Tuple> getAsync(@Nullable Transaction tx, @NotNull Tuple key) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutInOpAsync(12, (s, w) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, true), ClientTupleSerializer::readValueTuple, null, ClientTupleSerializer.getHashFunction(tx, key));
    }

    public Map<Tuple, Tuple> getAll(@Nullable Transaction tx, @NotNull Collection<Tuple> keys) {
        return ClientUtils.sync(this.getAllAsync(tx, keys));
    }

    @NotNull
    public CompletableFuture<Map<Tuple, Tuple>> getAllAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> keys) {
        Objects.requireNonNull(keys);
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return this.tbl.doSchemaOutInOpAsync(15, (s, w) -> this.ser.writeTuples(tx, keys, (ClientSchema)s, (PayloadOutputChannel)w, true), ClientTupleSerializer::readKvTuplesNullable, Collections.emptyMap(), ClientTupleSerializer.getHashFunction(tx, keys.iterator().next()));
    }

    public NullableValue<Tuple> getNullable(@Nullable Transaction tx, @NotNull Tuple key) {
        throw new UnsupportedOperationException("Binary view doesn't allow null tuples.");
    }

    @NotNull
    public CompletableFuture<NullableValue<Tuple>> getNullableAsync(@Nullable Transaction tx, @NotNull Tuple key) {
        throw new UnsupportedOperationException("Binary view doesn't allow null tuples.");
    }

    public Tuple getOrDefault(@Nullable Transaction tx, @NotNull Tuple key, Tuple defaultValue) {
        return this.getOrDefaultAsync(tx, key, defaultValue).join();
    }

    @NotNull
    public CompletableFuture<Tuple> getOrDefaultAsync(@Nullable Transaction tx, @NotNull Tuple key, Tuple defaultValue) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutInOpAsync(12, (s, w) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, true), (s, r) -> (Tuple)IgniteUtils.nonNullOrElse((Object)ClientTupleSerializer.readValueTuple(s, r), (Object)defaultValue), null, ClientTupleSerializer.getHashFunction(tx, key));
    }

    public boolean contains(@Nullable Transaction tx, @NotNull Tuple key) {
        return ClientUtils.sync(this.containsAsync(tx, key));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, @NotNull Tuple key) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(33, (s, w) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, true), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, key));
    }

    public void put(@Nullable Transaction tx, @NotNull Tuple key, Tuple val) {
        ClientUtils.sync(this.putAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, @NotNull Tuple key, Tuple val) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(10, (s, w) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, false), r -> null, ClientTupleSerializer.getHashFunction(tx, key));
    }

    public void putAll(@Nullable Transaction tx, @NotNull Map<Tuple, Tuple> pairs) {
        ClientUtils.sync(this.putAllAsync(tx, pairs));
    }

    @NotNull
    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, @NotNull Map<Tuple, Tuple> pairs) {
        Objects.requireNonNull(pairs);
        if (pairs.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.tbl.doSchemaOutOpAsync(13, (s, w) -> this.ser.writeKvTuples(tx, pairs, (ClientSchema)s, (PayloadOutputChannel)w), r -> null, ClientTupleSerializer.getHashFunction(tx, pairs.keySet().iterator().next()));
    }

    public Tuple getAndPut(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        return ClientUtils.sync(this.getAndPutAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<Tuple> getAndPutAsync(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(val);
        return this.tbl.doSchemaOutInOpAsync(16, (s, w) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, false), ClientTupleSerializer::readValueTuple, null, ClientTupleSerializer.getHashFunction(tx, key));
    }

    public NullableValue<Tuple> getNullableAndPut(@Nullable Transaction tx, @NotNull Tuple key, Tuple val) {
        throw new UnsupportedOperationException("Binary view doesn't allow null tuples.");
    }

    @NotNull
    public CompletableFuture<NullableValue<Tuple>> getNullableAndPutAsync(@Nullable Transaction tx, @NotNull Tuple key, Tuple val) {
        throw new UnsupportedOperationException("Binary view doesn't allow null tuples.");
    }

    public boolean putIfAbsent(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        return ClientUtils.sync(this.putIfAbsentAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, @NotNull Tuple key, Tuple val) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(18, (s, w) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, false), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, key));
    }

    public boolean remove(@Nullable Transaction tx, @NotNull Tuple key) {
        return ClientUtils.sync(this.removeAsync(tx, key));
    }

    public boolean remove(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        return ClientUtils.sync(this.removeAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, @NotNull Tuple key) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(28, (s, w) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, true), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, key));
    }

    @NotNull
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(val);
        return this.tbl.doSchemaOutOpAsync(30, (s, w) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, false), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, key));
    }

    public Collection<Tuple> removeAll(@Nullable Transaction tx, @NotNull Collection<Tuple> keys) {
        return ClientUtils.sync(this.removeAllAsync(tx, keys));
    }

    @NotNull
    public CompletableFuture<Collection<Tuple>> removeAllAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> keys) {
        Objects.requireNonNull(keys);
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.tbl.doSchemaOutInOpAsync(29, (s, w) -> this.ser.writeTuples(tx, keys, (ClientSchema)s, (PayloadOutputChannel)w, true), (s, r) -> ClientTupleSerializer.readTuples(s, r, true), Collections.emptyList(), ClientTupleSerializer.getHashFunction(tx, keys.iterator().next()));
    }

    public Tuple getAndRemove(@Nullable Transaction tx, @NotNull Tuple key) {
        return ClientUtils.sync(this.getAndRemoveAsync(tx, key));
    }

    @NotNull
    public CompletableFuture<Tuple> getAndRemoveAsync(@Nullable Transaction tx, @NotNull Tuple key) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutInOpAsync(32, (s, w) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, true), ClientTupleSerializer::readValueTuple, null, ClientTupleSerializer.getHashFunction(tx, key));
    }

    public NullableValue<Tuple> getNullableAndRemove(@Nullable Transaction tx, @NotNull Tuple key) {
        throw new UnsupportedOperationException("Binary view doesn't allow null tuples.");
    }

    @NotNull
    public CompletableFuture<NullableValue<Tuple>> getNullableAndRemoveAsync(@Nullable Transaction tx, @NotNull Tuple key) {
        throw new UnsupportedOperationException("Binary view doesn't allow null tuples.");
    }

    public boolean replace(@Nullable Transaction tx, @NotNull Tuple key, Tuple val) {
        return ClientUtils.sync(this.replaceAsync(tx, key, val));
    }

    public boolean replace(@Nullable Transaction tx, @NotNull Tuple key, Tuple oldVal, Tuple newVal) {
        return ClientUtils.sync(this.replaceAsync(tx, key, oldVal, newVal));
    }

    @NotNull
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, @NotNull Tuple key, Tuple val) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(22, (s, w) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, false), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, key));
    }

    @NotNull
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, @NotNull Tuple key, Tuple oldVal, Tuple newVal) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(24, (s, w) -> {
            this.ser.writeKvTuple(tx, key, oldVal, (ClientSchema)s, (PayloadOutputChannel)w, false);
            this.ser.writeKvTuple(tx, key, newVal, (ClientSchema)s, (PayloadOutputChannel)w, true);
        }, ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, key));
    }

    public Tuple getAndReplace(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        return ClientUtils.sync(this.getAndReplaceAsync(tx, key, val));
    }

    @NotNull
    public CompletableFuture<Tuple> getAndReplaceAsync(@Nullable Transaction tx, @NotNull Tuple key, @NotNull Tuple val) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(val);
        return this.tbl.doSchemaOutInOpAsync(26, (s, w) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, false), ClientTupleSerializer::readValueTuple, null, ClientTupleSerializer.getHashFunction(tx, key));
    }

    public NullableValue<Tuple> getNullableAndReplace(@Nullable Transaction tx, @NotNull Tuple key, Tuple val) {
        throw new UnsupportedOperationException("Binary view doesn't allow null tuples.");
    }

    @NotNull
    public CompletableFuture<NullableValue<Tuple>> getNullableAndReplaceAsync(@Nullable Transaction tx, @NotNull Tuple key, Tuple val) {
        throw new UnsupportedOperationException("Binary view doesn't allow null tuples.");
    }

    public <R extends Serializable> R invoke(@Nullable Transaction tx, @NotNull Tuple key, InvokeProcessor<Tuple, Tuple, R> proc, Serializable ... args) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @NotNull
    public <R extends Serializable> CompletableFuture<R> invokeAsync(@Nullable Transaction tx, @NotNull Tuple key, InvokeProcessor<Tuple, Tuple, R> proc, Serializable ... args) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public <R extends Serializable> Map<Tuple, R> invokeAll(@Nullable Transaction tx, @NotNull Collection<Tuple> keys, InvokeProcessor<Tuple, Tuple, R> proc, Serializable ... args) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @NotNull
    public <R extends Serializable> CompletableFuture<Map<Tuple, R>> invokeAllAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> keys, InvokeProcessor<Tuple, Tuple, R> proc, Serializable ... args) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }
}

