/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.StringConcatFactory;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.conf.Configuration;
import org.apache.ignite.raft.jraft.conf.ConfigurationEntry;
import org.apache.ignite.raft.jraft.conf.ConfigurationManager;
import org.apache.ignite.raft.jraft.entity.EnumOutter;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.entity.LogId;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryDecoder;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryEncoder;
import org.apache.ignite.raft.jraft.option.LogStorageOptions;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.storage.LogStorage;
import org.apache.ignite.raft.jraft.util.BytesUtil;
import org.apache.ignite.raft.jraft.util.Describer;
import org.apache.ignite.raft.jraft.util.Requires;
import org.apache.ignite.raft.jraft.util.Utils;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDbSharedLogStorage
implements LogStorage,
Describer {
    private static final IgniteLogger LOG = Loggers.forClass(RocksDbSharedLogStorage.class);
    private static final VarHandle LONG_ARRAY_HANDLE;
    private static final byte[] FIRST_LOG_IDX_KEY;
    private final RocksDB db;
    private final ColumnFamilyHandle confHandle;
    private final ColumnFamilyHandle dataHandle;
    private final WriteOptions writeOptions;
    private final byte[] groupStartPrefix;
    private final byte[] groupEndPrefix;
    private final Slice groupStartBound;
    private final Slice groupEndBound;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock useLock = this.readWriteLock.readLock();
    private final Lock manageLock = this.readWriteLock.writeLock();
    private boolean stopped = false;
    private final Executor executor;
    private LogEntryEncoder logEntryEncoder;
    private LogEntryDecoder logEntryDecoder;
    private volatile long firstLogIndex = 1L;
    private volatile boolean hasLoadFirstLogIndex;

    RocksDbSharedLogStorage(RocksDB db, ColumnFamilyHandle confHandle, ColumnFamilyHandle dataHandle, String groupId, RaftOptions raftOptions, Executor executor) {
        Requires.requireNonNull(db);
        Requires.requireNonNull(confHandle);
        Requires.requireNonNull(dataHandle);
        Requires.requireNonNull(executor);
        Requires.requireTrue(groupId.indexOf(0) == -1, "Raft group id " + groupId + " must not contain char(0)");
        Requires.requireTrue(groupId.indexOf(1) == -1, "Raft group id " + groupId + " must not contain char(1)");
        this.db = db;
        this.confHandle = confHandle;
        this.dataHandle = dataHandle;
        this.executor = executor;
        this.groupStartPrefix = (groupId + "\u0000").getBytes(StandardCharsets.UTF_8);
        this.groupEndPrefix = ((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0001"}, (String)groupId))).getBytes(StandardCharsets.UTF_8);
        this.groupStartBound = new Slice(this.groupStartPrefix);
        this.groupEndBound = new Slice(this.groupEndPrefix);
        this.writeOptions = new WriteOptions();
        this.writeOptions.setSync(raftOptions.isSync());
    }

    @Override
    public boolean init(LogStorageOptions opts) {
        Requires.requireNonNull(opts.getConfigurationManager(), "Null conf manager");
        Requires.requireNonNull(opts.getLogEntryCodecFactory(), "Null log entry codec factory");
        this.manageLock.lock();
        try {
            this.logEntryDecoder = opts.getLogEntryCodecFactory().decoder();
            this.logEntryEncoder = opts.getLogEntryCodecFactory().encoder();
            Requires.requireNonNull(this.logEntryDecoder, "Null log entry decoder");
            Requires.requireNonNull(this.logEntryEncoder, "Null log entry encoder");
            boolean bl = this.initAndLoad(opts.getConfigurationManager());
            return bl;
        }
        finally {
            this.manageLock.unlock();
        }
    }

    private boolean initAndLoad(ConfigurationManager configurationManager) {
        this.hasLoadFirstLogIndex = false;
        this.firstLogIndex = 1L;
        this.load(configurationManager);
        return this.onInitLoaded();
    }

    private void load(ConfigurationManager confManager) {
        try (ReadOptions readOptions = new ReadOptions().setIterateUpperBound((AbstractSlice)this.groupEndBound);
             RocksIterator it = this.db.newIterator(this.confHandle, readOptions);){
            it.seek(this.groupStartPrefix);
            while (it.isValid()) {
                byte[] keyWithPrefix = it.key();
                byte[] ks = this.getKey(keyWithPrefix);
                byte[] bs = it.value();
                if (ks.length == 8) {
                    LogEntry entry = this.logEntryDecoder.decode(bs);
                    if (entry != null) {
                        if (entry.getType() == EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
                            ConfigurationEntry confEntry = new ConfigurationEntry();
                            confEntry.setId(new LogId(entry.getId().getIndex(), entry.getId().getTerm()));
                            confEntry.setConf(new Configuration(entry.getPeers(), entry.getLearners()));
                            if (entry.getOldPeers() != null) {
                                confEntry.setOldConf(new Configuration(entry.getOldPeers(), entry.getOldLearners()));
                            }
                            if (confManager != null) {
                                confManager.add(confEntry);
                            }
                        }
                    } else {
                        LOG.warn("Fail to decode conf entry at index {}, the log data is: {}.", new Object[]{LONG_ARRAY_HANDLE.get(ks, 0), BytesUtil.toHex(bs)});
                    }
                } else if (Arrays.equals(FIRST_LOG_IDX_KEY, ks)) {
                    this.setFirstLogIndex(LONG_ARRAY_HANDLE.get(bs, 0));
                    this.truncatePrefixInBackground(0L, this.firstLogIndex);
                } else {
                    LOG.warn("Unknown entry in configuration storage key={}, value={}.", new Object[]{BytesUtil.toHex(ks), BytesUtil.toHex(bs)});
                }
                it.next();
            }
        }
    }

    private byte[] getKey(byte[] ks) {
        return Arrays.copyOfRange(ks, this.groupStartPrefix.length, ks.length);
    }

    private void setFirstLogIndex(long index) {
        this.firstLogIndex = index;
        this.hasLoadFirstLogIndex = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveFirstLogIndex(long firstLogIndex) {
        this.useLock.lock();
        try {
            byte[] vs = new byte[8];
            LONG_ARRAY_HANDLE.set(vs, 0, firstLogIndex);
            this.db.put(this.confHandle, this.writeOptions, this.createKey(FIRST_LOG_IDX_KEY), vs);
            boolean bl = true;
            return bl;
        }
        catch (RocksDBException e) {
            LOG.error("Fail to save first log index {}.", (Throwable)e, new Object[]{firstLogIndex});
            boolean bl = false;
            return bl;
        }
        finally {
            this.useLock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.manageLock.lock();
        try {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            this.onShutdown();
        }
        finally {
            this.manageLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getFirstLogIndex() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getLastLogIndex() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogEntry getEntry(long index) {
        this.useLock.lock();
        try {
            if (this.hasLoadFirstLogIndex && index < this.firstLogIndex) {
                LogEntry logEntry = null;
                return logEntry;
            }
            byte[] keyBytes = this.createKey(index);
            byte[] bs = this.getValueFromRocksDb(keyBytes);
            if (bs != null) {
                LogEntry entry = this.logEntryDecoder.decode(bs);
                if (entry != null) {
                    LogEntry logEntry = entry;
                    return logEntry;
                }
                LOG.error("Bad log entry format for index={}, the log data is: {}.", new Object[]{index, BytesUtil.toHex(bs)});
                LogEntry logEntry = null;
                return logEntry;
            }
        }
        catch (RocksDBException e) {
            LOG.error("Fail to get log entry at index {}.", (Throwable)e, new Object[]{index});
        }
        finally {
            this.useLock.unlock();
        }
        return null;
    }

    protected byte[] getValueFromRocksDb(byte[] keyBytes) throws RocksDBException {
        return this.db.get(this.dataHandle, keyBytes);
    }

    @Override
    public long getTerm(long index) {
        LogEntry entry = this.getEntry(index);
        if (entry != null) {
            return entry.getId().getTerm();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean appendEntry(LogEntry entry) {
        if (entry.getType() == EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
            return this.executeBatch(batch -> this.addConfBatch(entry, batch));
        }
        this.useLock.lock();
        try {
            if (this.stopped) {
                LOG.warn("Storage stopped.", new Object[0]);
                boolean bl = false;
                return bl;
            }
            WriteContext writeCtx = this.newWriteContext();
            long logIndex = entry.getId().getIndex();
            byte[] valueBytes = this.logEntryEncoder.encode(entry);
            byte[] newValueBytes = this.onDataAppend(logIndex, valueBytes, writeCtx);
            writeCtx.startJob();
            this.db.put(this.dataHandle, this.writeOptions, this.createKey(logIndex), newValueBytes);
            writeCtx.joinAll();
            if (newValueBytes != valueBytes) {
                this.doSync();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | RocksDBException e) {
            LOG.error("Fail to append entry.", e);
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            this.useLock.unlock();
        }
    }

    @Override
    public int appendEntries(List<LogEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return 0;
        }
        int entriesCount = entries.size();
        boolean ret = this.executeBatch(batch -> {
            WriteContext writeCtx = this.newWriteContext();
            for (LogEntry entry : entries) {
                if (entry.getType() == EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
                    this.addConfBatch(entry, batch);
                    continue;
                }
                writeCtx.startJob();
                this.addDataBatch(entry, batch, writeCtx);
            }
            writeCtx.joinAll();
            this.doSync();
        });
        if (ret) {
            return entriesCount;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncateSuffix(long lastIndexKept) {
        this.useLock.lock();
        try {
            try {
                this.onTruncateSuffix(lastIndexKept);
            }
            finally {
                this.db.deleteRange(this.dataHandle, this.writeOptions, this.createKey(lastIndexKept + 1L), this.createKey(this.getLastLogIndex() + 1L));
                this.db.deleteRange(this.confHandle, this.writeOptions, this.createKey(lastIndexKept + 1L), this.createKey(this.getLastLogIndex() + 1L));
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | RocksDBException e) {
            LOG.error("Fail to truncateSuffix {}.", e, new Object[]{lastIndexKept});
        }
        finally {
            this.useLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reset(long nextLogIndex) {
        if (nextLogIndex <= 0L) {
            throw new IllegalArgumentException("Invalid next log index.");
        }
        this.manageLock.lock();
        LogEntry entry = this.getEntry(nextLogIndex);
        try {
            this.db.deleteRange(this.dataHandle, this.groupStartPrefix, this.groupEndPrefix);
            this.db.deleteRange(this.confHandle, this.groupStartPrefix, this.groupEndPrefix);
            this.onReset(nextLogIndex);
            if (this.initAndLoad(null)) {
                if (entry == null) {
                    entry = new LogEntry();
                    entry.setType(EnumOutter.EntryType.ENTRY_TYPE_NO_OP);
                    entry.setId(new LogId(nextLogIndex, 0L));
                    LOG.warn("Entry not found for nextLogIndex {} when reset.", new Object[]{nextLogIndex});
                }
                boolean bl = this.appendEntry(entry);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (RocksDBException e) {
            LOG.error("Fail to reset next log index.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.manageLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncatePrefix(long firstIndexKept) {
        this.useLock.lock();
        try {
            long startIndex = this.getFirstLogIndex();
            boolean ret = this.saveFirstLogIndex(firstIndexKept);
            if (ret) {
                this.setFirstLogIndex(firstIndexKept);
            }
            this.truncatePrefixInBackground(startIndex, firstIndexKept);
            boolean bl = ret;
            return bl;
        }
        finally {
            this.useLock.unlock();
        }
    }

    private void addConfBatch(LogEntry entry, WriteBatch batch) throws RocksDBException {
        byte[] ks = this.createKey(entry.getId().getIndex());
        byte[] content = this.logEntryEncoder.encode(entry);
        batch.put(this.dataHandle, ks, content);
        batch.put(this.confHandle, ks, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeBatch(WriteBatchTemplate template) {
        this.useLock.lock();
        try (WriteBatch batch = new WriteBatch();){
            if (this.stopped) {
                LOG.warn("Storage stopped.", new Object[0]);
                boolean bl = false;
                return bl;
            }
            template.execute(batch);
            this.db.write(this.writeOptions, batch);
        }
        catch (RocksDBException e) {
            LOG.error("Execute batch failed with rocksdb exception.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Execute batch failed with io exception.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            LOG.error("Execute batch failed with interrupt.", (Throwable)e);
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            this.useLock.unlock();
        }
        return true;
    }

    private void addDataBatch(LogEntry entry, WriteBatch batch, WriteContext ctx) throws RocksDBException, IOException, InterruptedException {
        long logIndex = entry.getId().getIndex();
        byte[] content = this.logEntryEncoder.encode(entry);
        batch.put(this.dataHandle, this.createKey(logIndex), this.onDataAppend(logIndex, content, ctx));
    }

    private void truncatePrefixInBackground(long startIndex, long firstIndexKept) {
        Utils.runInThread(this.executor, () -> {
            this.useLock.lock();
            try {
                if (this.stopped) {
                    return;
                }
                this.onTruncatePrefix(startIndex, firstIndexKept);
                byte[] startKey = this.createKey(startIndex);
                byte[] endKey = this.createKey(firstIndexKept);
                this.db.deleteRange(this.dataHandle, startKey, endKey);
                this.db.deleteRange(this.confHandle, startKey, endKey);
            }
            catch (IOException | RocksDBException e) {
                LOG.error("Fail to truncatePrefix {}.", e, new Object[]{firstIndexKept});
            }
            finally {
                this.useLock.unlock();
            }
        });
    }

    protected void onShutdown() {
        this.writeOptions.close();
        this.groupEndBound.close();
        this.groupStartBound.close();
    }

    private byte[] createKey(byte[] key) {
        byte[] buffer = new byte[this.groupStartPrefix.length + key.length];
        System.arraycopy(this.groupStartPrefix, 0, buffer, 0, this.groupStartPrefix.length);
        System.arraycopy(key, 0, buffer, this.groupStartPrefix.length, key.length);
        return buffer;
    }

    private byte[] createKey(long index) {
        byte[] ks = new byte[this.groupStartPrefix.length + 8];
        System.arraycopy(this.groupStartPrefix, 0, ks, 0, this.groupStartPrefix.length);
        LONG_ARRAY_HANDLE.set(ks, this.groupStartPrefix.length, index);
        return ks;
    }

    private void doSync() throws IOException, InterruptedException {
        this.onSync();
    }

    protected WriteContext newWriteContext() {
        return EmptyWriteContext.INSTANCE;
    }

    protected byte[] onDataAppend(long logIndex, byte[] value, WriteContext ctx) throws IOException, InterruptedException {
        ctx.finishJob();
        return value;
    }

    protected void onSync() throws IOException, InterruptedException {
    }

    protected boolean onInitLoaded() {
        return true;
    }

    protected void onReset(long nextLogIndex) {
    }

    protected void onTruncatePrefix(long startIndex, long firstIndexKept) throws RocksDBException, IOException {
    }

    protected void onTruncateSuffix(long lastIndexKept) throws RocksDBException, IOException {
    }

    @Override
    public void describe(Describer.Printer out) {
        this.useLock.lock();
        try {
            if (this.db != null) {
                out.println(this.db.getProperty("rocksdb.stats"));
            }
        }
        catch (RocksDBException e) {
            out.println((Object)e);
        }
        finally {
            this.useLock.unlock();
        }
    }

    static {
        RocksDB.loadLibrary();
        LONG_ARRAY_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);
        FIRST_LOG_IDX_KEY = Utils.getBytes("meta/firstLogIndex");
    }

    public static interface WriteContext {
        default public void startJob() {
        }

        default public void finishJob() {
        }

        default public void addFinishHook(Runnable r) {
        }

        default public void setError(Exception e) {
        }

        default public void joinAll() throws InterruptedException, IOException {
        }
    }

    private static interface WriteBatchTemplate {
        public void execute(WriteBatch var1) throws RocksDBException, IOException, InterruptedException;
    }

    private static class EmptyWriteContext
    implements WriteContext {
        static EmptyWriteContext INSTANCE = new EmptyWriteContext();

        private EmptyWriteContext() {
        }
    }
}

