/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.ignite.raft.jraft.util.Requires;

public final class BytesUtil {
    public static final byte[] EMPTY_BYTES = new byte[0];
    private static final ByteArrayComparator BYTES_LEXICO_COMPARATOR = new LexicographicByteArrayComparator();
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static byte[] nullToEmpty(byte[] bytes) {
        return bytes == null ? EMPTY_BYTES : bytes;
    }

    public static boolean isEmpty(byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }

    public static byte[] nextBytes(byte[] bytes) {
        Requires.requireNonNull(bytes, "bytes");
        int len = bytes.length;
        if (len == 0) {
            return new byte[]{0};
        }
        byte[] nextBytes = new byte[len + 1];
        System.arraycopy(bytes, 0, nextBytes, 0, len);
        nextBytes[len] = 0;
        return nextBytes;
    }

    public static ByteArrayComparator getDefaultByteArrayComparator() {
        return BYTES_LEXICO_COMPARATOR;
    }

    public static int compare(byte[] a, byte[] b) {
        return BytesUtil.getDefaultByteArrayComparator().compare(a, b);
    }

    public static byte[] max(byte[] a, byte[] b) {
        return BytesUtil.getDefaultByteArrayComparator().compare(a, b) > 0 ? a : b;
    }

    public static byte[] min(byte[] a, byte[] b) {
        return BytesUtil.getDefaultByteArrayComparator().compare(a, b) < 0 ? a : b;
    }

    public static String toHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hexStringToByteArray(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            bytes[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return bytes;
    }

    private BytesUtil() {
    }

    private static class LexicographicByteArrayComparator
    implements ByteArrayComparator {
        private static final long serialVersionUID = -8623342242397267864L;

        private LexicographicByteArrayComparator() {
        }

        @Override
        public int compare(byte[] buffer1, byte[] buffer2) {
            return this.compare(buffer1, 0, buffer1.length, buffer2, 0, buffer2.length);
        }

        @Override
        public int compare(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
            if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                return 0;
            }
            int end1 = offset1 + length1;
            int end2 = offset2 + length2;
            int i = offset1;
            for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
                int a = buffer1[i] & 0xFF;
                int b = buffer2[j] & 0xFF;
                if (a == b) continue;
                return a - b;
            }
            return length1 - length2;
        }
    }

    public static interface ByteArrayComparator
    extends Comparator<byte[]>,
    Serializable {
        public int compare(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);
    }
}

