/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.restart;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.restart.IgniteAttachmentLock;
import org.apache.ignite.internal.restart.RestartProofTable;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.Table;
import org.jetbrains.annotations.Nullable;

class RestartProofIgniteTables
implements IgniteTables,
Wrapper {
    private final IgniteAttachmentLock attachmentLock;

    RestartProofIgniteTables(IgniteAttachmentLock attachmentLock) {
        this.attachmentLock = attachmentLock;
    }

    public List<Table> tables() {
        return this.attachmentLock.attached(ignite -> {
            List tables = ignite.tables().tables();
            return this.wrapTables(tables, (Ignite)ignite);
        });
    }

    public CompletableFuture<List<Table>> tablesAsync() {
        return this.attachmentLock.attachedAsync(ignite -> ignite.tables().tablesAsync().thenApply(tables -> this.wrapTables((List<Table>)tables, (Ignite)ignite)));
    }

    public Table table(QualifiedName name) {
        return this.attachmentLock.attached(ignite -> {
            Table table = ignite.tables().table(name);
            return this.wrapTable(table, (Ignite)ignite);
        });
    }

    public CompletableFuture<Table> tableAsync(QualifiedName name) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.tables().tableAsync(name).thenApply(table -> this.wrapTable((Table)table, (Ignite)ignite)));
    }

    @Nullable
    private Table wrapTable(@Nullable Table table, Ignite ignite) {
        if (table == null) {
            return null;
        }
        return new RestartProofTable(this.attachmentLock, ignite, RestartProofTable.tableId(table));
    }

    private List<Table> wrapTables(List<Table> tables, Ignite ignite) {
        return tables.stream().map(table -> this.wrapTable((Table)table, ignite)).collect(Collectors.toList());
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)this.attachmentLock.attached(ignite -> Wrappers.unwrap((Object)ignite.tables(), (Class)classToUnwrap));
    }
}

