/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server;

import org.apache.seata.core.exception.AbstractExceptionHandler;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.protocol.transaction.AbstractGlobalEndRequest;
import org.apache.seata.core.protocol.transaction.AbstractGlobalEndResponse;
import org.apache.seata.core.protocol.transaction.AbstractTransactionRequest;
import org.apache.seata.core.protocol.transaction.AbstractTransactionResponse;
import org.apache.seata.core.protocol.transaction.BranchRegisterRequest;
import org.apache.seata.core.protocol.transaction.BranchRegisterResponse;
import org.apache.seata.core.protocol.transaction.BranchReportRequest;
import org.apache.seata.core.protocol.transaction.BranchReportResponse;
import org.apache.seata.core.protocol.transaction.GlobalBeginRequest;
import org.apache.seata.core.protocol.transaction.GlobalBeginResponse;
import org.apache.seata.core.protocol.transaction.GlobalCommitRequest;
import org.apache.seata.core.protocol.transaction.GlobalCommitResponse;
import org.apache.seata.core.protocol.transaction.GlobalLockQueryRequest;
import org.apache.seata.core.protocol.transaction.GlobalLockQueryResponse;
import org.apache.seata.core.protocol.transaction.GlobalReportRequest;
import org.apache.seata.core.protocol.transaction.GlobalReportResponse;
import org.apache.seata.core.protocol.transaction.GlobalRollbackRequest;
import org.apache.seata.core.protocol.transaction.GlobalRollbackResponse;
import org.apache.seata.core.protocol.transaction.GlobalStatusRequest;
import org.apache.seata.core.protocol.transaction.GlobalStatusResponse;
import org.apache.seata.core.protocol.transaction.TCInboundHandler;
import org.apache.seata.core.rpc.RpcContext;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTCInboundHandler
extends AbstractExceptionHandler
implements TCInboundHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTCInboundHandler.class);

    public GlobalBeginResponse handle(GlobalBeginRequest request, RpcContext rpcContext) {
        GlobalBeginResponse response = new GlobalBeginResponse();
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new /* Unavailable Anonymous Inner Class!! */, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected abstract void doGlobalBegin(GlobalBeginRequest var1, GlobalBeginResponse var2, RpcContext var3) throws TransactionException;

    public GlobalCommitResponse handle(GlobalCommitRequest request, RpcContext rpcContext) {
        GlobalCommitResponse response = new GlobalCommitResponse();
        response.setGlobalStatus(GlobalStatus.Committing);
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new /* Unavailable Anonymous Inner Class!! */, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected abstract void doGlobalCommit(GlobalCommitRequest var1, GlobalCommitResponse var2, RpcContext var3) throws TransactionException;

    public GlobalRollbackResponse handle(GlobalRollbackRequest request, RpcContext rpcContext) {
        GlobalRollbackResponse response = new GlobalRollbackResponse();
        response.setGlobalStatus(GlobalStatus.Rollbacking);
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new /* Unavailable Anonymous Inner Class!! */, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected abstract void doGlobalRollback(GlobalRollbackRequest var1, GlobalRollbackResponse var2, RpcContext var3) throws TransactionException;

    public BranchRegisterResponse handle(BranchRegisterRequest request, RpcContext rpcContext) {
        BranchRegisterResponse response = new BranchRegisterResponse();
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new /* Unavailable Anonymous Inner Class!! */, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected abstract void doBranchRegister(BranchRegisterRequest var1, BranchRegisterResponse var2, RpcContext var3) throws TransactionException;

    public BranchReportResponse handle(BranchReportRequest request, RpcContext rpcContext) {
        BranchReportResponse response = new BranchReportResponse();
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new /* Unavailable Anonymous Inner Class!! */, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected abstract void doBranchReport(BranchReportRequest var1, BranchReportResponse var2, RpcContext var3) throws TransactionException;

    public GlobalLockQueryResponse handle(GlobalLockQueryRequest request, RpcContext rpcContext) {
        GlobalLockQueryResponse response = new GlobalLockQueryResponse();
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new /* Unavailable Anonymous Inner Class!! */, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected abstract void doLockCheck(GlobalLockQueryRequest var1, GlobalLockQueryResponse var2, RpcContext var3) throws TransactionException;

    public GlobalStatusResponse handle(GlobalStatusRequest request, RpcContext rpcContext) {
        GlobalStatusResponse response = new GlobalStatusResponse();
        response.setGlobalStatus(GlobalStatus.UnKnown);
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new /* Unavailable Anonymous Inner Class!! */, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected abstract void doGlobalStatus(GlobalStatusRequest var1, GlobalStatusResponse var2, RpcContext var3) throws TransactionException;

    public GlobalReportResponse handle(GlobalReportRequest request, RpcContext rpcContext) {
        GlobalReportResponse response = new GlobalReportResponse();
        response.setGlobalStatus(request.getGlobalStatus());
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new /* Unavailable Anonymous Inner Class!! */, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected abstract void doGlobalReport(GlobalReportRequest var1, GlobalReportResponse var2, RpcContext var3) throws TransactionException;

    private void checkTransactionStatus(AbstractGlobalEndRequest request, AbstractGlobalEndResponse response) {
        try {
            GlobalSession globalSession = SessionHolder.findGlobalSession((String)request.getXid(), (boolean)false);
            if (globalSession != null) {
                response.setGlobalStatus(globalSession.getStatus());
            } else {
                response.setGlobalStatus(GlobalStatus.Finished);
            }
        }
        catch (Exception exx) {
            LOGGER.error("check transaction status error,{}]", (Object)exx.getMessage());
        }
    }

    static /* synthetic */ void access$000(AbstractTCInboundHandler x0, AbstractGlobalEndRequest x1, AbstractGlobalEndResponse x2) {
        x0.checkTransactionStatus(x1, x2);
    }
}

