/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.resolver;

import java.util.Arrays;
import org.apache.fury.annotation.Internal;
import org.apache.fury.meta.MetaString;
import org.apache.fury.meta.MetaStringDecoder;
import org.apache.fury.util.MurmurHash3;

@Internal
final class MetaStringBytes {
    static final short DEFAULT_DYNAMIC_WRITE_STRING_ID = -1;
    private static final int HEADER_MASK = 255;
    final byte[] bytes;
    final long hashCode;
    short dynamicWriteStringId = (short)-1;

    public MetaStringBytes(byte[] bytes, long hashCode) {
        assert (hashCode != 0L);
        this.bytes = bytes;
        this.hashCode = hashCode;
    }

    public MetaStringBytes(MetaString metaString) {
        this.bytes = metaString.getBytes();
        long hashCode = MurmurHash3.murmurhash3_x64_128(this.bytes, 0, this.bytes.length, 47)[0];
        if (hashCode == 0L) {
            hashCode += 256L;
        }
        int header = metaString.getEncoding().getValue() & 0xFF;
        this.hashCode = (hashCode &= 0xFFFFFFFFFFFFFF00L) | (long)header;
    }

    public String decode(char specialChar1, char specialChar2) {
        return this.decode(new MetaStringDecoder(specialChar1, specialChar2));
    }

    public String decode(MetaStringDecoder decoder) {
        int header = (int)(this.hashCode & 0xFFL);
        MetaString.Encoding encoding = MetaString.Encoding.values()[header];
        return decoder.decode(this.bytes, encoding);
    }

    public boolean equals(Object o) {
        MetaStringBytes that = (MetaStringBytes)o;
        return this.hashCode == that.hashCode;
    }

    public int hashCode() {
        return (int)(this.hashCode >> 1);
    }

    public String toString() {
        return "MetaStringBytes{hashCode=" + this.hashCode + ", size=" + this.bytes.length + ", bytes=" + Arrays.toString(this.bytes) + '}';
    }
}

