/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowConfigNodesResp;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.BytesUtils;

public class ShowConfigNodesTask
implements IConfigTask {
    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showConfigNodes();
    }

    public static void buildTSBlock(TShowConfigNodesResp showConfigNodesResp, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showConfigNodesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        if (showConfigNodesResp.getConfigNodesInfoList() != null) {
            for (TConfigNodeInfo configNodeInfo : showConfigNodesResp.getConfigNodesInfoList()) {
                builder.getTimeColumnBuilder().writeLong(0L);
                builder.getColumnBuilder(0).writeInt(configNodeInfo.getConfigNodeId());
                builder.getColumnBuilder(1).writeBinary(BytesUtils.valueOf((String)configNodeInfo.getStatus()));
                builder.getColumnBuilder(2).writeBinary(BytesUtils.valueOf((String)configNodeInfo.getInternalAddress()));
                builder.getColumnBuilder(3).writeInt(configNodeInfo.getInternalPort());
                builder.getColumnBuilder(4).writeBinary(BytesUtils.valueOf((String)configNodeInfo.getRoleType()));
                builder.declarePosition();
            }
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowConfigNodesHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

