/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.aggregation.TreeAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;

public abstract class SingleInputAggregationOperator
implements ProcessOperator {
    protected final OperatorContext operatorContext;
    protected final boolean ascending;
    protected final Operator child;
    protected TsBlock inputTsBlock;
    protected boolean canCallNext;
    protected final List<TreeAggregator> aggregators;
    protected TsBlockBuilder resultTsBlockBuilder;
    protected final long maxRetainedSize;
    protected final long maxReturnSize;

    protected SingleInputAggregationOperator(OperatorContext operatorContext, List<TreeAggregator> aggregators, Operator child, boolean ascending, long maxReturnSize) {
        this.operatorContext = operatorContext;
        this.ascending = ascending;
        this.child = child;
        this.aggregators = aggregators;
        this.maxRetainedSize = child.calculateMaxReturnSize();
        this.maxReturnSize = maxReturnSize;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() throws Exception {
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        this.canCallNext = true;
        while (System.nanoTime() - start < maxRuntime && this.hasNext() && !this.resultTsBlockBuilder.isFull() && this.calculateNextAggregationResult()) {
        }
        if (this.resultTsBlockBuilder.getPositionCount() > 0) {
            TsBlock resultTsBlock = this.resultTsBlockBuilder.build();
            this.resultTsBlockBuilder.reset();
            return resultTsBlock;
        }
        return null;
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    protected abstract boolean calculateNextAggregationResult() throws Exception;

    protected abstract void updateResultTsBlock();

    @Override
    public long calculateMaxPeekMemory() {
        return this.maxReturnSize + this.maxRetainedSize + this.child.calculateRetainedSizeAfterCallingNext();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.maxRetainedSize + this.child.calculateRetainedSizeAfterCallingNext();
    }
}

