/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.JiraConfiguration;
import java.util.List;

@SdkInternalApi
public class JiraConfigurationMarshaller {
    private static final MarshallingInfo<String> JIRAACCOUNTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JiraAccountUrl").build();
    private static final MarshallingInfo<String> SECRETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretArn").build();
    private static final MarshallingInfo<Boolean> USECHANGELOG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UseChangeLog").build();
    private static final MarshallingInfo<List> PROJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Project").build();
    private static final MarshallingInfo<List> ISSUETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IssueType").build();
    private static final MarshallingInfo<List> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<List> ISSUESUBENTITYFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IssueSubEntityFilter").build();
    private static final MarshallingInfo<List> ATTACHMENTFIELDMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttachmentFieldMappings").build();
    private static final MarshallingInfo<List> COMMENTFIELDMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommentFieldMappings").build();
    private static final MarshallingInfo<List> ISSUEFIELDMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IssueFieldMappings").build();
    private static final MarshallingInfo<List> PROJECTFIELDMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProjectFieldMappings").build();
    private static final MarshallingInfo<List> WORKLOGFIELDMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkLogFieldMappings").build();
    private static final MarshallingInfo<List> INCLUSIONPATTERNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InclusionPatterns").build();
    private static final MarshallingInfo<List> EXCLUSIONPATTERNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExclusionPatterns").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfiguration").build();
    private static final JiraConfigurationMarshaller instance = new JiraConfigurationMarshaller();

    public static JiraConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(JiraConfiguration jiraConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (jiraConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jiraConfiguration.getJiraAccountUrl(), JIRAACCOUNTURL_BINDING);
            protocolMarshaller.marshall((Object)jiraConfiguration.getSecretArn(), SECRETARN_BINDING);
            protocolMarshaller.marshall((Object)jiraConfiguration.getUseChangeLog(), USECHANGELOG_BINDING);
            protocolMarshaller.marshall(jiraConfiguration.getProject(), PROJECT_BINDING);
            protocolMarshaller.marshall(jiraConfiguration.getIssueType(), ISSUETYPE_BINDING);
            protocolMarshaller.marshall(jiraConfiguration.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(jiraConfiguration.getIssueSubEntityFilter(), ISSUESUBENTITYFILTER_BINDING);
            protocolMarshaller.marshall(jiraConfiguration.getAttachmentFieldMappings(), ATTACHMENTFIELDMAPPINGS_BINDING);
            protocolMarshaller.marshall(jiraConfiguration.getCommentFieldMappings(), COMMENTFIELDMAPPINGS_BINDING);
            protocolMarshaller.marshall(jiraConfiguration.getIssueFieldMappings(), ISSUEFIELDMAPPINGS_BINDING);
            protocolMarshaller.marshall(jiraConfiguration.getProjectFieldMappings(), PROJECTFIELDMAPPINGS_BINDING);
            protocolMarshaller.marshall(jiraConfiguration.getWorkLogFieldMappings(), WORKLOGFIELDMAPPINGS_BINDING);
            protocolMarshaller.marshall(jiraConfiguration.getInclusionPatterns(), INCLUSIONPATTERNS_BINDING);
            protocolMarshaller.marshall(jiraConfiguration.getExclusionPatterns(), EXCLUSIONPATTERNS_BINDING);
            protocolMarshaller.marshall((Object)jiraConfiguration.getVpcConfiguration(), VPCCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

