/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.juneau.BasicAssertionError;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.AssertionPredicates;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.assertions.FluentAnyAssertion;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;

@FluentSetters(returns="FluentPrimitiveArrayAssertion<E,T,R>")
public class FluentPrimitiveArrayAssertion<E, T, R>
extends FluentObjectAssertion<T, R> {
    private static final Map<Class<?>, Function<Object, String>> STRINGIFIERS = new HashMap();
    private static final Messages MESSAGES;
    static final String MSG_objectWasNotAnArray;
    static final String MSG_arrayWasNotEmpty;
    static final String MSG_arrayWasEmpty;
    static final String MSG_arrayDidNotHaveExpectedSize;
    static final String MSG_arrayDidNotContainExpectedValue;
    static final String MSG_arrayDidNotContainExpectedValueAt;
    static final String MSG_arrayContainedUnexpectedValue;
    static final String MSG_arrayDidntContainAnyMatchingValue;
    static final String MSG_arrayContainedNonMatchingValueAt;

    public FluentPrimitiveArrayAssertion(T value, R returns) {
        this(null, value, returns);
    }

    public FluentPrimitiveArrayAssertion(Assertion creator, T value, R returns) {
        super(creator, value, returns);
        Class<?> c;
        if (!(value == null || (c = value.getClass()).isArray() && c.getComponentType().isPrimitive())) {
            throw new BasicAssertionError(MSG_objectWasNotAnArray, value.getClass());
        }
    }

    public FluentPrimitiveArrayAssertion<E, T, R> asTransformed(Function<T, T> function) {
        return new FluentPrimitiveArrayAssertion(this, function.apply(this.orElse(null)), this.returns());
    }

    @Override
    public FluentStringAssertion<R> asString() {
        return new FluentStringAssertion((Assertion)this, this.toString(), this.returns());
    }

    public FluentAnyAssertion<E, R> asItem(int index) {
        return new FluentAnyAssertion(this, this.at(index), this.returns());
    }

    public FluentIntegerAssertion<R> asLength() {
        return new FluentIntegerAssertion((Assertion)this, this.valueIsNull() ? null : Integer.valueOf(Array.getLength(this.value())), this.returns());
    }

    public R isHas(E ... entries) throws AssertionError {
        Assertions.assertArgNotNull("entries", entries);
        Predicate[] p = (Predicate[])Arrays.stream(entries).map(AssertionPredicates::eq).toArray(Predicate[]::new);
        return this.is(p);
    }

    @Override
    @SafeVarargs
    public final R is(Predicate<E> ... tests) throws AssertionError {
        this.isSize(tests.length);
        int j = this.length2();
        for (int i = 0; i < j; ++i) {
            Predicate<E> t = tests[i];
            if (t == null || t.test(this.at(i))) continue;
            throw this.error(MSG_arrayDidNotContainExpectedValueAt, i, this.getFailureMessage(t, this.at(i)));
        }
        return this.returns();
    }

    public R isAny(Predicate<E> test) throws AssertionError {
        Assertions.assertArgNotNull("test", test);
        int j = this.length2();
        for (int i = 0; i < j; ++i) {
            if (!test.test(this.at(i))) continue;
            return this.returns();
        }
        throw this.error(MSG_arrayDidntContainAnyMatchingValue, this.value());
    }

    public R isAll(Predicate<E> test) throws AssertionError {
        Assertions.assertArgNotNull("test", test);
        int j = this.length2();
        for (int i = 0; i < j; ++i) {
            if (test.test(this.at(i))) continue;
            throw this.error(MSG_arrayContainedNonMatchingValueAt, i, this.getFailureMessage(test, this.at(i)));
        }
        return this.returns();
    }

    public R isEmpty() throws AssertionError {
        if (this.length2() != 0) {
            throw this.error(MSG_arrayWasNotEmpty, new Object[0]);
        }
        return this.returns();
    }

    public R isNotEmpty() throws AssertionError {
        if (this.length2() == 0) {
            throw this.error(MSG_arrayWasEmpty, new Object[0]);
        }
        return this.returns();
    }

    public R isSize(int size) throws AssertionError {
        if (this.length2() != size) {
            throw this.error(MSG_arrayDidNotHaveExpectedSize, size, this.asLength());
        }
        return this.returns();
    }

    public R isContains(E entry) throws AssertionError {
        int j = this.length2();
        for (int i = 0; i < j; ++i) {
            if (!ObjectUtils.eq(this.at(i), entry)) continue;
            return this.returns();
        }
        throw this.error(MSG_arrayDidNotContainExpectedValue, entry, this.value());
    }

    public R isNotContains(E entry) throws AssertionError {
        for (int i = 0; i < this.length2(); ++i) {
            if (!ObjectUtils.eq(this.at(i), entry)) continue;
            throw this.error(MSG_arrayContainedUnexpectedValue, entry, this.value());
        }
        return this.returns();
    }

    @Override
    public FluentPrimitiveArrayAssertion<E, T, R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentPrimitiveArrayAssertion<E, T, R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentPrimitiveArrayAssertion<E, T, R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentPrimitiveArrayAssertion<E, T, R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentPrimitiveArrayAssertion<E, T, R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }

    private E at(int index) {
        return (E)(this.valueIsNull() || index < 0 || index >= this.length2() ? null : Array.get(this.value(), index));
    }

    private int length2() {
        return Array.getLength(this.value());
    }

    @Override
    public String toString() {
        if (this.valueIsNull()) {
            return null;
        }
        return STRINGIFIERS.get(this.value().getClass().getComponentType()).apply(this.value());
    }

    static {
        STRINGIFIERS.put(Boolean.TYPE, x -> Arrays.toString((boolean[])x));
        STRINGIFIERS.put(Byte.TYPE, x -> Arrays.toString((byte[])x));
        STRINGIFIERS.put(Character.TYPE, x -> Arrays.toString((char[])x));
        STRINGIFIERS.put(Double.TYPE, x -> Arrays.toString((double[])x));
        STRINGIFIERS.put(Float.TYPE, x -> Arrays.toString((float[])x));
        STRINGIFIERS.put(Integer.TYPE, x -> Arrays.toString((int[])x));
        STRINGIFIERS.put(Long.TYPE, x -> Arrays.toString((long[])x));
        STRINGIFIERS.put(Short.TYPE, x -> Arrays.toString((short[])x));
        MESSAGES = Messages.of(FluentPrimitiveArrayAssertion.class, "Messages");
        MSG_objectWasNotAnArray = MESSAGES.getString("objectWasNotAnArray");
        MSG_arrayWasNotEmpty = MESSAGES.getString("arrayWasNotEmpty");
        MSG_arrayWasEmpty = MESSAGES.getString("arrayWasEmpty");
        MSG_arrayDidNotHaveExpectedSize = MESSAGES.getString("arrayDidNotHaveExpectedSize");
        MSG_arrayDidNotContainExpectedValue = MESSAGES.getString("arrayDidNotContainExpectedValue");
        MSG_arrayDidNotContainExpectedValueAt = MESSAGES.getString("arrayDidNotContainExpectedValueAt");
        MSG_arrayContainedUnexpectedValue = MESSAGES.getString("arrayContainedUnexpectedValue");
        MSG_arrayDidntContainAnyMatchingValue = MESSAGES.getString("arrayDidntContainAnyMatchingValue");
        MSG_arrayContainedNonMatchingValueAt = MESSAGES.getString("arrayContainedNonMatchingValueAt");
    }
}

