/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.entity.HttpEntityBuilder;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.ReaderInputStream;

public class StringEntity
extends BasicHttpEntity {
    private static final String EMPTY = "";
    private final byte[] cache;
    private final Charset charset;

    public static HttpEntityBuilder<StringEntity> create() {
        return new HttpEntityBuilder<Class<StringEntity>>(StringEntity.class);
    }

    public StringEntity(HttpEntityBuilder<?> builder) {
        super(builder);
        this.charset = ObjectUtils.firstNonNull(builder.charset, IOUtils.UTF8);
        this.cache = builder.cached ? this.string().getBytes(this.charset) : null;
    }

    public HttpEntityBuilder<StringEntity> copy() {
        return new HttpEntityBuilder<StringEntity>(this);
    }

    private String string() {
        return this.contentOrElse(EMPTY);
    }

    @Override
    public byte[] asBytes() throws IOException {
        return this.cache == null ? this.string().getBytes() : this.cache;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        if (this.cache != null) {
            return this.cache.length;
        }
        long l = super.getContentLength();
        if (l != -1L || this.isSupplied()) {
            return l;
        }
        String s = this.string();
        if (this.charset == IOUtils.UTF8) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) <= '\u007f') continue;
                return -1L;
            }
        }
        return s.length();
    }

    @Override
    public InputStream getContent() throws IOException {
        if (this.cache != null) {
            return new ByteArrayInputStream(this.cache);
        }
        String s = this.string();
        if (s == null) {
            return IOUtils.EMPTY_INPUT_STREAM;
        }
        return new ReaderInputStream((Reader)new StringReader(s), this.charset);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        Assertions.assertArgNotNull("out", out);
        if (this.cache != null) {
            out.write(this.cache);
        } else {
            OutputStreamWriter osw = new OutputStreamWriter(out, this.charset);
            osw.write(this.string());
            osw.flush();
        }
    }

    @Override
    public boolean isStreaming() {
        return false;
    }
}

