/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.DetailLevel;
import org.apache.juneau.PropertyNamerDUCS;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.html.HtmlDocSerializer;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.HtmlStrippedDocSerializer;
import org.apache.juneau.http.HttpEntities;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.http.entity.SerializedEntity;
import org.apache.juneau.http.header.Accept;
import org.apache.juneau.http.header.AcceptCharset;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.header.MediaType;
import org.apache.juneau.http.header.NoTrace;
import org.apache.juneau.http.header.SerializedHeader;
import org.apache.juneau.http.header.Thrown;
import org.apache.juneau.http.part.PartList;
import org.apache.juneau.http.part.SerializedPart;
import org.apache.juneau.http.resource.HttpResource;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonParser;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.msgpack.MsgPackSerializer;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.plaintext.PlainTextParser;
import org.apache.juneau.plaintext.PlainTextSerializer;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.rest.client.BasicHttpEntityRequestBase;
import org.apache.juneau.rest.client.BasicHttpRequestBase;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.rest.client.RestCallInterceptor;
import org.apache.juneau.rest.client.RestClient;
import org.apache.juneau.rest.client.RestOperation;
import org.apache.juneau.rest.client.RestRequestCreated;
import org.apache.juneau.rest.client.RestResponse;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;

public class RestRequest
extends BeanSession
implements HttpUriRequest,
Configurable {
    private static final ContentType TEXT_PLAIN = ContentType.TEXT_PLAIN;
    final RestClient client;
    private final HttpRequestBase request;
    private RestResponse response;
    List<RestCallInterceptor> interceptors = CollectionUtils.list((Object[])new RestCallInterceptor[0]);
    private final HeaderList.Builder headerDataBuilder;
    private final PartList.Builder queryDataBuilder;
    private final PartList.Builder formDataBuilder;
    private final PartList.Builder pathDataBuilder;
    private HeaderList headerData;
    private PartList queryData;
    private PartList formData;
    private PartList pathData;
    private boolean ignoreErrors;
    private boolean suppressLogging;
    private Object content;
    private Serializer serializer;
    private Parser parser;
    private HttpPartSchema contentSchema;
    private URIBuilder uriBuilder;
    private Predicate<Integer> errorCodes;
    private HttpHost target;
    private HttpContext context;
    private List<Class<? extends Throwable>> rethrow;
    private HttpPartSerializerSession partSerializerSession;
    private final Map<HttpPartSerializer, HttpPartSerializerSession> partSerializerSessions = new IdentityHashMap<HttpPartSerializer, HttpPartSerializerSession>();

    protected RestRequest(RestClient client, URI uri, String method, boolean hasBody) throws RestCallException {
        super(client.getBeanContext().createSession());
        this.client = client;
        this.request = this.createInnerRequest(method, uri, hasBody);
        this.errorCodes = client.errorCodes;
        this.uriBuilder = new URIBuilder(this.request.getURI());
        this.ignoreErrors = client.ignoreErrors;
        this.headerDataBuilder = client.createHeaderDataBuilder();
        this.queryDataBuilder = client.createQueryDataBuilder();
        this.formDataBuilder = client.createFormDataBuilder();
        this.pathDataBuilder = client.createPathDataBuilder();
    }

    protected HttpRequestBase createInnerRequest(String method, URI uri, boolean hasBody) {
        RestRequestCreated req = hasBody ? new BasicHttpEntityRequestBase(this, method) : new BasicHttpRequestBase(this, method);
        req.setURI(uri);
        return req;
    }

    public RestRequest json() {
        return this.serializer(JsonSerializer.class).parser(JsonParser.class);
    }

    public RestRequest simpleJson() {
        return this.serializer(SimpleJsonSerializer.class).parser(SimpleJsonParser.class);
    }

    public RestRequest xml() {
        return this.serializer(XmlSerializer.class).parser(XmlParser.class);
    }

    public RestRequest html() {
        return this.serializer(HtmlSerializer.class).parser(HtmlParser.class);
    }

    public RestRequest htmlDoc() {
        return this.serializer(HtmlDocSerializer.class).parser(HtmlParser.class);
    }

    public RestRequest htmlStrippedDoc() {
        return this.serializer(HtmlStrippedDocSerializer.class).parser(HtmlParser.class);
    }

    public RestRequest plainText() {
        return this.serializer(PlainTextSerializer.class).parser(PlainTextParser.class);
    }

    public RestRequest msgPack() {
        return this.serializer(MsgPackSerializer.class).parser(MsgPackParser.class);
    }

    public RestRequest uon() {
        return this.serializer(UonSerializer.class).parser(UonParser.class);
    }

    public RestRequest urlEnc() {
        return this.serializer(UrlEncodingSerializer.class).parser(UrlEncodingParser.class);
    }

    public RestRequest openApi() {
        return this.serializer(OpenApiSerializer.class).parser(OpenApiParser.class);
    }

    public RestRequest serializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public RestRequest serializer(Class<? extends Serializer> serializer) {
        this.serializer = this.client.getInstance(serializer);
        return this;
    }

    public RestRequest parser(Parser parser) {
        this.parser = parser;
        return this;
    }

    public RestRequest parser(Class<? extends Parser> parser) {
        this.parser = this.client.getInstance(parser);
        return this;
    }

    public RestRequest errorCodes(Predicate<Integer> value) {
        this.errorCodes = value;
        return this;
    }

    public RestRequest interceptors(RestCallInterceptor ... interceptors) throws RestCallException {
        try {
            for (RestCallInterceptor i : interceptors) {
                this.interceptors.add(i);
                i.onInit(this);
            }
        }
        catch (RuntimeException | RestCallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestCallException(null, e, "Interceptor threw an exception on init.", new Object[0]);
        }
        return this;
    }

    public RestRequest ignoreErrors() {
        this.ignoreErrors = true;
        return this;
    }

    public RestRequest rethrow(Class<?> ... values) {
        if (this.rethrow == null) {
            this.rethrow = CollectionUtils.list((Object[])new Class[0]);
        }
        for (Class<?> v : values) {
            if (v == null || !Throwable.class.isAssignableFrom(v)) continue;
            this.rethrow.add(v);
        }
        return this;
    }

    public RestRequest debug() throws RestCallException {
        this.header("Debug", true);
        return this;
    }

    public boolean isDebug() {
        return this.getHeaderList().get("Debug", Boolean.class).orElse(false);
    }

    public RestRequest suppressLogging() {
        this.suppressLogging = true;
        return this;
    }

    boolean isLoggingSuppressed() {
        return this.suppressLogging;
    }

    public RestRequest target(HttpHost target) {
        this.target = target;
        return this;
    }

    public RestRequest context(HttpContext context) {
        this.context = context;
        return this;
    }

    public HeaderList.Builder headers() {
        this.headerData = null;
        return this.headerDataBuilder;
    }

    public HeaderList getHeaderList() {
        if (this.headerData == null) {
            this.headerData = (HeaderList)this.headerDataBuilder.build();
        }
        return this.headerData;
    }

    public PartList.Builder queryData() {
        this.queryData = null;
        return this.queryDataBuilder;
    }

    public PartList getQueryDataList() {
        if (this.queryData == null) {
            this.queryData = (PartList)this.queryDataBuilder.build();
        }
        return this.queryData;
    }

    public PartList.Builder formData() {
        this.formData = null;
        return this.formDataBuilder;
    }

    public PartList getFormDataList() {
        if (this.formData == null) {
            this.formData = (PartList)this.formDataBuilder.build();
        }
        return this.formData;
    }

    public PartList.Builder pathData() {
        this.pathData = null;
        return this.pathDataBuilder;
    }

    public PartList getPathDataList() {
        if (this.pathData == null) {
            this.pathData = (PartList)this.pathDataBuilder.build();
        }
        return this.pathData;
    }

    public RestRequest header(Header part) {
        return this.headers(part);
    }

    public RestRequest headers(Header ... parts) {
        this.headers().append(parts);
        return this;
    }

    public RestRequest queryData(NameValuePair ... parts) {
        this.queryData().append(parts);
        return this;
    }

    public RestRequest formData(NameValuePair ... parts) {
        this.formData().append(parts);
        return this;
    }

    public RestRequest pathData(NameValuePair ... parts) {
        this.pathData().set(parts);
        return this;
    }

    public RestRequest header(String name, Object value) {
        this.headers().append(this.createHeader(name, value));
        return this;
    }

    public RestRequest queryData(String name, Object value) {
        this.queryData().append(this.createPart(HttpPartType.QUERY, name, value));
        return this;
    }

    public RestRequest formData(String name, Object value) {
        this.formData().append(this.createPart(HttpPartType.FORMDATA, name, value));
        return this;
    }

    public RestRequest pathData(String name, Object value) {
        this.pathData().set(this.createPart(HttpPartType.PATH, name, value));
        return this;
    }

    public RestRequest headerPairs(String ... pairs) {
        if (pairs.length % 2 != 0) {
            throw ThrowableUtils.runtimeException((String)"Odd number of parameters passed into headerPairs(String...)", (Object[])new Object[0]);
        }
        HeaderList.Builder b = this.headers();
        for (int i = 0; i < pairs.length; i += 2) {
            b.append(pairs[i], (Object)pairs[i + 1]);
        }
        return this;
    }

    public RestRequest queryDataPairs(String ... pairs) throws RestCallException {
        if (pairs.length % 2 != 0) {
            throw ThrowableUtils.runtimeException((String)"Odd number of parameters passed into queryDataPairs(String...)", (Object[])new Object[0]);
        }
        PartList.Builder b = this.queryData();
        for (int i = 0; i < pairs.length; i += 2) {
            b.append(pairs[i], (Object)pairs[i + 1]);
        }
        return this;
    }

    public RestRequest formDataPairs(String ... pairs) throws RestCallException {
        if (pairs.length % 2 != 0) {
            throw ThrowableUtils.runtimeException((String)"Odd number of parameters passed into formDataPairs(String...)", (Object[])new Object[0]);
        }
        PartList.Builder b = this.formData();
        for (int i = 0; i < pairs.length; i += 2) {
            b.append(pairs[i], (Object)pairs[i + 1]);
        }
        return this;
    }

    public RestRequest pathDataPairs(String ... pairs) {
        if (pairs.length % 2 != 0) {
            throw ThrowableUtils.runtimeException((String)"Odd number of parameters passed into pathDataPairs(String...)", (Object[])new Object[0]);
        }
        PartList.Builder b = this.pathData();
        for (int i = 0; i < pairs.length; i += 2) {
            b.set(pairs[i], (Object)pairs[i + 1]);
        }
        return this;
    }

    public RestRequest headersBean(Object value) {
        if (!this.isBean(value)) {
            throw ThrowableUtils.runtimeException((String)"Object passed into headersBean(Object) is not a bean.", (Object[])new Object[0]);
        }
        HeaderList.Builder b = this.headers();
        this.toBeanMap(value, PropertyNamerDUCS.INSTANCE).forEach((k, v) -> b.append(this.createHeader((String)k, v)));
        return this;
    }

    public RestRequest queryDataBean(Object value) {
        if (!this.isBean(value)) {
            throw ThrowableUtils.runtimeException((String)"Object passed into queryDataBean(Object) is not a bean.", (Object[])new Object[0]);
        }
        PartList.Builder b = this.queryData();
        this.toBeanMap(value).forEach((k, v) -> b.append(this.createPart(HttpPartType.QUERY, (String)k, v)));
        return this;
    }

    public RestRequest formDataBean(Object value) {
        if (!this.isBean(value)) {
            throw ThrowableUtils.runtimeException((String)"Object passed into formDataBean(Object) is not a bean.", (Object[])new Object[0]);
        }
        PartList.Builder b = this.formData();
        this.toBeanMap(value).forEach((k, v) -> b.append(this.createPart(HttpPartType.FORMDATA, (String)k, v)));
        return this;
    }

    public RestRequest pathDataBean(Object value) {
        if (!this.isBean(value)) {
            throw ThrowableUtils.runtimeException((String)"Object passed into pathDataBean(Object) is not a bean.", (Object[])new Object[0]);
        }
        PartList.Builder b = this.pathData();
        this.toBeanMap(value).forEach((k, v) -> b.set(this.createPart(HttpPartType.PATH, (String)k, v)));
        return this;
    }

    public RestRequest uri(Object uri) throws RestCallException {
        URI x = this.client.toURI(uri, null);
        if (x.getScheme() != null) {
            this.uriBuilder.setScheme(x.getScheme());
        }
        if (x.getHost() != null) {
            this.uriBuilder.setHost(x.getHost());
        }
        if (x.getPort() != -1) {
            this.uriBuilder.setPort(x.getPort());
        }
        if (x.getUserInfo() != null) {
            this.uriBuilder.setUserInfo(x.getUserInfo());
        }
        if (x.getFragment() != null) {
            this.uriBuilder.setFragment(x.getFragment());
        }
        if (x.getQuery() != null) {
            this.uriBuilder.setCustomQuery(x.getQuery());
        }
        this.uriBuilder.setPath(x.getPath());
        return this;
    }

    public RestRequest uriScheme(String scheme) {
        this.uriBuilder.setScheme(scheme);
        return this;
    }

    public RestRequest uriHost(String host) {
        this.uriBuilder.setHost(host);
        return this;
    }

    public RestRequest uriPort(int port) {
        this.uriBuilder.setPort(port);
        return this;
    }

    public RestRequest uriUserInfo(String userInfo) {
        this.uriBuilder.setUserInfo(userInfo);
        return this;
    }

    public RestRequest uriUserInfo(String username, String password) {
        this.uriBuilder.setUserInfo(username, password);
        return this;
    }

    public RestRequest uriFragment(String fragment) {
        this.uriBuilder.setFragment(fragment);
        return this;
    }

    public RestRequest queryCustom(Object value) {
        try {
            String q = null;
            q = value instanceof Reader ? IOUtils.read((Reader)((Reader)value)) : (value instanceof InputStream ? IOUtils.read((InputStream)((InputStream)value)) : StringUtils.stringify((Object)value));
            this.uriBuilder.setCustomQuery(q);
        }
        catch (IOException e) {
            throw ThrowableUtils.runtimeException((Throwable)e, (String)"Could not read custom query.", (Object[])new Object[0]);
        }
        return this;
    }

    public RestRequest formDataCustom(Object value) {
        this.header((Header)ContentType.APPLICATION_FORM_URLENCODED);
        this.content(value instanceof CharSequence ? new StringReader(value.toString()) : value);
        return this;
    }

    RestRequest headerArg(String name, Object value, HttpPartSchema schema, HttpPartSerializer serializer, boolean skipIfEmpty) {
        boolean isMulti;
        boolean bl = isMulti = StringUtils.isEmpty((String)name) || "*".equals(name) || value instanceof HeaderList || RestRequest.isHeaderArray(value);
        if (!isMulti) {
            if (!skipIfEmpty || !StringUtils.isEmpty((String)StringUtils.stringify((Object)value))) {
                return this.header(this.createHeader(name, value, serializer, schema, skipIfEmpty));
            }
            return this;
        }
        ArrayList l = CollectionUtils.list((Object[])new Header[0]);
        if (HttpHeaders.canCast((Object)value)) {
            l.add(HttpHeaders.cast((Object)value));
        } else if (value instanceof HeaderList) {
            ((HeaderList)value).forEach(x -> l.add(x));
        } else if (value instanceof Collection) {
            ((Collection)value).forEach(x -> l.add(HttpHeaders.cast((Object)x)));
        } else if (value != null && value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                l.add(HttpHeaders.cast((Object)Array.get(value, i)));
            }
        } else if (value instanceof Map) {
            RestRequest.toMap(value).forEach((k, v) -> l.add(this.createHeader(StringUtils.stringify((Object)k), v, serializer, schema, skipIfEmpty)));
        } else if (this.isBean(value)) {
            this.toBeanMap(value).forEach((k, v) -> l.add(this.createHeader((String)k, v, serializer, schema, skipIfEmpty)));
        } else if (value != null) {
            throw ThrowableUtils.runtimeException((String)"Invalid value type for header arg ''{0}'': {1}", (Object[])new Object[]{name, ClassUtils.className((Object)value)});
        }
        if (skipIfEmpty) {
            l.removeIf(x -> StringUtils.isEmpty((String)x.getValue()));
        }
        this.headers().append((List)l);
        return this;
    }

    RestRequest queryArg(String name, Object value, HttpPartSchema schema, HttpPartSerializer serializer, boolean skipIfEmpty) {
        boolean isMulti;
        boolean bl = isMulti = StringUtils.isEmpty((String)name) || "*".equals(name) || value instanceof PartList || RestRequest.isNameValuePairArray(value);
        if (!isMulti) {
            if (!skipIfEmpty || !StringUtils.isEmpty((String)StringUtils.stringify((Object)value))) {
                return this.queryData(this.createPart(name, value, HttpPartType.QUERY, serializer, schema, skipIfEmpty));
            }
            return this;
        }
        ArrayList l = CollectionUtils.list((Object[])new NameValuePair[0]);
        if (HttpParts.canCast((Object)value)) {
            l.add(HttpParts.cast((Object)value));
        } else if (value instanceof PartList) {
            ((PartList)value).forEach(x -> l.add(x));
        } else if (value instanceof Collection) {
            ((Collection)value).forEach(x -> l.add(HttpParts.cast((Object)x)));
        } else if (value != null && value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                l.add(HttpParts.cast((Object)Array.get(value, i)));
            }
        } else if (value instanceof Map) {
            RestRequest.toMap(value).forEach((k, v) -> l.add(this.createPart(StringUtils.stringify((Object)k), v, HttpPartType.QUERY, serializer, schema, skipIfEmpty)));
        } else if (this.isBean(value)) {
            this.toBeanMap(value).forEach((k, v) -> l.add(this.createPart((String)k, v, HttpPartType.QUERY, serializer, schema, skipIfEmpty)));
        } else if (value != null) {
            this.queryCustom(value);
            return this;
        }
        if (skipIfEmpty) {
            l.removeIf(x -> StringUtils.isEmpty((String)x.getValue()));
        }
        this.queryData().append((List)l);
        return this;
    }

    RestRequest formDataArg(String name, Object value, HttpPartSchema schema, HttpPartSerializer serializer, boolean skipIfEmpty) {
        boolean isMulti;
        boolean bl = isMulti = StringUtils.isEmpty((String)name) || "*".equals(name) || value instanceof PartList || RestRequest.isNameValuePairArray(value);
        if (!isMulti) {
            if (!skipIfEmpty || !StringUtils.isEmpty((String)StringUtils.stringify((Object)value))) {
                return this.formData(this.createPart(name, value, HttpPartType.FORMDATA, serializer, schema, skipIfEmpty));
            }
            return this;
        }
        ArrayList l = CollectionUtils.list((Object[])new NameValuePair[0]);
        if (HttpParts.canCast((Object)value)) {
            l.add(HttpParts.cast((Object)value));
        } else if (value instanceof PartList) {
            ((PartList)value).forEach(x -> l.add(x));
        } else if (value instanceof Collection) {
            ((Collection)value).forEach(x -> l.add(HttpParts.cast((Object)x)));
        } else if (value != null && value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                l.add(HttpParts.cast((Object)Array.get(value, i)));
            }
        } else if (value instanceof Map) {
            RestRequest.toMap(value).forEach((k, v) -> l.add(this.createPart(StringUtils.stringify((Object)k), v, HttpPartType.FORMDATA, serializer, schema, skipIfEmpty)));
        } else if (this.isBean(value)) {
            this.toBeanMap(value).forEach((k, v) -> l.add(this.createPart((String)k, v, HttpPartType.FORMDATA, serializer, schema, skipIfEmpty)));
        } else if (value != null) {
            this.formDataCustom(value);
            return this;
        }
        if (skipIfEmpty) {
            l.removeIf(x -> StringUtils.isEmpty((String)x.getValue()));
        }
        this.formData().append((List)l);
        return this;
    }

    RestRequest pathArg(String name, Object value, HttpPartSchema schema, HttpPartSerializer serializer) {
        boolean isMulti;
        boolean bl = isMulti = StringUtils.isEmpty((String)name) || "*".equals(name) || value instanceof PartList || RestRequest.isNameValuePairArray(value);
        if (!isMulti) {
            return this.pathData(this.createPart(name, value, HttpPartType.PATH, serializer, schema, false));
        }
        ArrayList l = CollectionUtils.list((Object[])new NameValuePair[0]);
        if (HttpParts.canCast((Object)value)) {
            l.add(HttpParts.cast((Object)value));
        } else if (value instanceof PartList) {
            ((PartList)value).forEach(x -> l.add(x));
        } else if (value instanceof Collection) {
            ((Collection)value).forEach(x -> l.add(HttpParts.cast((Object)x)));
        } else if (value != null && value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                l.add(HttpParts.cast((Object)Array.get(value, i)));
            }
        } else if (value instanceof Map) {
            RestRequest.toMap(value).forEach((k, v) -> l.add(this.createPart(StringUtils.stringify((Object)k), v, HttpPartType.PATH, serializer, schema, false)));
        } else if (this.isBean(value)) {
            this.toBeanMap(value).forEach((k, v) -> l.add(this.createPart((String)k, v, HttpPartType.PATH, serializer, schema, false)));
        } else if (value != null) {
            throw ThrowableUtils.runtimeException((String)"Invalid value type for path arg ''{0}'': {1}", (Object[])new Object[]{name, ClassUtils.className((Object)value)});
        }
        this.pathData().append((List)l);
        return this;
    }

    public RestRequest content(Object value) {
        this.content = value;
        return this;
    }

    public RestRequest contentString(Object input) throws RestCallException {
        return this.content(input == null ? null : new StringReader(StringUtils.stringify((Object)input)));
    }

    public RestRequest content(Object input, HttpPartSchema schema) {
        this.content = input;
        this.contentSchema = schema;
        return this;
    }

    public RestRequest accept(String value) throws RestCallException {
        return this.header((Header)Accept.of((String)value));
    }

    public RestRequest acceptCharset(String value) throws RestCallException {
        return this.header((Header)AcceptCharset.of((String)value));
    }

    public RestRequest contentType(String value) throws RestCallException {
        return this.header((Header)ContentType.of((String)value));
    }

    public RestRequest mediaType(String value) throws RestCallException {
        return this.header((Header)Accept.of((String)value)).header((Header)ContentType.of((String)value));
    }

    public RestRequest noTrace() throws RestCallException {
        return this.header((Header)NoTrace.TRUE);
    }

    public RestResponse run() throws RestCallException {
        if (this.response != null) {
            throw new RestCallException(this.response, null, "run() already called.", new Object[0]);
        }
        try {
            this.getQueryDataList().stream().map(x$0 -> new SimpleQuery((NameValuePair)x$0)).filter(SimplePart::isValid).forEach(x -> this.uriBuilder.addParameter(x.name, x.value));
            this.getPathDataList().stream().map(x$0 -> new SimplePath((NameValuePair)x$0)).forEach(x -> {
                String path = this.uriBuilder.getPath();
                String name = x.name;
                String value = x.value;
                String var = "{" + name + "}";
                if (path.indexOf(var) == -1 && !name.equals("/*")) {
                    throw ThrowableUtils.runtimeException((String)("Path variable {" + name + "} was not found in path."), (Object[])new Object[0]);
                }
                path = name.equals("/*") ? path.replaceAll("\\/\\*$", "/" + value) : path.replace(var, String.valueOf(value));
                this.uriBuilder.setPath(path);
            });
            HttpEntityEnclosingRequestBase request2 = this.request instanceof HttpEntityEnclosingRequestBase ? (HttpEntityEnclosingRequestBase)this.request : null;
            this.request.setURI(this.uriBuilder.build());
            HeaderList.Builder hl = this.headers();
            Optional h = hl.getLast("Content-Type");
            String contentType = h.isPresent() ? ((Header)h.get()).getValue() : null;
            Serializer serializer = this.serializer;
            if (serializer == null) {
                serializer = this.client.getMatchingSerializer(contentType);
            }
            if (contentType == null && serializer != null) {
                contentType = serializer.getPrimaryMediaType().toString();
            }
            String accept = (h = hl.getLast("Accept")).isPresent() ? ((Header)h.get()).getValue() : null;
            Parser parser = this.parser;
            if (parser == null) {
                parser = this.client.getMatchingParser(accept);
            }
            if (accept == null && parser != null) {
                hl.set((Header)Accept.of((MediaType)parser.getPrimaryMediaType()));
            }
            this.getHeaderList().stream().map(x$0 -> new SimpleHeader((NameValuePair)x$0)).filter(SimplePart::isValid).forEach(x -> this.request.addHeader((Header)x));
            if (request2 == null && this.content != RestOperation.NO_BODY) {
                throw new RestCallException(null, null, "Method does not support content entity.  Method={0}, URI={1}", this.getMethod(), this.getURI());
            }
            if (request2 != null) {
                Object input2 = null;
                input2 = this.content != RestOperation.NO_BODY ? this.content : new UrlEncodedFormEntity(this.getFormDataList().stream().map(x$0 -> new SimpleFormData((NameValuePair)x$0)).filter(SimplePart::isValid).collect(Collectors.toList()));
                if (input2 instanceof Supplier) {
                    input2 = ((Supplier)input2).get();
                }
                Object entity = null;
                if (input2 instanceof PartList) {
                    entity = new UrlEncodedFormEntity(((PartList)input2).stream().map(x$0 -> new SimpleFormData((NameValuePair)x$0)).filter(SimplePart::isValid).collect(Collectors.toList()));
                } else if (input2 instanceof HttpResource) {
                    HttpResource r = (HttpResource)input2;
                    r.getHeaders().forEach(x -> this.request.addHeader(x));
                    entity = (HttpEntity)input2;
                } else if (input2 instanceof HttpEntity) {
                    entity = input2 instanceof SerializedEntity ? ((SerializedEntity)input2).copyWith(serializer, this.contentSchema) : (HttpEntity)input2;
                } else if (input2 instanceof Reader) {
                    entity = HttpEntities.readerEntity((Reader)((Reader)input2), (ContentType)this.getRequestContentType(TEXT_PLAIN)).build();
                } else if (input2 instanceof InputStream) {
                    entity = HttpEntities.streamEntity((InputStream)((InputStream)input2), (long)-1L, (ContentType)this.getRequestContentType(ContentType.APPLICATION_OCTET_STREAM)).build();
                } else if (serializer != null) {
                    entity = HttpEntities.serializedEntity((Object)input2, (Serializer)serializer, (HttpPartSchema)this.contentSchema).contentType(contentType).build();
                } else {
                    if (this.client.hasSerializers()) {
                        if (contentType == null) {
                            throw new RestCallException(null, null, "Content-Type not specified on request.  Cannot match correct serializer.  Use contentType(String) or mediaType(String) to specify transport language.", new Object[0]);
                        }
                        throw new RestCallException(null, null, "No matching serializer for media type ''{0}''", contentType);
                    }
                    entity = HttpEntities.stringEntity((String)(input2 == null ? "" : BeanContext.DEFAULT.getClassMetaForObject(input2).toString(input2)), (ContentType)this.getRequestContentType(TEXT_PLAIN)).build();
                }
                request2.setEntity(entity);
            }
            this.response = this.client.createResponse(this, this.client.run(this.target, (HttpRequest)this.request, this.context), parser);
            if (this.isDebug() || this.client.logRequests == DetailLevel.FULL) {
                this.response.cacheContent();
            }
            for (RestCallInterceptor rci : this.interceptors) {
                rci.onConnect(this, this.response);
            }
            this.client.onConnect(this, this.response);
            String method = this.getMethod();
            int sc = this.response.getStatusCode();
            Thrown thrown = this.response.getHeader("Thrown").asHeader(Thrown.class);
            if (thrown.isPresent() && this.rethrow != null) {
                Thrown.Part thrownPart = (Thrown.Part)((List)thrown.asParts().get()).get(0);
                String className = thrownPart.getClassName();
                String message = thrownPart.getMessage();
                for (Class<? extends Throwable> t : this.rethrow) {
                    if (!t.getName().equals(className)) continue;
                    ConstructorInfo c = null;
                    ClassInfo ci = ClassInfo.of(t);
                    c = ci.getPublicConstructor(x -> x.hasParamTypes(new Class[]{HttpResponse.class}));
                    if (c != null) {
                        throw (Throwable)c.invoke(new Object[]{this.response});
                    }
                    c = ci.getPublicConstructor(x -> x.hasParamTypes(new Class[]{String.class}));
                    if (c != null) {
                        throw (Throwable)c.invoke(new Object[]{message != null ? message : this.response.getContent().asString()});
                    }
                    c = ci.getPublicConstructor(x -> x.hasParamTypes(new Class[]{String.class, Throwable.class}));
                    if (c != null) {
                        throw (Throwable)c.invoke(new Object[]{message != null ? message : this.response.getContent().asString(), null});
                    }
                    c = ci.getPublicConstructor(x -> x.hasNoParams());
                    if (c == null) continue;
                    throw (Throwable)c.invoke(new Object[0]);
                }
            }
            if (this.errorCodes.test(sc) && !this.ignoreErrors) {
                throw new RestCallException(this.response, null, "HTTP method ''{0}'' call to ''{1}'' caused response code ''{2}, {3}''.\nResponse: \n{4}", method, this.getURI(), sc, this.response.getReasonPhrase(), this.response.getContent().asAbbreviatedString(1000));
            }
        }
        catch (RuntimeException | RestCallException e) {
            if (this.response != null) {
                this.response.close();
            }
            throw e;
        }
        catch (Throwable e) {
            if (this.response != null) {
                this.response.close();
            }
            throw new RestCallException(this.response, e, "Call failed.", new Object[0]);
        }
        return this.response;
    }

    public Future<RestResponse> runFuture() throws RestCallException {
        return this.client.getExecutorService().submit(new Callable<RestResponse>(){

            @Override
            public RestResponse call() throws Exception {
                return RestRequest.this.run();
            }
        });
    }

    public RestResponse complete() throws RestCallException {
        return this.run().consume();
    }

    public Future<RestResponse> completeFuture() throws RestCallException {
        return this.client.getExecutorService().submit(new Callable<RestResponse>(){

            @Override
            public RestResponse call() throws Exception {
                return RestRequest.this.complete();
            }
        });
    }

    public boolean hasHttpEntity() {
        return this.request instanceof HttpEntityEnclosingRequestBase;
    }

    public HttpEntity getHttpEntity() {
        return this.hasHttpEntity() ? ((HttpEntityEnclosingRequestBase)this.request).getEntity() : null;
    }

    public RestRequest log(Level level, Throwable t, String msg, Object ... args) {
        this.client.log(level, t, msg, args);
        return this;
    }

    public RestRequest log(Level level, String msg, Object ... args) {
        this.client.log(level, msg, args);
        return this;
    }

    public RestRequest config(RequestConfig value) {
        this.request.setConfig(value);
        return this;
    }

    public RestRequest cancellable(Cancellable cancellable) {
        this.request.setCancellable(cancellable);
        return this;
    }

    public RestRequest protocolVersion(ProtocolVersion version) {
        this.request.setProtocolVersion(version);
        return this;
    }

    @Deprecated
    public RestRequest completed() {
        this.request.completed();
        return this;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public URI getURI() {
        return this.request.getURI();
    }

    public void abort() throws UnsupportedOperationException {
        this.request.abort();
    }

    public boolean isAborted() {
        return this.request.isAborted();
    }

    public RequestLine getRequestLine() {
        return this.request.getRequestLine();
    }

    public ProtocolVersion getProtocolVersion() {
        return this.request.getProtocolVersion();
    }

    public boolean containsHeader(String name) {
        return this.getHeaderList().contains(name);
    }

    public Header[] getHeaders(String name) {
        return this.getHeaderList().getAll(name);
    }

    public Header getFirstHeader(String name) {
        return this.getHeaderList().getFirst(name).orElse(null);
    }

    public Header getLastHeader(String name) {
        return this.getHeaderList().getLast(name).orElse(null);
    }

    public Header[] getAllHeaders() {
        return this.getHeaderList().getAll();
    }

    public void addHeader(Header header) {
        this.headers().append(header);
    }

    public void addHeader(String name, String value) {
        this.headers().append((Header)HttpHeaders.stringHeader((String)name, (String)value));
    }

    public void setHeader(Header header) {
        this.headers().set(header);
    }

    public void setHeader(String name, String value) {
        this.headers().set((Header)HttpHeaders.stringHeader((String)name, (String)value));
    }

    public void setHeaders(Header[] headers) {
        this.headers().set(headers);
    }

    public void removeHeader(Header header) {
        this.headers().remove(header);
    }

    public void removeHeaders(String name) {
        this.headers().remove(name);
    }

    public HeaderIterator headerIterator() {
        return this.getHeaderList().iterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.getHeaderList().iterator(name);
    }

    @Deprecated
    public HttpParams getParams() {
        return this.request.getParams();
    }

    @Deprecated
    public void setParams(HttpParams params) {
        this.request.setParams(params);
    }

    public RequestConfig getConfig() {
        return this.request.getConfig();
    }

    private ContentType getRequestContentType(ContentType def) {
        String s;
        Header h = this.request.getFirstHeader("Content-Type");
        if (h != null && !StringUtils.isEmpty((String)(s = h.getValue()))) {
            return ContentType.of((String)s);
        }
        return def;
    }

    private static Map<Object, Object> toMap(Object o) {
        return (Map)o;
    }

    protected Header createHeader(String name, Object value, HttpPartSerializer serializer, HttpPartSchema schema, Boolean skipIfEmpty) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        if (skipIfEmpty == null) {
            skipIfEmpty = this.client.isSkipEmptyHeaderData();
        }
        if (serializer == null) {
            serializer = this.client.getPartSerializer();
        }
        return new SerializedHeader(name, value, this.getPartSerializerSession(serializer), schema, skipIfEmpty.booleanValue());
    }

    private Header createHeader(String name, Object value) {
        return this.createHeader(name, value, null, null, null);
    }

    protected NameValuePair createPart(String name, Object value, HttpPartType type, HttpPartSerializer serializer, HttpPartSchema schema, Boolean skipIfEmpty) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        if (skipIfEmpty == null) {
            skipIfEmpty = type == HttpPartType.QUERY ? Boolean.valueOf(this.client.isSkipEmptyQueryData()) : (type == HttpPartType.FORMDATA ? Boolean.valueOf(this.client.isSkipEmptyFormData()) : Boolean.valueOf(false));
        }
        if (serializer == null) {
            serializer = this.client.getPartSerializer();
        }
        return new SerializedPart(name, value, type, this.getPartSerializerSession(serializer), schema, skipIfEmpty.booleanValue());
    }

    private NameValuePair createPart(HttpPartType type, String name, Object value) {
        return this.createPart(name, value, type, null, null, null);
    }

    private HttpPartSerializerSession getPartSerializerSession(HttpPartSerializer serializer) {
        HttpPartSerializerSession s;
        if (serializer == null) {
            serializer = this.client.getPartSerializer();
        }
        if ((s = this.partSerializerSessions.get(serializer)) == null) {
            s = serializer.getPartSession();
            this.partSerializerSessions.put(serializer, s);
        }
        return s;
    }

    HttpPartSerializerSession getPartSerializerSession() {
        if (this.partSerializerSession == null) {
            this.partSerializerSession = this.getPartSerializerSession(null);
        }
        return this.partSerializerSession;
    }

    private static boolean isNameValuePairArray(Object o) {
        if (o == null || !o.getClass().isArray()) {
            return false;
        }
        return NameValuePair.class.isAssignableFrom(o.getClass().getComponentType());
    }

    private static boolean isHeaderArray(Object o) {
        if (o == null || !o.getClass().isArray()) {
            return false;
        }
        return Header.class.isAssignableFrom(o.getClass().getComponentType());
    }

    protected JsonMap properties() {
        return JsonMap.filteredMap().append("client", (Object)this.client.properties()).append("ignoreErrors", (Object)this.ignoreErrors).append("interceptors", this.interceptors).append("requestBodySchema", (Object)this.contentSchema).append("response", (Object)this.response).append("serializer", (Object)this.serializer);
    }

    private class SimpleHeader
    extends SimplePart
    implements Header {
        SimpleHeader(NameValuePair x) {
            super(x, RestRequest.this.client.isSkipEmptyHeaderData());
        }

        public HeaderElement[] getElements() throws ParseException {
            return null;
        }
    }

    private class SimplePath
    extends SimplePart {
        SimplePath(NameValuePair x) {
            super(x, false);
        }
    }

    private class SimpleFormData
    extends SimplePart {
        SimpleFormData(NameValuePair x) {
            super(x, RestRequest.this.client.isSkipEmptyFormData());
        }
    }

    private class SimpleQuery
    extends SimplePart {
        SimpleQuery(NameValuePair x) {
            super(x, RestRequest.this.client.isSkipEmptyQueryData());
        }
    }

    private class SimplePart
    implements NameValuePair {
        final String name;
        final String value;

        SimplePart(NameValuePair x, boolean skipIfEmpty) {
            String v;
            this.name = x.getName();
            this.value = x instanceof SerializedHeader ? ((SerializedHeader)x).copyWith(RestRequest.this.getPartSerializerSession(), null).getValue() : (x instanceof SerializedPart ? ((SerializedPart)x).copyWith(RestRequest.this.getPartSerializerSession(), null).getValue() : (StringUtils.isEmpty((String)(v = x.getValue())) && skipIfEmpty ? null : v));
        }

        boolean isValid() {
            return !StringUtils.isEmpty((String)this.name) && this.value != null;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

