/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.matcher;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.rest.matcher.RestMatcher;

public class RestMatcherList {
    private final RestMatcher[] optionalEntries;
    private final RestMatcher[] requiredEntries;

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    protected RestMatcherList(Builder builder) {
        List l = builder.entries.stream().map(x -> (RestMatcher)x.run()).collect(Collectors.toList());
        this.optionalEntries = (RestMatcher[])l.stream().filter(x -> !x.required()).toArray(RestMatcher[]::new);
        this.requiredEntries = (RestMatcher[])l.stream().filter(x -> x.required()).toArray(RestMatcher[]::new);
    }

    public RestMatcher[] getOptionalEntries() {
        return this.optionalEntries;
    }

    public RestMatcher[] getRequiredEntries() {
        return this.requiredEntries;
    }

    @FluentSetters
    public static class Builder
    extends BeanBuilder<RestMatcherList> {
        List<BeanCreator<RestMatcher>> entries = CollectionUtils.list(new BeanCreator[0]);

        protected Builder(BeanStore beanStore) {
            super(RestMatcherList.class, beanStore);
        }

        @Override
        protected RestMatcherList buildDefault() {
            return new RestMatcherList(this);
        }

        public Builder append(Class<? extends RestMatcher> ... values) {
            for (Class<? extends RestMatcher> v : values) {
                this.entries.add(this.beanStore().createBean(RestMatcher.class).type(v));
            }
            return this;
        }

        public Builder append(RestMatcher ... values) {
            for (RestMatcher v : values) {
                this.entries.add(this.beanStore().createBean(RestMatcher.class).impl(v));
            }
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }
    }
}

