/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.internal.ConfigMap;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.parser.ParseException;

public class Section {
    final Config config;
    private final ConfigMap configMap;
    final String name;

    protected Section(Config config, ConfigMap configMap, String name) {
        this.config = config;
        this.configMap = configMap;
        this.name = name;
    }

    public boolean isPresent() {
        return this.configMap.hasSection(this.name);
    }

    public <T> Optional<T> asBean(Class<T> c) throws ParseException {
        return this.asBean(c, false);
    }

    public <T> Optional<T> asBean(Class<T> c, boolean ignoreUnknownProperties) throws ParseException {
        Assertions.assertArgNotNull((String)"c", c);
        if (!this.isPresent()) {
            return CollectionUtils.empty();
        }
        Set<String> keys = this.configMap.getKeys(this.name);
        BeanMap bm = this.config.beanSession.newBeanMap(c);
        for (String k : keys) {
            BeanPropertyMeta bpm = bm.getPropertyMeta(k);
            if (bpm == null) {
                if (ignoreUnknownProperties) continue;
                throw new ParseException("Unknown property ''{0}'' encountered in configuration section ''{1}''.", new Object[]{k, this.name});
            }
            bm.put(k, this.config.get(this.name + '/' + k).as(bpm.getClassMeta().getInnerClass()).orElse(null));
        }
        return CollectionUtils.optional((Object)bm.getBean());
    }

    public Optional<JsonMap> asMap() {
        if (!this.isPresent()) {
            return CollectionUtils.empty();
        }
        Set<String> keys = this.configMap.getKeys(this.name);
        JsonMap m = new JsonMap();
        for (String k : keys) {
            m.put(k, this.config.get(this.name + '/' + k).as(Object.class).orElse(null));
        }
        return CollectionUtils.optional((Object)m);
    }

    public <T> Optional<T> asInterface(final Class<T> c) {
        Assertions.assertArgNotNull((String)"c", c);
        if (!c.isInterface()) {
            throw ThrowableUtils.illegalArgumentException((String)"Class ''{0}'' passed to toInterface() is not an interface.", (Object[])new Object[]{c.getName()});
        }
        InvocationHandler h = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                BeanInfo bi = Introspector.getBeanInfo(c, null);
                for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                    Method rm = pd.getReadMethod();
                    Method wm = pd.getWriteMethod();
                    if (method.equals(rm)) {
                        return Section.this.config.get(Section.this.name + '/' + pd.getName()).as(rm.getGenericReturnType(), new Type[0]).orElse(null);
                    }
                    if (!method.equals(wm)) continue;
                    return Section.this.config.set(Section.this.name + '/' + pd.getName(), args[0]);
                }
                throw ThrowableUtils.unsupportedOperationException((String)"Unsupported interface method.  method=''{0}''", (Object[])new Object[]{method});
            }
        };
        return CollectionUtils.optional((Object)Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, h));
    }

    public Section writeToBean(Object bean, boolean ignoreUnknownProperties) throws ParseException {
        Assertions.assertArgNotNull((String)"bean", (Object)bean);
        if (!this.isPresent()) {
            throw ThrowableUtils.illegalArgumentException((String)"Section ''{0}'' not found in configuration.", (Object[])new Object[]{this.name});
        }
        Set<String> keys = this.configMap.getKeys(this.name);
        BeanMap bm = this.config.beanSession.toBeanMap(bean);
        for (String k : keys) {
            BeanPropertyMeta bpm = bm.getPropertyMeta(k);
            if (bpm == null) {
                if (ignoreUnknownProperties) continue;
                throw new ParseException("Unknown property ''{0}'' encountered in configuration section ''{1}''.", new Object[]{k, this.name});
            }
            bm.put(k, this.config.get(this.name + '/' + k).as(bpm.getClassMeta().getInnerClass()).orElse(null));
        }
        return this;
    }
}

