/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.assertions.FluentStringListAssertion;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.ThrowableUtils;

@FluentSetters(returns="FluentThrowableAssertion<T,R>")
public class FluentThrowableAssertion<T extends Throwable, R>
extends FluentObjectAssertion<T, R> {
    private static final Messages MESSAGES = Messages.of(FluentThrowableAssertion.class, "Messages");
    private static final String MSG_exceptionWasNotExpectedType = MESSAGES.getString("exceptionWasNotExpectedType");
    private static final String MSG_exceptionWasNotThrown = MESSAGES.getString("exceptionWasNotThrown");
    private static final String MSG_causedByExceptionNotExpectedType = MESSAGES.getString("causedByExceptionNotExpectedType");

    public FluentThrowableAssertion(T value, R returns) {
        this(null, value, returns);
    }

    public FluentThrowableAssertion(Assertion creator, T value, R returns) {
        super(creator, value, returns);
    }

    @Override
    public FluentThrowableAssertion<T, R> asTransformed(Function<T, T> function) {
        return new FluentThrowableAssertion(this, (Throwable)function.apply(this.orElse(null)), this.returns());
    }

    public FluentStringAssertion<R> asMessage() {
        return new FluentStringAssertion((Assertion)this, this.map(Throwable::getMessage).orElse(null), this.returns());
    }

    public FluentListAssertion<String, R> asMessages() {
        List<String> l = null;
        Throwable t = this.orElse(null);
        if (t != null) {
            if (t.getCause() == null) {
                l = Collections.singletonList(t.getMessage());
            } else {
                l = CollectionUtils.list(new String[0]);
                while (t != null) {
                    l.add(t.getMessage());
                    t = t.getCause();
                }
            }
        }
        return new FluentListAssertion((Assertion)this, l, this.returns());
    }

    public FluentStringAssertion<R> asLocalizedMessage() {
        return new FluentStringAssertion((Assertion)this, this.map(Throwable::getLocalizedMessage).orElse(null), this.returns());
    }

    public FluentListAssertion<String, R> asLocalizedMessages() {
        List<String> l = null;
        Throwable t = this.orElse(null);
        if (t != null) {
            if (t.getCause() == null) {
                l = Collections.singletonList(t.getMessage());
            } else {
                l = CollectionUtils.list(new String[0]);
                while (t != null) {
                    l.add(t.getLocalizedMessage());
                    t = t.getCause();
                }
            }
        }
        return new FluentListAssertion((Assertion)this, l, this.returns());
    }

    public FluentStringListAssertion<R> asStackTrace() {
        return new FluentStringListAssertion((Assertion)this, this.valueIsNull() ? null : Arrays.asList(ThrowableUtils.getStackTrace((Throwable)this.value())), this.returns());
    }

    public FluentThrowableAssertion<Throwable, R> asCausedBy() {
        return this.asCausedBy(Throwable.class);
    }

    public <X extends Throwable> FluentThrowableAssertion<X, R> asCausedBy(Class<X> type) {
        Throwable t = this.map(Throwable::getCause).orElse(null);
        if (t == null || type.isInstance(t)) {
            return new FluentThrowableAssertion(this, (Throwable)type.cast(t), this.returns());
        }
        throw this.error(MSG_causedByExceptionNotExpectedType, type, t.getClass());
    }

    public <X extends Throwable> FluentThrowableAssertion<X, R> asFind(Class<X> throwableClass) {
        for (Throwable t = (Throwable)this.orElse(null); t != null; t = t.getCause()) {
            if (!throwableClass.isInstance(t)) continue;
            return new FluentThrowableAssertion(this, (Throwable)throwableClass.cast(t), this.returns());
        }
        return new FluentThrowableAssertion(this, null, this.returns());
    }

    @Override
    public R isType(Class<?> parent) {
        Assertions.assertArgNotNull("parent", parent);
        if (!parent.isInstance(this.value())) {
            throw this.error(MSG_exceptionWasNotExpectedType, FluentThrowableAssertion.className(parent), FluentThrowableAssertion.className(this.value()));
        }
        return this.returns();
    }

    @Override
    public R isExactType(Class<?> type) {
        Assertions.assertArgNotNull("type", type);
        if (type != ((Throwable)this.value()).getClass()) {
            throw this.error(MSG_exceptionWasNotExpectedType, FluentThrowableAssertion.className(type), FluentThrowableAssertion.className(this.value()));
        }
        return this.returns();
    }

    @Override
    public R isExists() {
        if (this.valueIsNull()) {
            throw this.error(MSG_exceptionWasNotThrown, new Object[0]);
        }
        return this.returns();
    }

    @Override
    public FluentThrowableAssertion<T, R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentThrowableAssertion<T, R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentThrowableAssertion<T, R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentThrowableAssertion<T, R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentThrowableAssertion<T, R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }

    @Override
    protected boolean equals(Object o1, Object o2) {
        if (o1 instanceof Throwable && o2 instanceof Throwable) {
            return ObjectUtils.eq((Throwable)o1, (Throwable)o2, (x, y) -> ObjectUtils.eq(x.getClass(), y.getClass()) && ObjectUtils.eq(x.getMessage(), y.getMessage()));
        }
        return super.equals(o1, o2);
    }
}

