/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.entity.HttpEntityBuilder;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.ReaderInputStream;

public class ReaderEntity
extends BasicHttpEntity {
    private final Reader content = this.contentOrElse(IOUtils.EMPTY_READER);
    private final long contentLength;
    private final Charset charset;
    private final byte[] cache;

    public static HttpEntityBuilder<ReaderEntity> create() {
        return new HttpEntityBuilder<Class<ReaderEntity>>(ReaderEntity.class);
    }

    public ReaderEntity(HttpEntityBuilder<?> builder) throws IOException {
        super(builder);
        this.charset = ObjectUtils.firstNonNull(builder.charset, IOUtils.UTF8);
        this.cache = builder.cached ? IOUtils.readBytes(this.content) : null;
        this.contentLength = builder.contentLength == -1L && this.cache != null ? (long)this.cache.length : builder.contentLength;
    }

    public HttpEntityBuilder<ReaderEntity> copy() {
        return new HttpEntityBuilder<ReaderEntity>(this);
    }

    @Override
    public String asString() throws IOException {
        return this.cache == null ? IOUtils.read(this.content) : new String(this.cache, IOUtils.UTF8);
    }

    @Override
    public byte[] asBytes() throws IOException {
        return this.cache == null ? this.asString().getBytes(IOUtils.UTF8) : this.cache;
    }

    @Override
    public boolean isRepeatable() {
        return this.cache != null;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public InputStream getContent() throws IOException {
        return this.cache == null ? new ReaderInputStream(this.content, this.charset) : new ByteArrayInputStream(this.cache);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        Assertions.assertArgNotNull("out", out);
        if (this.cache != null) {
            out.write(this.cache);
        } else {
            OutputStreamWriter osw = new OutputStreamWriter(out, this.charset);
            IOUtils.pipe(this.content, (Writer)osw);
            osw.flush();
        }
        out.flush();
    }

    @Override
    public boolean isStreaming() {
        return this.cache == null;
    }
}

