/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SslClientAuth;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.eclipse.jetty.util.StringUtil;

public abstract class RestServerConfig
extends AbstractConfig {
    public static final String LISTENERS_CONFIG = "listeners";
    private static final String LISTENERS_DOC = "List of comma-separated URIs the REST API will listen on. The supported protocols are HTTP and HTTPS.\n Specify hostname as 0.0.0.0 to bind to all interfaces.\n Leave hostname empty to bind to default interface.\n Examples of legal listener lists: HTTP://myhost:8083,HTTPS://myhost:8084";
    static final List<String> LISTENERS_DEFAULT = Collections.singletonList("http://:8083");
    public static final String REST_ADVERTISED_HOST_NAME_CONFIG = "rest.advertised.host.name";
    private static final String REST_ADVERTISED_HOST_NAME_DOC = "If this is set, this is the hostname that will be given out to other workers to connect to.";
    public static final String REST_ADVERTISED_PORT_CONFIG = "rest.advertised.port";
    private static final String REST_ADVERTISED_PORT_DOC = "If this is set, this is the port that will be given out to other workers to connect to.";
    public static final String REST_ADVERTISED_LISTENER_CONFIG = "rest.advertised.listener";
    private static final String REST_ADVERTISED_LISTENER_DOC = "Sets the advertised listener (HTTP or HTTPS) which will be given to other workers to use.";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_CONFIG = "access.control.allow.origin";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN_DOC = "Value to set the Access-Control-Allow-Origin header to for REST API requests.To enable cross origin access, set this to the domain of the application that should be permitted to access the API, or '*' to allow access from any domain. The default value only allows access from the domain of the REST API.";
    protected static final String ACCESS_CONTROL_ALLOW_ORIGIN_DEFAULT = "";
    public static final String ACCESS_CONTROL_ALLOW_METHODS_CONFIG = "access.control.allow.methods";
    private static final String ACCESS_CONTROL_ALLOW_METHODS_DOC = "Sets the methods supported for cross origin requests by setting the Access-Control-Allow-Methods header. The default value of the Access-Control-Allow-Methods header allows cross origin requests for GET, POST and HEAD.";
    private static final String ACCESS_CONTROL_ALLOW_METHODS_DEFAULT = "";
    public static final String ADMIN_LISTENERS_CONFIG = "admin.listeners";
    private static final String ADMIN_LISTENERS_DOC = "List of comma-separated URIs the Admin REST API will listen on. The supported protocols are HTTP and HTTPS. An empty or blank string will disable this feature. The default behavior is to use the regular listener (specified by the 'listeners' property).";
    public static final String ADMIN_LISTENERS_HTTPS_CONFIGS_PREFIX = "admin.listeners.https.";
    public static final String REST_EXTENSION_CLASSES_CONFIG = "rest.extension.classes";
    private static final String REST_EXTENSION_CLASSES_DOC = "Comma-separated names of <code>ConnectRestExtension</code> classes, loaded and called in the order specified. Implementing the interface  <code>ConnectRestExtension</code> allows you to inject into Connect's REST API user defined resources like filters. Typically used to add custom capability like logging, security, etc. ";
    static final String RESPONSE_HTTP_HEADERS_CONFIG = "response.http.headers.config";
    static final String RESPONSE_HTTP_HEADERS_DOC = "Rules for REST API HTTP response headers";
    static final String RESPONSE_HTTP_HEADERS_DEFAULT = "";
    private static final Collection<String> HEADER_ACTIONS = Collections.unmodifiableList(Arrays.asList("set", "add", "setDate", "addDate"));

    public abstract List<String> adminListeners();

    public abstract List<String> restExtensions();

    public abstract boolean topicTrackingEnabled();

    public abstract boolean topicTrackingResetEnabled();

    public static void addPublicConfig(ConfigDef configDef) {
        RestServerConfig.addInternalConfig(configDef);
        configDef.define(REST_EXTENSION_CLASSES_CONFIG, ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, REST_EXTENSION_CLASSES_DOC).define(ADMIN_LISTENERS_CONFIG, ConfigDef.Type.LIST, null, (ConfigDef.Validator)new AdminListenersValidator(), ConfigDef.Importance.LOW, ADMIN_LISTENERS_DOC);
    }

    public static void addInternalConfig(ConfigDef configDef) {
        configDef.define(LISTENERS_CONFIG, ConfigDef.Type.LIST, LISTENERS_DEFAULT, (ConfigDef.Validator)new ListenersValidator(), ConfigDef.Importance.LOW, LISTENERS_DOC).define(REST_ADVERTISED_HOST_NAME_CONFIG, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, REST_ADVERTISED_HOST_NAME_DOC).define(REST_ADVERTISED_PORT_CONFIG, ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, REST_ADVERTISED_PORT_DOC).define(REST_ADVERTISED_LISTENER_CONFIG, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, REST_ADVERTISED_LISTENER_DOC).define(ACCESS_CONTROL_ALLOW_ORIGIN_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, ACCESS_CONTROL_ALLOW_ORIGIN_DOC).define(ACCESS_CONTROL_ALLOW_METHODS_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, ACCESS_CONTROL_ALLOW_METHODS_DOC).define(RESPONSE_HTTP_HEADERS_CONFIG, ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)new ResponseHttpHeadersValidator(), ConfigDef.Importance.LOW, RESPONSE_HTTP_HEADERS_DOC).define("ssl.client.auth", ConfigDef.Type.STRING, (Object)SslClientAuth.NONE.toString(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])Utils.enumOptions(SslClientAuth.class)), ConfigDef.Importance.LOW, "Configures kafka broker to request client authentication. The following settings are common:  <ul> <li><code>ssl.client.auth=required</code> If set to required client authentication is required. <li><code>ssl.client.auth=requested</code> This means client authentication is optional. unlike required, if this option is set client can choose not to provide authentication information about itself <li><code>ssl.client.auth=none</code> This means client authentication is not needed.</ul>");
    }

    public static RestServerConfig forPublic(Integer rebalanceTimeoutMs, Map<?, ?> props) {
        return new PublicConfig(rebalanceTimeoutMs, props);
    }

    public static RestServerConfig forInternal(Map<?, ?> props) {
        return new InternalConfig(props);
    }

    public List<String> listeners() {
        return this.getList(LISTENERS_CONFIG);
    }

    public String rawListeners() {
        return (String)this.originals().get(LISTENERS_CONFIG);
    }

    public String allowedOrigins() {
        return this.getString(ACCESS_CONTROL_ALLOW_ORIGIN_CONFIG);
    }

    public String allowedMethods() {
        return this.getString(ACCESS_CONTROL_ALLOW_METHODS_CONFIG);
    }

    public String responseHeaders() {
        return this.getString(RESPONSE_HTTP_HEADERS_CONFIG);
    }

    public String advertisedListener() {
        return this.getString(REST_ADVERTISED_LISTENER_CONFIG);
    }

    public String advertisedHostName() {
        return this.getString(REST_ADVERTISED_HOST_NAME_CONFIG);
    }

    public Integer advertisedPort() {
        return this.getInt(REST_ADVERTISED_PORT_CONFIG);
    }

    public Integer rebalanceTimeoutMs() {
        return null;
    }

    protected RestServerConfig(ConfigDef configDef, Map<?, ?> props) {
        super(configDef, props, Utils.castToStringObjectMap(props), true);
    }

    static void validateHttpResponseHeaderConfig(String config) {
        try {
            String[] configTokens = config.trim().split("\\s+", 2);
            if (configTokens.length != 2) {
                throw new ConfigException(String.format("Invalid format of header config '%s'. Expected: '[action] [header name]:[header value]'", config));
            }
            String method = configTokens[0].trim();
            RestServerConfig.validateHeaderConfigAction(method);
            String header = configTokens[1];
            String[] headerTokens = header.trim().split(":");
            if (headerTokens.length != 2) {
                throw new ConfigException(String.format("Invalid format of header name and header value pair '%s'. Expected: '[header name]:[header value]'", header));
            }
            String headerName = headerTokens[0].trim();
            if (headerName.isEmpty() || headerName.matches(".*\\s+.*")) {
                throw new ConfigException(String.format("Invalid header name '%s'. The '[header name]' cannot contain whitespace", headerName));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ConfigException(String.format("Invalid header config '%s'.", config), (Object)e);
        }
    }

    static void validateHeaderConfigAction(String action) {
        if (HEADER_ACTIONS.stream().noneMatch(action::equalsIgnoreCase)) {
            throw new ConfigException(String.format("Invalid header config action: '%s'. Expected one of %s", action, HEADER_ACTIONS));
        }
    }

    private static class PublicConfig
    extends RestServerConfig {
        private final Integer rebalanceTimeoutMs;

        private static ConfigDef config() {
            ConfigDef result = new ConfigDef().withClientSslSupport();
            PublicConfig.addPublicConfig(result);
            WorkerConfig.addTopicTrackingConfig(result);
            return result;
        }

        @Override
        public List<String> adminListeners() {
            return this.getList(RestServerConfig.ADMIN_LISTENERS_CONFIG);
        }

        @Override
        public List<String> restExtensions() {
            return this.getList(RestServerConfig.REST_EXTENSION_CLASSES_CONFIG);
        }

        @Override
        public Integer rebalanceTimeoutMs() {
            return this.rebalanceTimeoutMs;
        }

        @Override
        public boolean topicTrackingEnabled() {
            return this.getBoolean("topic.tracking.enable");
        }

        @Override
        public boolean topicTrackingResetEnabled() {
            return this.getBoolean("topic.tracking.allow.reset");
        }

        public PublicConfig(Integer rebalanceTimeoutMs, Map<?, ?> props) {
            super(PublicConfig.config(), props);
            this.rebalanceTimeoutMs = rebalanceTimeoutMs;
        }
    }

    private static class InternalConfig
    extends RestServerConfig {
        private static ConfigDef config() {
            ConfigDef result = new ConfigDef().withClientSslSupport();
            InternalConfig.addInternalConfig(result);
            return result;
        }

        @Override
        public List<String> adminListeners() {
            return Collections.emptyList();
        }

        @Override
        public List<String> restExtensions() {
            return null;
        }

        @Override
        public boolean topicTrackingEnabled() {
            return false;
        }

        @Override
        public boolean topicTrackingResetEnabled() {
            return false;
        }

        public InternalConfig(Map<?, ?> props) {
            super(InternalConfig.config(), props);
        }
    }

    private static class ResponseHttpHeadersValidator
    implements ConfigDef.Validator {
        private ResponseHttpHeadersValidator() {
        }

        public void ensureValid(String name, Object value) {
            String strValue = (String)value;
            if (Utils.isBlank((String)strValue)) {
                return;
            }
            String[] configs = StringUtil.csvSplit((String)strValue);
            Arrays.stream(configs).forEach(RestServerConfig::validateHttpResponseHeaderConfig);
        }

        public String toString() {
            return "Comma-separated header rules, where each header rule is of the form '[action] [header name]:[header value]' and optionally surrounded by double quotes if any part of a header rule contains a comma";
        }
    }

    private static class AdminListenersValidator
    implements ConfigDef.Validator {
        private AdminListenersValidator() {
        }

        public void ensureValid(String name, Object value) {
            if (value == null) {
                return;
            }
            if (!(value instanceof List)) {
                throw new ConfigException("Invalid value type for admin.listeners (expected list).");
            }
            List items = (List)value;
            if (items.isEmpty()) {
                return;
            }
            for (Object item : items) {
                if (!(item instanceof String)) {
                    throw new ConfigException("Invalid type for admin.listeners (expected String).");
                }
                if (!Utils.isBlank((String)((String)item))) continue;
                throw new ConfigException("Empty URL found when parsing admin.listeners list.");
            }
        }

        public String toString() {
            return "List of comma-separated URLs, ex: http://localhost:8080,https://localhost:8443.";
        }
    }

    private static class ListenersValidator
    implements ConfigDef.Validator {
        private ListenersValidator() {
        }

        public void ensureValid(String name, Object value) {
            if (!(value instanceof List)) {
                throw new ConfigException("Invalid value type for listeners (expected list of URLs , ex: http://localhost:8080,https://localhost:8443).");
            }
            List items = (List)value;
            if (items.isEmpty()) {
                throw new ConfigException("Invalid value for listeners, at least one URL is expected, ex: http://localhost:8080,https://localhost:8443.");
            }
            for (Object item : items) {
                if (!(item instanceof String)) {
                    throw new ConfigException("Invalid type for listeners (expected String).");
                }
                if (!Utils.isBlank((String)((String)item))) continue;
                throw new ConfigException("Empty URL found when parsing listeners list.");
            }
        }

        public String toString() {
            return "List of comma-separated URLs, ex: http://localhost:8080,https://localhost:8443.";
        }
    }
}

