/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.compress;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.Lz4BlockInputStream;
import org.apache.kafka.common.compress.Lz4BlockOutputStream;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.ChunkedBytesStream;

public class Lz4Compression
implements Compression {
    public static final int MIN_LEVEL = 1;
    public static final int MAX_LEVEL = 17;
    public static final int DEFAULT_LEVEL = 9;
    private final int level;

    private Lz4Compression(int level) {
        this.level = level;
    }

    @Override
    public CompressionType type() {
        return CompressionType.LZ4;
    }

    @Override
    public OutputStream wrapForOutput(ByteBufferOutputStream buffer, byte messageVersion) {
        try {
            return new Lz4BlockOutputStream(buffer, this.level, messageVersion == 0);
        }
        catch (Throwable e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public InputStream wrapForInput(ByteBuffer inputBuffer, byte messageVersion, BufferSupplier decompressionBufferSupplier) {
        try {
            return new ChunkedBytesStream(new Lz4BlockInputStream(inputBuffer, decompressionBufferSupplier, messageVersion == 0), decompressionBufferSupplier, this.decompressionOutputSize(), true);
        }
        catch (Throwable e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public int decompressionOutputSize() {
        return 2048;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Lz4Compression that = (Lz4Compression)o;
        return this.level == that.level;
    }

    public int hashCode() {
        return Objects.hash(this.level);
    }

    public static class Builder
    implements Compression.Builder<Lz4Compression> {
        private int level = 9;

        public Builder level(int level) {
            if (level < 1 || 17 < level) {
                throw new IllegalArgumentException("lz4 doesn't support given compression level: " + level);
            }
            this.level = level;
            return this;
        }

        @Override
        public Lz4Compression build() {
            return new Lz4Compression(this.level);
        }
    }
}

