/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.TimestampedBytesStore;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.PrefixedWindowKeySchemas;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedWindowSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.StoreQueryUtils;
import org.apache.kafka.streams.state.internals.WindowStoreIteratorWrapper;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class RocksDBTimeOrderedWindowStore
extends WrappedStateStore<RocksDBTimeOrderedWindowSegmentedBytesStore, Object, Object>
implements WindowStore<Bytes, byte[]>,
TimestampedBytesStore {
    private final boolean retainDuplicates;
    private final long windowSize;
    private int seqnum = 0;
    private StateStoreContext stateStoreContext;

    RocksDBTimeOrderedWindowStore(RocksDBTimeOrderedWindowSegmentedBytesStore store, boolean retainDuplicates, long windowSize) {
        super(store);
        Objects.requireNonNull(store, "store is null");
        this.retainDuplicates = retainDuplicates;
        this.windowSize = windowSize;
    }

    @Override
    public void init(StateStoreContext context, StateStore root) {
        this.stateStoreContext = context;
        ((RocksDBTimeOrderedWindowSegmentedBytesStore)this.wrapped()).init(context, root);
    }

    @Override
    public void flush() {
        ((RocksDBTimeOrderedWindowSegmentedBytesStore)this.wrapped()).flush();
    }

    @Override
    public void close() {
        ((RocksDBTimeOrderedWindowSegmentedBytesStore)this.wrapped()).close();
    }

    @Override
    public boolean persistent() {
        return ((RocksDBTimeOrderedWindowSegmentedBytesStore)this.wrapped()).persistent();
    }

    @Override
    public boolean isOpen() {
        return ((RocksDBTimeOrderedWindowSegmentedBytesStore)this.wrapped()).isOpen();
    }

    @Override
    public void put(Bytes key, byte[] value, long windowStartTimestamp) {
        if (value != null || !this.retainDuplicates) {
            this.maybeUpdateSeqnumForDups();
            ((RocksDBTimeOrderedWindowSegmentedBytesStore)this.wrapped()).put(key, windowStartTimestamp, this.seqnum, value);
        }
    }

    @Override
    public byte[] fetch(Bytes key, long timestamp) {
        return ((RocksDBTimeOrderedWindowSegmentedBytesStore)this.wrapped()).fetch(key, timestamp, this.seqnum);
    }

    @Override
    public WindowStoreIterator<byte[]> fetch(Bytes key, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedWindowSegmentedBytesStore)this.wrapped()).fetch(key, timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey).valuesIterator();
    }

    @Override
    public WindowStoreIterator<byte[]> backwardFetch(Bytes key, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedWindowSegmentedBytesStore)this.wrapped()).backwardFetch(key, timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey).valuesIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedWindowSegmentedBytesStore)this.wrapped()).fetch(keyFrom, keyTo, timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedWindowSegmentedBytesStore)this.wrapped()).backwardFetch(keyFrom, keyTo, timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> all() {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedWindowSegmentedBytesStore)this.wrapped()).all();
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardAll() {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedWindowSegmentedBytesStore)this.wrapped()).backwardAll();
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetchAll(long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedWindowSegmentedBytesStore)this.wrapped()).fetchAll(timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetchAll(long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedWindowSegmentedBytesStore)this.wrapped()).backwardFetchAll(timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp, PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey).keyValueIterator();
    }

    public boolean hasIndex() {
        return ((RocksDBTimeOrderedWindowSegmentedBytesStore)this.wrapped()).hasIndex();
    }

    @Override
    public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
        return StoreQueryUtils.handleBasicQueries(query, positionBound, config, this, this.getPosition(), this.stateStoreContext);
    }

    private void maybeUpdateSeqnumForDups() {
        if (this.retainDuplicates) {
            this.seqnum = this.seqnum + 1 & Integer.MAX_VALUE;
        }
    }
}

