/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class InitProducerIdResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    long producerId;
    short producerEpoch;
    long ongoingTxnProducerId;
    short ongoingTxnProducerEpoch;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 6;

    public InitProducerIdResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public InitProducerIdResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.producerId = -1L;
        this.producerEpoch = 0;
        this.ongoingTxnProducerId = -1L;
        this.ongoingTxnProducerEpoch = (short)-1;
    }

    @Override
    public short apiKey() {
        return 22;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 6;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        this.producerId = _readable.readLong();
        this.producerEpoch = _readable.readShort();
        this.ongoingTxnProducerId = _version >= 6 ? _readable.readLong() : -1L;
        this.ongoingTxnProducerEpoch = _version >= 6 ? _readable.readShort() : (short)-1;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        _writable.writeLong(this.producerId);
        _writable.writeShort(this.producerEpoch);
        if (_version >= 6) {
            _writable.writeLong(this.ongoingTxnProducerId);
        } else if (this.ongoingTxnProducerId != -1L) {
            throw new UnsupportedVersionException("Attempted to write a non-default ongoingTxnProducerId at version " + _version);
        }
        if (_version >= 6) {
            _writable.writeShort(this.ongoingTxnProducerEpoch);
        } else if (this.ongoingTxnProducerEpoch != -1) {
            throw new UnsupportedVersionException("Attempted to write a non-default ongoingTxnProducerEpoch at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        _size.addBytes(8);
        _size.addBytes(2);
        if (_version >= 6) {
            _size.addBytes(8);
        }
        if (_version >= 6) {
            _size.addBytes(2);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InitProducerIdResponseData)) {
            return false;
        }
        InitProducerIdResponseData other = (InitProducerIdResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.producerId != other.producerId) {
            return false;
        }
        if (this.producerEpoch != other.producerEpoch) {
            return false;
        }
        if (this.ongoingTxnProducerId != other.ongoingTxnProducerId) {
            return false;
        }
        if (this.ongoingTxnProducerEpoch != other.ongoingTxnProducerEpoch) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
        hashCode = 31 * hashCode + this.producerEpoch;
        hashCode = 31 * hashCode + ((int)(this.ongoingTxnProducerId >> 32) ^ (int)this.ongoingTxnProducerId);
        hashCode = 31 * hashCode + this.ongoingTxnProducerEpoch;
        return hashCode;
    }

    @Override
    public InitProducerIdResponseData duplicate() {
        InitProducerIdResponseData _duplicate = new InitProducerIdResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.producerId = this.producerId;
        _duplicate.producerEpoch = this.producerEpoch;
        _duplicate.ongoingTxnProducerId = this.ongoingTxnProducerId;
        _duplicate.ongoingTxnProducerEpoch = this.ongoingTxnProducerEpoch;
        return _duplicate;
    }

    public String toString() {
        return "InitProducerIdResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", ongoingTxnProducerId=" + this.ongoingTxnProducerId + ", ongoingTxnProducerEpoch=" + this.ongoingTxnProducerEpoch + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public long ongoingTxnProducerId() {
        return this.ongoingTxnProducerId;
    }

    public short ongoingTxnProducerEpoch() {
        return this.ongoingTxnProducerEpoch;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public InitProducerIdResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public InitProducerIdResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public InitProducerIdResponseData setProducerId(long v) {
        this.producerId = v;
        return this;
    }

    public InitProducerIdResponseData setProducerEpoch(short v) {
        this.producerEpoch = v;
        return this;
    }

    public InitProducerIdResponseData setOngoingTxnProducerId(long v) {
        this.ongoingTxnProducerId = v;
        return this;
    }

    public InitProducerIdResponseData setOngoingTxnProducerEpoch(short v) {
        this.ongoingTxnProducerEpoch = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("producer_id", Type.INT64, "The current producer id."), new Field("producer_epoch", Type.INT16, "The current epoch associated with the producer id."));
        SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("producer_id", Type.INT64, "The current producer id."), new Field("producer_epoch", Type.INT16, "The current epoch associated with the producer id."), Field.TaggedFieldsSection.of(new Object[0]))));
        SCHEMA_6 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("producer_id", Type.INT64, "The current producer id."), new Field("producer_epoch", Type.INT16, "The current epoch associated with the producer id."), new Field("ongoing_txn_producer_id", Type.INT64, "The producer id for ongoing transaction when KeepPreparedTxn is used, -1 if there is no transaction ongoing."), new Field("ongoing_txn_producer_epoch", Type.INT16, "The epoch associated with the  producer id for ongoing transaction when KeepPreparedTxn is used, -1 if there is no transaction ongoing."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
    }
}

