/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.avro.SupportsRowPosition;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.common.DynClasses;
import org.apache.iceberg.data.avro.DecoderResolver;

public class GenericAvroReader<T>
implements DatumReader<T>,
SupportsRowPosition {
    private final Schema readSchema;
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private Schema fileSchema = null;
    private ValueReader<T> reader = null;

    public static <D> GenericAvroReader<D> create(Schema schema) {
        return new GenericAvroReader(schema);
    }

    GenericAvroReader(Schema readSchema) {
        this.readSchema = readSchema;
    }

    private void initReader() {
        this.reader = (ValueReader)AvroSchemaVisitor.visit(this.readSchema, new ReadBuilder(this.loader));
    }

    public void setSchema(Schema schema) {
        this.fileSchema = Schema.applyAliases((Schema)schema, (Schema)this.readSchema);
        this.initReader();
    }

    public void setClassLoader(ClassLoader newClassLoader) {
        this.loader = newClassLoader;
    }

    @Override
    public void setRowPositionSupplier(Supplier<Long> posSupplier) {
        if (this.reader instanceof SupportsRowPosition) {
            ((SupportsRowPosition)((Object)this.reader)).setRowPositionSupplier(posSupplier);
        }
    }

    public T read(T reuse, Decoder decoder) throws IOException {
        return DecoderResolver.resolveAndRead(decoder, this.readSchema, this.fileSchema, this.reader, reuse);
    }

    private static class ReadBuilder
    extends AvroSchemaVisitor<ValueReader<?>> {
        private final ClassLoader loader;

        private ReadBuilder(ClassLoader loader) {
            this.loader = loader;
        }

        @Override
        public ValueReader<?> record(Schema record, List<String> names, List<ValueReader<?>> fields) {
            try {
                Class recordClass = DynClasses.builder().loader(this.loader).impl(record.getFullName()).buildChecked();
                if (IndexedRecord.class.isAssignableFrom(recordClass)) {
                    return ValueReaders.record(fields, recordClass, record);
                }
                return ValueReaders.record(fields, record);
            }
            catch (ClassNotFoundException e) {
                return ValueReaders.record(fields, record);
            }
        }

        @Override
        public ValueReader<?> union(Schema union, List<ValueReader<?>> options) {
            return ValueReaders.union(options);
        }

        @Override
        public ValueReader<?> array(Schema array, ValueReader<?> elementReader) {
            if (array.getLogicalType() instanceof LogicalMap) {
                ValueReaders.StructReader keyValueReader = (ValueReaders.StructReader)elementReader;
                ValueReader<?> keyReader = keyValueReader.reader(0);
                ValueReader<?> valueReader = keyValueReader.reader(1);
                if (keyReader == ValueReaders.utf8s()) {
                    return ValueReaders.arrayMap(ValueReaders.strings(), valueReader);
                }
                return ValueReaders.arrayMap(keyReader, valueReader);
            }
            return ValueReaders.array(elementReader);
        }

        @Override
        public ValueReader<?> map(Schema map, ValueReader<?> valueReader) {
            return ValueReaders.map(ValueReaders.strings(), valueReader);
        }

        @Override
        public ValueReader<?> primitive(Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return ValueReaders.ints();
                    }
                    case "time-micros": {
                        return ValueReaders.longs();
                    }
                    case "timestamp-millis": {
                        ValueReader<Long> longs = ValueReaders.longs();
                        return (decoder, ignored) -> (Long)longs.read(decoder, null) * 1000L;
                    }
                    case "timestamp-micros": {
                        return ValueReaders.longs();
                    }
                    case "decimal": {
                        return ValueReaders.decimal(ValueReaders.decimalBytesReader(primitive), ((LogicalTypes.Decimal)logicalType).getScale());
                    }
                    case "uuid": {
                        return ValueReaders.uuids();
                    }
                }
                throw new IllegalArgumentException("Unknown logical type: " + logicalType);
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueReaders.nulls();
                }
                case BOOLEAN: {
                    return ValueReaders.booleans();
                }
                case INT: {
                    return ValueReaders.ints();
                }
                case LONG: {
                    return ValueReaders.longs();
                }
                case FLOAT: {
                    return ValueReaders.floats();
                }
                case DOUBLE: {
                    return ValueReaders.doubles();
                }
                case STRING: {
                    return ValueReaders.utf8s();
                }
                case FIXED: {
                    return ValueReaders.fixed(primitive);
                }
                case BYTES: {
                    return ValueReaders.byteBuffers();
                }
                case ENUM: {
                    return ValueReaders.enums(primitive.getEnumSymbols());
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + primitive);
        }
    }
}

