/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.rec.AbstractProposer;
import org.apache.kylin.rec.AbstractSemiContext;
import org.apache.kylin.rec.ChainedProposer;
import org.apache.kylin.rec.IndexPlanOptProposer;
import org.apache.kylin.rec.IndexPlanSelectProposer;
import org.apache.kylin.rec.IndexPlanShrinkProposer;
import org.apache.kylin.rec.ModelInfoAdjustProposer;
import org.apache.kylin.rec.ModelOptProposer;
import org.apache.kylin.rec.ModelRenameProposer;
import org.apache.kylin.rec.ModelSelectProposer;
import org.apache.kylin.rec.SQLAnalysisProposer;
import org.apache.kylin.rec.ViewModelSelectProposer;
import org.apache.kylin.rec.common.AccelerateInfo;

public class ModelReuseContext
extends AbstractSemiContext {
    public ModelReuseContext(KylinConfig kylinConfig, String project, String[] sqlArray) {
        this(kylinConfig, project, sqlArray, "");
    }

    public ModelReuseContext(KylinConfig kylinConfig, String project, String[] sqlArray, boolean canCreateNewModel) {
        this(kylinConfig, project, sqlArray);
        this.canCreateNewModel = canCreateNewModel;
    }

    public ModelReuseContext(KylinConfig kylinConfig, String project, String[] sqlArray, String modelName) {
        super(kylinConfig, project, sqlArray, modelName);
        this.partialMatch = this.getSmartConfig().getKylinConfig().isQueryMatchPartialInnerJoinModel();
        this.partialMatchNonEqui = this.getSmartConfig().getKylinConfig().partialMatchNonEquiJoins();
    }

    @Override
    public ChainedProposer createProposers() {
        return new ChainedProposer(this, (ImmutableList<AbstractProposer>)ImmutableList.of((Object)new SQLAnalysisProposer(this), (Object)new ModelSelectProposer(this), (Object)new ViewModelSelectProposer(this), (Object)new ModelOptProposer(this), (Object)new ModelInfoAdjustProposer(this), (Object)new ModelRenameProposer(this), (Object)new IndexPlanSelectProposer(this), (Object)new IndexPlanOptProposer(this), (Object)new IndexPlanShrinkProposer(this)));
    }

    @Override
    public void handleExceptionAfterModelSelect() {
        if (this.isCanCreateNewModel()) {
            return;
        }
        this.getModelContexts().forEach(modelCtx -> {
            if (modelCtx.isTargetModelMissing()) {
                modelCtx.getModelTree().getOlapContexts().forEach(olapContext -> {
                    AccelerateInfo accelerateInfo = this.getAccelerateInfoMap().get(olapContext.getSql());
                    accelerateInfo.setPendingMsg("No model matches the SQL. Please add a model matches the SQL before attempting to accelerate this query.");
                });
            }
        });
    }
}

