/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.utils.ComputedColumnEvalUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.metadata.model.util.ComputedColumnUtil;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.entity.CCRecItemV2;
import org.apache.kylin.metadata.recommendation.util.RawRecUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.TableColRefWithRel;
import org.apache.kylin.query.util.PushDownUtil;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.model.AbstractModelProposer;
import org.apache.kylin.rec.model.ModelTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputedColumnProposer
extends AbstractModelProposer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComputedColumnProposer.class);

    ComputedColumnProposer(AbstractContext.ModelContext modelContext) {
        super(modelContext);
    }

    @Override
    protected void execute(NDataModel dataModel) {
        log.trace("Propose computed column for model({})", (Object)dataModel.getId());
        long startTime = System.currentTimeMillis();
        this.initModel(dataModel);
        Set<String> ccSuggestions = this.collectLatentCCSuggestions(this.modelContext, dataModel);
        this.transferStatusOfNeedUpdateCC(ccSuggestions);
        List<ComputedColumnDesc> newValidCCList = this.transferToComputedColumn(dataModel, ccSuggestions);
        this.evaluateTypeOfComputedColumns(dataModel, newValidCCList);
        this.cleanInvalidComputedColumnsInModel(dataModel);
        this.collectCCRecommendations(newValidCCList);
        log.info("Propose ComputedColumns successfully completed in {} s. Valid ComputedColumns on model({}) are: {}.", new Object[]{(System.currentTimeMillis() - startTime) / 1000L, dataModel.getId(), dataModel.getComputedColumnNames()});
    }

    private Set<String> collectLatentCCSuggestions(AbstractContext.ModelContext modelContext, NDataModel dataModel) {
        HashSet ccSuggestions = Sets.newHashSet();
        ModelTree modelTree = modelContext.getModelTree();
        KylinConfig kylinConfig = this.getModelContext().getProposeContext().getKapConfig().getKylinConfig();
        boolean partialMatch = kylinConfig.isQueryMatchPartialInnerJoinModel();
        boolean nonEquiPartialMatch = kylinConfig.partialMatchNonEquiJoins();
        for (OlapContext ctx : modelTree.getOlapContexts()) {
            Map matchingAlias = ctx.matchJoins(dataModel, partialMatch, nonEquiPartialMatch);
            ctx.fixModel(dataModel, matchingAlias);
            Set<TblColRef> innerColumns = this.collectInnerColumns(ctx);
            innerColumns.removeIf(col -> !col.isInnerColumn());
            innerColumns.removeIf(col -> modelContext.getExcludedChecker().isExcludedCol(col));
            innerColumns.removeIf(col -> modelContext.getAntiFlatChecker().isCCOfAntiLookup(col));
            ccSuggestions.addAll(this.translateToSuggestions(innerColumns, matchingAlias));
            ctx.unfixModel();
        }
        log.info("Proposed computed column candidates {} for model [{}] successfully", (Object)ccSuggestions, (Object)dataModel.getId());
        return ccSuggestions;
    }

    private void transferStatusOfNeedUpdateCC(Set<String> latentCCSuggestions) {
        if (!latentCCSuggestions.isEmpty()) {
            this.modelContext.setNeedUpdateCC(true);
        }
    }

    private List<ComputedColumnDesc> transferToComputedColumn(NDataModel dataModel, Set<String> ccSuggestions) {
        ArrayList validCCs = Lists.newArrayList();
        if (ccSuggestions.isEmpty()) {
            return validCCs;
        }
        List<NDataModel> otherModels = this.getOtherModels(dataModel);
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)this.project);
        boolean onlyReuseUserDefinedCC = projectConfig.onlyReuseUserDefinedCC();
        for (String ccSuggestion : ccSuggestions) {
            ComputedColumnDesc ccDesc = this.modelContext.getUsedCC().get(ccSuggestion);
            if (ccDesc != null || onlyReuseUserDefinedCC) continue;
            ccDesc = new ComputedColumnDesc();
            ccDesc.setTableIdentity(dataModel.getRootFactTable().getTableIdentity());
            ccDesc.setTableAlias(dataModel.getRootFactTableAlias());
            ccDesc.setComment("Auto suggested from: " + ccSuggestion);
            ccDesc.setDatatype("ANY");
            ccDesc.setExpression(ccSuggestion);
            String innerExpression = PushDownUtil.massageComputedColumn((NDataModel)dataModel, (String)this.project, (ComputedColumnDesc)ccDesc, null);
            ccDesc.setInnerExpression(innerExpression);
            String content = RawRecUtil.getContent((String)dataModel.getProject(), (String)dataModel.getUuid(), (String)ccDesc.getUniqueContent(), (RawRecItem.RawRecType)RawRecItem.RawRecType.COMPUTED_COLUMN);
            String ccMd5 = RawRecUtil.computeMD5((String)content);
            String contentWithoutModelID = RawRecUtil.getContent((String)dataModel.getProject(), null, (String)ccDesc.getUniqueContent(), (RawRecItem.RawRecType)RawRecItem.RawRecType.COMPUTED_COLUMN);
            String ccMd5WithoutModelID = RawRecUtil.computeMD5((String)contentWithoutModelID);
            String newCCName = ComputedColumnUtil.shareCCNameAcrossModel((ComputedColumnDesc)ccDesc, (NDataModel)dataModel, otherModels);
            if (newCCName != null) {
                ccDesc.setColumnName(newCCName);
            } else {
                String name = ComputedColumnUtil.uniqueCCName((String)ccMd5WithoutModelID);
                ccDesc.setColumnName(name);
            }
            ccDesc.setUuid(ccMd5);
            dataModel.getComputedColumnDescs().add(ccDesc);
            if (ComputedColumnEvalUtil.resolveCCName((ComputedColumnDesc)ccDesc, (NDataModel)dataModel, otherModels)) {
                validCCs.add(ccDesc);
                this.modelContext.getUsedCC().put(ccDesc.getExpression(), ccDesc);
                continue;
            }
            dataModel.getComputedColumnDescs().remove(ccDesc);
            log.debug("Malformed computed column {} has been removed from the model {}.", (Object)ccDesc, (Object)dataModel.getUuid());
        }
        return validCCs;
    }

    private void cleanInvalidComputedColumnsInModel(NDataModel dataModel) {
        dataModel.getComputedColumnDescs().removeIf(cc -> cc.getDatatype().equals("ANY"));
    }

    private Set<TblColRef> collectInnerColumns(OlapContext context) {
        HashSet usedCols = Sets.newHashSet();
        usedCols.addAll(context.getAllColumns());
        context.getAggregations().stream().filter(agg -> CollectionUtils.isNotEmpty((Collection)agg.getParameters())).forEach(agg -> usedCols.addAll(agg.getColRefs()));
        usedCols.addAll(this.getGroupByInnerColumns(context));
        if (this.modelContext.getProposeContext().getSmartConfig().enableComputedColumnOnFilterKeySuggestion()) {
            usedCols.addAll(this.getFilterInnerColumns(context));
        }
        return usedCols;
    }

    private void collectCCRecommendations(List<ComputedColumnDesc> computedColumns) {
        if (this.modelContext.getProposeContext().skipCollectRecommendations() || CollectionUtils.isEmpty(computedColumns)) {
            return;
        }
        computedColumns.forEach(cc -> {
            CCRecItemV2 item = new CCRecItemV2();
            item.setCc(cc);
            item.setCreateTime(System.currentTimeMillis());
            item.setUuid(cc.getUuid());
            item.setUniqueContent(cc.getUniqueContent());
            this.modelContext.getCcRecItemMap().putIfAbsent(item.getUuid(), item);
        });
    }

    protected Set<String> translateToSuggestions(Set<TblColRef> innerColumns, Map<String, String> matchingAlias) {
        HashSet candidates = Sets.newHashSet();
        for (TblColRef col : innerColumns) {
            String parserDesc = col.getParserDescription();
            if (parserDesc == null) continue;
            parserDesc = (String)matchingAlias.entrySet().stream().map(entry -> s -> s.replaceAll((String)entry.getKey(), (String)entry.getValue())).reduce(Function.identity(), Function::andThen).apply(parserDesc);
            log.trace(parserDesc);
            candidates.add(parserDesc);
        }
        return candidates;
    }

    private Collection<TblColRef> getFilterInnerColumns(OlapContext context) {
        HashSet<TblColRef> resultSet = new HashSet<TblColRef>();
        for (TableColRefWithRel innerColRefWithRel : context.getInnerFilterColumns()) {
            TblColRef innerColRef = innerColRefWithRel.getTblColRef();
            Set filterSourceColumns = innerColRef.getSourceColumns();
            if (innerColRef.getSourceColumns().isEmpty() || !this.checkColumnsMinCardinality(filterSourceColumns, this.modelContext.getProposeContext().getSmartConfig().getComputedColumnOnFilterKeySuggestionMinCardinality())) continue;
            filterSourceColumns.retainAll(context.getGroupByColumns());
            if (!filterSourceColumns.isEmpty()) continue;
            resultSet.add(innerColRef);
        }
        return resultSet;
    }

    private Collection<TblColRef> getGroupByInnerColumns(OlapContext context) {
        HashSet<TblColRef> resultSet = new HashSet<TblColRef>();
        for (TableColRefWithRel groupByColRefWithRel : context.getInnerGroupByColumns()) {
            TblColRef groupByColRef = groupByColRefWithRel.getTblColRef();
            Set groupSourceColumns = groupByColRef.getSourceColumns();
            if (groupByColRef.getSourceColumns().isEmpty() || !this.checkColumnsMinCardinality(groupSourceColumns, this.modelContext.getProposeContext().getSmartConfig().getComputedColumnOnGroupKeySuggestionMinCardinality())) continue;
            resultSet.add(groupByColRef);
        }
        return resultSet;
    }

    private boolean checkColumnsMinCardinality(Collection<TblColRef> colRefs, long minCardinality) {
        for (TblColRef colRef : colRefs) {
            long colCardinality = this.getColumnCardinality(colRef);
            if (colCardinality == -1L) {
                return this.getModelContext().getProposeContext().getSmartConfig().needProposeCcIfNoSampling();
            }
            if (colCardinality >= minCardinality) {
                return true;
            }
            minCardinality /= colCardinality;
        }
        return false;
    }

    private long getColumnCardinality(TblColRef colRef) {
        NTableMetadataManager nTableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
        TableExtDesc.ColumnStats columnStats = TableExtDesc.ColumnStats.getColumnStats((NTableMetadataManager)nTableMetadataManager, (TblColRef)colRef);
        return columnStats == null ? -1L : columnStats.getCardinality();
    }

    private void evaluateTypeOfComputedColumns(NDataModel dataModel, List<ComputedColumnDesc> validCCs) {
        if (this.modelContext.getProposeContext().isSkipEvaluateCC() || validCCs.isEmpty()) {
            return;
        }
        ComputedColumnEvalUtil.evaluateExprAndTypeBatch((NDataModel)dataModel, validCCs);
    }

    private List<NDataModel> getOtherModels(NDataModel dataModel) {
        List<NDataModel> otherModels = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project).listAllModels().stream().filter(m -> !m.getUuid().equals(dataModel.getUuid())).collect(Collectors.toList());
        otherModels.addAll(this.getModelContext().getProposeContext().getModelContexts().stream().filter(modelContext -> modelContext != this.getModelContext()).map(AbstractContext.ModelContext::getTargetModel).filter(Objects::nonNull).collect(Collectors.toList()));
        return otherModels;
    }

    public static class ComputedColumnProposerOfModelReuseContext
    extends ComputedColumnProposer {
        ComputedColumnProposerOfModelReuseContext(AbstractContext.ModelContext modelContext) {
            super(modelContext);
        }

        @Override
        protected Set<String> translateToSuggestions(Set<TblColRef> usedCols, Map<String, String> matchingAlias) {
            Set<String> candidates = super.translateToSuggestions(usedCols, matchingAlias);
            for (TblColRef col : usedCols) {
                if (!col.getColumnDesc().isComputedColumn()) continue;
                try {
                    candidates.add(CalciteParser.transformDoubleQuote((String)col.getExpressionInSourceDB()));
                }
                catch (Exception e) {
                    log.warn("fail to acquire formatted cc from expr {}", (Object)col.getExpressionInSourceDB());
                }
            }
            return candidates;
        }
    }
}

