/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.query;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.sql.SQLException;
import lombok.Generated;

public class SQLResult
implements Serializable {
    public static final String NON_SELECT_CLAUSE = "Statement is not a select clause";
    @JsonProperty(value="status")
    private Status status;
    @JsonProperty(value="message")
    private String message;
    @JsonIgnore
    private Throwable exception;
    @JsonProperty(value="query_id")
    private String queryId;
    @JsonProperty(value="sql")
    private String sql;
    @JsonProperty(value="duration")
    private long duration;
    @JsonProperty(value="project")
    private String project;

    public void writeNonQueryException(String project, String sql, long duration) {
        this.write(project, sql, duration, NON_SELECT_CLAUSE);
        this.writeExceptionInfo(NON_SELECT_CLAUSE, new SQLException("Statement is not a select clause:" + sql));
    }

    public void writeExceptionInfo(String message, Throwable e) {
        this.status = Status.FAILED;
        this.message = message;
        this.exception = e;
    }

    public void writeNormalInfo(String project, String sql, long elapsed, String queryId) {
        this.write(project, sql, elapsed, queryId);
        if (this.exception == null) {
            this.status = Status.SUCCESS;
        }
    }

    private void write(String project, String sql, long elapsed, String queryId) {
        this.project = project;
        this.sql = sql;
        this.duration = elapsed;
        this.queryId = queryId;
    }

    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setException(Throwable exception) {
        this.exception = exception;
    }

    @Generated
    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    @Generated
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Generated
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Throwable getException() {
        return this.exception;
    }

    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public SQLResult() {
    }

    public static enum Status {
        SUCCESS,
        FAILED;

    }
}

