/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.TypeResolver;
import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.webmvc.mapping.Associations;
import springfox.documentation.spring.data.rest.EntityAssociationOperationsExtractor;
import springfox.documentation.spring.data.rest.RequestHandlerExtractorConfiguration;
import springfox.documentation.spring.web.paths.Paths;

public class EntityContext {
    private final RepositoryRestConfiguration configuration;
    private final RepositoryInformation repository;
    private final Object repositoryInstance;
    private final ResourceMetadata resource;
    private final TypeResolver typeResolver;
    private final ResourceMappings mappings;
    private final PersistentEntities entities;
    private final Associations associations;
    private final RequestHandlerExtractorConfiguration extractorConfiguration;
    private final String contextPath;

    public EntityContext(TypeResolver typeResolver, String contextPath, RepositoryRestConfiguration configuration, RepositoryInformation repository, Object repositoryInstance, ResourceMetadata resource, ResourceMappings mappings, PersistentEntities entities, Associations associations, RequestHandlerExtractorConfiguration extractorConfiguration) {
        this.configuration = configuration;
        this.repository = repository;
        this.repositoryInstance = repositoryInstance;
        this.resource = resource;
        this.typeResolver = typeResolver;
        this.mappings = mappings;
        this.entities = entities;
        this.associations = associations;
        this.extractorConfiguration = extractorConfiguration;
        this.contextPath = contextPath;
    }

    public String getName() {
        return this.resource.getDomainType().getSimpleName();
    }

    public Optional<PersistentEntity<?, ? extends PersistentProperty<?>>> entity() {
        return this.entities.getPersistentEntity(this.resource.getDomainType());
    }

    public CrudMethods crudMethods() {
        return this.repository.getCrudMethods();
    }

    public Object getRepositoryInstance() {
        return this.repositoryInstance;
    }

    public URI basePath() {
        return this.configuration.getBasePath();
    }

    public Path resourcePath() {
        return this.resource.getPath();
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public RepositoryMetadata getRepositoryMetadata() {
        return this.repository;
    }

    public RepositoryRestConfiguration getConfiguration() {
        return this.configuration;
    }

    public SearchResourceMappings searchMappings() {
        return this.mappings.getSearchResourceMappings(this.repository.getDomainType());
    }

    public Associations getAssociations() {
        return this.associations;
    }

    public Collection<EntityAssociationOperationsExtractor> getAssociationExtractors() {
        return this.extractorConfiguration.getAssociationExtractors();
    }

    public String contextPath() {
        return Paths.rootPathWhenEmpty(this.contextPath);
    }
}

