/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.gluten.vectorized.CHNativeBlock;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.storage.CHShuffleWriteStreamFactory;

public class BlockOutputStream
implements Closeable {
    private final long instance;
    private final OutputStream outputStream;
    private final SQLMetric dataSize;
    private boolean isClosed = false;

    public BlockOutputStream(OutputStream outputStream, byte[] buffer, SQLMetric dataSize, boolean compressionEnable, String defaultCompressionCodec, int defaultCompressionLevel, int bufferSize) {
        OutputStream unwrapOutputStream = CHShuffleWriteStreamFactory.unwrapSparkCompressionOutputStream(outputStream, compressionEnable);
        if (unwrapOutputStream != null) {
            this.outputStream = unwrapOutputStream;
        } else {
            this.outputStream = outputStream;
            compressionEnable = false;
        }
        this.instance = this.nativeCreate(this.outputStream, buffer, defaultCompressionCodec, defaultCompressionLevel, compressionEnable, bufferSize);
        this.dataSize = dataSize;
    }

    private native long nativeCreate(OutputStream var1, byte[] var2, String var3, int var4, boolean var5, int var6);

    private native long nativeClose(long var1);

    private native void nativeWrite(long var1, long var3);

    private native void nativeFlush(long var1);

    public void write(ColumnarBatch cb) {
        if (cb.numCols() == 0 || cb.numRows() == 0) {
            return;
        }
        CHNativeBlock block = CHNativeBlock.fromColumnarBatch(cb);
        this.dataSize.add(block.totalBytes());
        this.nativeWrite(this.instance, block.blockAddress());
    }

    public void flush() throws IOException {
        this.nativeFlush(this.instance);
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.nativeClose(this.instance);
            this.outputStream.flush();
            this.outputStream.close();
            this.isClosed = true;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

