/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import com.databricks.spark.util.TagDefinitions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.AnalysisHelper$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$$anonfun$;
import org.apache.spark.sql.delta.DeltaTableIdentifier;
import org.apache.spark.sql.delta.DeltaTableIdentifier$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class DeltaLog$
implements DeltaLogging {
    public static DeltaLog$ MODULE$;
    private final String LOG_DIR_NAME;
    private final Cache<Tuple2<Path, Map<String, String>>, DeltaLog> deltaLogCache;
    private final Map<String, String> jsonCommitParseOption;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DeltaLog$();
    }

    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$((DeltaLogging)this, (DeltaLog)deltaLog, (String)opType, tags, (Object)data, path);
    }

    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$((DeltaLogging)this);
    }

    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$((DeltaLogging)this);
    }

    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$((DeltaLogging)this);
    }

    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$((DeltaLogging)this, (String)tablePath, (String)opType, tags, thunk);
    }

    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$((DeltaLogging)this);
    }

    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$((DeltaLogging)this, (DeltaLog)deltaLog, (String)opType, tags, thunk);
    }

    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$((DeltaLogging)this);
    }

    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$((DeltaLogging)this, (String)group, (String)name, thunk);
    }

    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$((DeltaLogging)this, (DeltaLog)deltaLog, (String)tahoeId);
    }

    public void logConsole(String line) {
        DatabricksLogging.logConsole$((DatabricksLogging)this, (String)line);
    }

    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$((DatabricksLogging)this, (MetricDefinition)metric, (double)quantity, additionalTags, (String)blob, (boolean)forceSample, (boolean)trimBlob, (boolean)silent);
    }

    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$((DatabricksLogging)this);
    }

    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$((DatabricksLogging)this);
    }

    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$((DatabricksLogging)this, (MetricDefinition)metric, additionalTags, (String)blob, (boolean)trimBlob);
    }

    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$((DatabricksLogging)this);
    }

    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$((DatabricksLogging)this);
    }

    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$((DatabricksLogging)this);
    }

    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$((DatabricksLogging)this, (OpType)opType, (String)opTarget, extraTags, (boolean)isSynchronous, (boolean)alwaysRecordStats, (boolean)allowAuthTags, (boolean)killJvmIfStuck, (MetricDefinition)outputMetric, (boolean)silent, thunk);
    }

    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$((DatabricksLogging)this);
    }

    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$((DatabricksLogging)this);
    }

    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$((DatabricksLogging)this, (MetricDefinition)metric, (double)quantity, additionalTags, (String)blob, (boolean)forceSample, (boolean)trimBlob, (boolean)silent);
    }

    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$((DatabricksLogging)this);
    }

    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$((DatabricksLogging)this);
    }

    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$((DatabricksLogging)this);
    }

    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$((DatabricksLogging)this);
    }

    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$((DatabricksLogging)this);
    }

    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$((DatabricksLogging)this, (MetricDefinition)metric, additionalTags, (String)blob, (boolean)trimBlob);
    }

    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$((DatabricksLogging)this);
    }

    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$((DatabricksLogging)this);
    }

    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$((DatabricksLogging)this);
    }

    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$((DeltaProgressReporter)this, (String)statusCode, (String)defaultMessage, data, body);
    }

    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$((DeltaProgressReporter)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String LOG_DIR_NAME() {
        return this.LOG_DIR_NAME;
    }

    public Path logPathFor(String dataPath) {
        return new Path(dataPath, this.LOG_DIR_NAME());
    }

    public Path logPathFor(Path dataPath) {
        return new Path(dataPath, this.LOG_DIR_NAME());
    }

    public Path logPathFor(File dataPath) {
        return this.logPathFor(dataPath.getAbsolutePath());
    }

    private Cache<Tuple2<Path, Map<String, String>>, DeltaLog> deltaLogCache() {
        return this.deltaLogCache;
    }

    public Map<String, String> jsonCommitParseOption() {
        return this.jsonCommitParseOption;
    }

    public DeltaLog forTable(SparkSession spark, String dataPath) {
        return this.apply(spark, this.logPathFor(dataPath), (Map<String, String>)Predef$.MODULE$.Map().empty(), (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, String dataPath, Map<String, String> options) {
        return this.apply(spark, this.logPathFor(dataPath), options, (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, File dataPath) {
        return this.apply(spark, this.logPathFor(dataPath), (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, Path dataPath) {
        return this.apply(spark, this.logPathFor(dataPath), (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, Path dataPath, Map<String, String> options) {
        return this.apply(spark, this.logPathFor(dataPath), options, (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, String dataPath, Clock clock) {
        return this.apply(spark, this.logPathFor(dataPath), clock);
    }

    public DeltaLog forTable(SparkSession spark, File dataPath, Clock clock) {
        return this.apply(spark, this.logPathFor(dataPath), clock);
    }

    public DeltaLog forTable(SparkSession spark, Path dataPath, Clock clock) {
        return this.apply(spark, this.logPathFor(dataPath), clock);
    }

    public DeltaLog forTable(SparkSession spark, TableIdentifier tableName) {
        return this.forTable(spark, tableName, (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, CatalogTable table) {
        return this.forTable(spark, table, (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, TableIdentifier tableName, Clock clock) {
        return DeltaTableIdentifier$.MODULE$.isDeltaPath(spark, tableName) ? this.forTable(spark, new Path(tableName.table())) : this.forTable(spark, spark.sessionState().catalog().getTableMetadata(tableName), clock);
    }

    public DeltaLog forTable(SparkSession spark, CatalogTable table, Clock clock) {
        return this.apply(spark, this.logPathFor(new Path(table.location())), clock);
    }

    public DeltaLog forTable(SparkSession spark, DeltaTableIdentifier deltaTable) {
        return this.forTable(spark, deltaTable, (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, DeltaTableIdentifier deltaTable, Clock clock) {
        return deltaTable.path().isDefined() ? this.forTable(spark, (String)deltaTable.path().get(), clock) : this.forTable(spark, (TableIdentifier)deltaTable.table().get(), clock);
    }

    private DeltaLog apply(SparkSession spark, Path rawPath, Clock clock) {
        return this.apply(spark, rawPath, (Map<String, String>)Predef$.MODULE$.Map().empty(), clock);
    }

    public Tuple2<DeltaLog, Snapshot> forTableWithSnapshot(SparkSession spark, String dataPath) {
        return this.withFreshSnapshot((Function1<Clock, DeltaLog>)(Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.forTable(spark, dataPath, (Clock)x$4));
    }

    public Tuple2<DeltaLog, Snapshot> forTableWithSnapshot(SparkSession spark, Path dataPath) {
        return this.withFreshSnapshot((Function1<Clock, DeltaLog>)(Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.forTable(spark, dataPath, (Clock)x$5));
    }

    public Tuple2<DeltaLog, Snapshot> forTableWithSnapshot(SparkSession spark, TableIdentifier tableName) {
        return this.withFreshSnapshot((Function1<Clock, DeltaLog>)(Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.forTable(spark, tableName, (Clock)x$6));
    }

    public Tuple2<DeltaLog, Snapshot> forTableWithSnapshot(SparkSession spark, DeltaTableIdentifier tableName) {
        return this.withFreshSnapshot((Function1<Clock, DeltaLog>)(Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.forTable(spark, tableName, (Clock)x$7));
    }

    public Tuple2<DeltaLog, Snapshot> forTableWithSnapshot(SparkSession spark, Path dataPath, Map<String, String> options) {
        return this.withFreshSnapshot((Function1<Clock, DeltaLog>)(Function1 & Serializable & scala.Serializable)x$8 -> MODULE$.apply(spark, MODULE$.logPathFor(dataPath), options, (Clock)x$8));
    }

    public Tuple2<DeltaLog, Snapshot> withFreshSnapshot(Function1<Clock, DeltaLog> thunk) {
        SystemClock clock = new SystemClock();
        long ts = clock.getTimeMillis();
        DeltaLog deltaLog = (DeltaLog)thunk.apply((Object)clock);
        Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)ts));
        boolean x$2 = deltaLog.update$default$1();
        Snapshot snapshot = deltaLog.update(x$2, (Option<Object>)x$1);
        return new Tuple2((Object)deltaLog, (Object)snapshot);
    }

    private DeltaLog apply(SparkSession spark, Path rawPath, Map<String, String> options, Clock clock) {
        DeltaLog deltaLog;
        Map fileSystemOptions = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.LOAD_FILE_SYSTEM_CONFIGS_FROM_DATAFRAME_OPTIONS())) ? options.filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)DeltaLog$.$anonfun$apply$1(k))).toMap(Predef$.MODULE$.$conforms()) : Predef$.MODULE$.Map().empty();
        Configuration hadoopConf = spark.sessionState().newHadoopConfWithOptions(fileSystemOptions);
        FileSystem fs = rawPath.getFileSystem(hadoopConf);
        Path path = fs.makeQualified(rawPath);
        DeltaLog deltaLog2 = this.getDeltaLogFromCache$1(path, fileSystemOptions, options, clock);
        if (BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply(deltaLog2.org$apache$spark$sql$delta$DeltaLog$$sparkContext().get()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isStopped())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true))) {
            this.deltaLogCache().invalidate((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)fileSystemOptions));
            deltaLog = this.getDeltaLogFromCache$1(path, fileSystemOptions, options, clock);
        } else {
            deltaLog = deltaLog2;
        }
        return deltaLog;
    }

    private Clock apply$default$3() {
        return new SystemClock();
    }

    public void invalidateCache(SparkSession spark, Path dataPath) {
        try {
            Path rawPath = this.logPathFor(dataPath);
            FileSystem fs = rawPath.getFileSystem(spark.sessionState().newHadoopConf());
            Path path = fs.makeQualified(rawPath);
            if (BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.LOAD_FILE_SYSTEM_CONFIGS_FROM_DATAFRAME_OPTIONS()))) {
                ArrayBuffer keysToBeRemoved = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                for (Tuple2 key : this.deltaLogCache().asMap().keySet()) {
                    Object object = key._1();
                    Path path2 = path;
                    Object object2 = !(object != null ? !object.equals(path2) : path2 != null) ? keysToBeRemoved.$plus$eq((Object)key) : BoxedUnit.UNIT;
                }
                this.deltaLogCache().invalidateAll((Iterable)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)keysToBeRemoved).asJava());
            } else {
                this.deltaLogCache().invalidate((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)Predef$.MODULE$.Map().empty()));
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public void clearCache() {
        this.deltaLogCache().invalidateAll();
    }

    public long cacheSize() {
        return this.deltaLogCache().size();
    }

    public Dataset<Row> filterFileList(StructType partitionSchema, Dataset<Row> files, Seq<Expression> partitionFilters, Seq<String> partitionColumnPrefixes, boolean shouldRewritePartitionFilters) {
        Seq<Expression> rewrittenFilters = shouldRewritePartitionFilters ? this.rewritePartitionFilters(partitionSchema, (Function2<String, String, Object>)files.sparkSession().sessionState().conf().resolver(), partitionFilters, partitionColumnPrefixes) : partitionFilters;
        Expression expr = (Expression)rewrittenFilters.reduceLeftOption((Function2)And$.MODULE$).getOrElse((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.TrueLiteral());
        Column columnFilter = new Column(expr);
        return files.filter(columnFilter);
    }

    public Seq<String> filterFileList$default$4() {
        return Nil$.MODULE$;
    }

    public boolean filterFileList$default$5() {
        return true;
    }

    public Seq<Expression> rewritePartitionFilters(StructType partitionSchema, Function2<String, String, Object> resolver, Seq<Expression> partitionFilters, Seq<String> partitionColumnPrefixes) {
        return (Seq)partitionFilters.map((Function1 & Serializable & scala.Serializable)x$10 -> (Expression)x$10.transformUp((PartialFunction)new scala.Serializable(partitionSchema, resolver, partitionColumnPrefixes){
            public static final long serialVersionUID = 0L;
            private final StructType partitionSchema$1;
            private final Function2 resolver$1;
            private final Seq partitionColumnPrefixes$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Attribute) {
                    UnresolvedAttribute unresolvedAttribute;
                    Some some;
                    StructField f;
                    Attribute attribute = (Attribute)A1;
                    String unquoted = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(attribute.name())).stripPrefix("`"))).stripSuffix("`");
                    Option partitionCol = this.partitionSchema$1.find((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)anonfun$$nestedInanonfun$rewritePartitionFilters$1$1.$anonfun$applyOrElse$1(this, unquoted, field)));
                    Option option = partitionCol;
                    if (option instanceof Some && (f = (StructField)(some = (Some)option).value()) != null) {
                        StructField structField = f;
                        String name = DeltaColumnMapping$.MODULE$.getPhysicalName(structField);
                        unresolvedAttribute = new Cast((Expression)new UnresolvedAttribute((Seq)this.partitionColumnPrefixes$1.$plus$plus((GenTraversableOnce)new .colon.colon((Object)"partitionValues", (List)new .colon.colon((Object)name, (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())), structField.dataType(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                    } else if (None$.MODULE$.equals(option)) {
                        DeltaLog$.MODULE$.log().error(new StringBuilder(63).append("Partition filter referenced column ").append(attribute.name()).append(" not in the partition schema").toString());
                        unresolvedAttribute = new UnresolvedAttribute((Seq)this.partitionColumnPrefixes$1.$plus$plus((GenTraversableOnce)new .colon.colon((Object)"partitionValues", (List)new .colon.colon((Object)attribute.name(), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom()));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    object = unresolvedAttribute;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof Attribute;
                return bl;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(anonfun$$nestedInanonfun$rewritePartitionFilters$1$1 $this, String unquoted$1, StructField field) {
                return BoxesRunTime.unboxToBoolean((Object)$this.resolver$1.apply((Object)field.name(), (Object)unquoted$1));
            }
            {
                this.partitionSchema$1 = partitionSchema$1;
                this.resolver$1 = resolver$1;
                this.partitionColumnPrefixes$1 = partitionColumnPrefixes$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.delta.DeltaLog$$anonfun$$nestedInanonfun$rewritePartitionFilters$1$1 java.lang.String org.apache.spark.sql.types.StructField )}, serializedLambda);
            }
        }), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> rewritePartitionFilters$default$4() {
        return Nil$.MODULE$;
    }

    public void assertRemovable(Snapshot snapshot) {
        Metadata metadata = snapshot.metadata();
        if (BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.IS_APPEND_ONLY().fromMetaData(metadata))) {
            throw DeltaErrors$.MODULE$.modifyAppendOnlyTableException(metadata.name());
        }
    }

    public Option<Object> minSetTransactionRetentionInterval(Metadata metadata) {
        return ((Option)DeltaConfigs$.MODULE$.TRANSACTION_ID_RETENTION_DURATION().fromMetaData(metadata)).map((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToLong((long)DeltaConfigs$.MODULE$.getMilliSeconds(i)));
    }

    public long tombstoneRetentionMillis(Metadata metadata) {
        return DeltaConfigs$.MODULE$.getMilliSeconds((CalendarInterval)DeltaConfigs$.MODULE$.TOMBSTONE_RETENTION().fromMetaData(metadata));
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(String k) {
        return DeltaTableUtils$.MODULE$.validDeltaTableHadoopPrefixes().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)k.startsWith(x$1)));
    }

    private final DeltaLog createDeltaLog$1(Path path$1, Map fileSystemOptions$1, Map options$2, Clock clock$1) {
        return (DeltaLog)this.recordDeltaOperation(null, "delta.log.create", (Map<TagDefinition, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TagDefinitions.TAG_TAHOE_PATH$.MODULE$), (Object)path$1.getParent().toString())}))), (Function0 & Serializable & scala.Serializable)() -> (DeltaLog)AnalysisHelper$.MODULE$.allowInvokingTransformsInAnalyzer((Function0 & Serializable & scala.Serializable)() -> new DeltaLog(path$1, path$1.getParent(), (Map<String, String>)fileSystemOptions$1, (Map<String, String>)options$2, clock$1)));
    }

    private final DeltaLog getDeltaLogFromCache$1(Path path$1, Map fileSystemOptions$1, Map options$2, Clock clock$1) {
        DeltaLog deltaLog;
        try {
            deltaLog = (DeltaLog)this.deltaLogCache().get((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path$1), (Object)fileSystemOptions$1), () -> this.createDeltaLog$1(path$1, fileSystemOptions$1, options$2, clock$1));
        }
        catch (UncheckedExecutionException e) {
            throw e.getCause();
        }
        return deltaLog;
    }

    private DeltaLog$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$((DeltaProgressReporter)this);
        DatabricksLogging.$init$((DatabricksLogging)this);
        DeltaLogging.$init$((DeltaLogging)this);
        this.LOG_DIR_NAME = "_delta_log";
        CacheBuilder builder = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).removalListener(removalNotification -> {
            DeltaLog log = (DeltaLog)removalNotification.getValue();
            try {
                log.unsafeVolatileSnapshot().uncache();
            }
            catch (NullPointerException nullPointerException) {}
        });
        package$.MODULE$.props().get("delta.log.cacheSize").flatMap((Function1 & Serializable & scala.Serializable)v -> Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(v)).toLong()).toOption()).foreach((Function1 & Serializable & scala.Serializable)maximumSize -> builder.maximumSize(BoxesRunTime.unboxToLong((Object)maximumSize)));
        this.deltaLogCache = builder.build();
        this.jsonCommitParseOption = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)FailFastMode$.MODULE$.name())}));
    }
}

