/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import org.apache.kylin.common.persistence.transaction.ITransactionManager;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class JdbcTransactionHelper
implements ITransactionManager {
    private final DataSourceTransactionManager transactionManager;

    public JdbcTransactionHelper(DataSourceTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public TransactionStatus getTransaction() throws TransactionException {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setIsolationLevel(4);
        definition.setTimeout(-1);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)definition);
        if (!status.isNewTransaction()) {
            throw new IllegalTransactionStateException("Expect an new transaction here. Please check the code if the UnitOfWork.doInTransactionWithRetry() is wrapped by JdbcUtil.withTransaction()");
        }
        return status;
    }

    @Override
    public void commit(TransactionStatus status) throws TransactionException {
        this.transactionManager.commit(status);
    }

    @Override
    public void rollback(TransactionStatus status) throws TransactionException {
        this.transactionManager.rollback(status);
    }
}

