/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.scheduler.JobFailed;
import org.apache.kylin.job.common.ExecutableUtil;
import org.apache.kylin.metadata.query.QueryHistorySql;
import org.apache.kylin.metadata.query.QueryHistorySqlParam;
import org.apache.kylin.metadata.query.QueryMetrics;
import org.apache.kylin.metadata.query.QueryMetricsContext;
import org.apache.kylin.metadata.query.RDBMSQueryHistoryDAO;
import org.apache.kylin.metadata.query.util.QueryHistoryUtil;
import org.apache.kylin.query.engine.PrepareSqlStateParam;
import org.apache.kylin.query.engine.QueryRoutingEngine;
import org.apache.kylin.query.util.AsyncQueryUtil;
import org.apache.kylin.query.util.QueryParams;
import org.apache.spark.sql.FunctionEntity;
import org.apache.spark.sql.KapFunctions;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.udf.UdfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncQueryApplication
extends SparkApplication {
    protected static final Logger logger = LoggerFactory.getLogger(AsyncQueryApplication.class);

    protected void handleException(Exception e) throws Exception {
        try {
            QueryContext.current().getMetrics().setException(true);
            AsyncQueryUtil.createErrorFlag((String)this.getParam("project"), (String)this.getParam("queryId"), (String)e.getMessage());
        }
        catch (Exception ex) {
            logger.error("save async query exception message failed");
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() throws IOException {
        logger.info("start async query job");
        QueryContext queryContext = null;
        QueryParams queryParams = null;
        try {
            if (this.getConfig().getPercentileApproxAlgorithm().equalsIgnoreCase("t-digest")) {
                UdfManager.register((SparkSession)this.getSparkSession(), (FunctionEntity)KapFunctions.percentileFunction());
            }
            queryContext = (QueryContext)JsonUtil.readValue((String)this.getParam("queryContext"), QueryContext.class);
            QueryContext.set((QueryContext)queryContext);
            QueryMetricsContext.start((String)queryContext.getQueryId(), (String)"");
            QueryRoutingEngine queryRoutingEngine = new QueryRoutingEngine();
            queryParams = (QueryParams)JsonUtil.readValue((String)this.getParam("queryParams"), QueryParams.class);
            queryParams.setKylinConfig(KylinConfig.getInstanceFromEnv());
            queryRoutingEngine.queryWithSqlMassage(queryParams);
            this.saveQueryHistory(queryContext, queryParams);
        }
        catch (Exception e) {
            logger.error("async query job failed.", (Throwable)e);
            if (queryContext != null && queryParams != null) {
                queryContext.getMetrics().setException(true);
                AsyncQueryUtil.createErrorFlag((String)this.getParam("project"), (String)this.getParam("queryId"), (String)e.getMessage());
                this.saveQueryHistory(queryContext, queryParams);
            }
        }
        finally {
            QueryMetricsContext.reset();
        }
    }

    public void disableCurrentThreadGlutenIfNeed() {
        if (!this.config.uniqueAsyncQueryUseGlutenEnabled()) {
            this.ss.sparkContext().setLocalProperty("gluten.enabledForCurrentThread", "false");
            logger.info("Disable current thread gluten for Async Query");
        }
    }

    public void reportSparkJobExtraInfo(SparkSession sparkSession) {
    }

    protected Map<String, String> getSparkConfigOverride(KylinConfig config) {
        return config.getAsyncQuerySparkConfigOverride();
    }

    protected void waitForResourceSuccess() {
    }

    public void logJobInfo() {
    }

    public void updateJobErrorInfo(JobFailed jobFailed) {
    }

    public Map<String, String> removeGlutenParamsIfNeed(Map<String, String> baseSparkConf) {
        if (!this.config.uniqueAsyncQueryUseGlutenEnabled()) {
            return ExecutableUtil.removeGultenParams(baseSparkConf);
        }
        return baseSparkConf;
    }

    private void saveQueryHistory(QueryContext queryContext, QueryParams queryParams) {
        if (StringUtils.isEmpty((CharSequence)queryContext.getMetrics().getCorrectedSql())) {
            queryContext.getMetrics().setCorrectedSql(queryContext.getUserSQL());
        }
        try {
            QueryMetricsContext queryMetricsContext = QueryMetricsContext.collect((QueryContext)queryContext);
            queryMetricsContext.setSql(this.constructQueryHistorySqlText(queryParams, queryContext.getUserSQL()));
            String normalizedSql = QueryContext.currentMetrics().getCorrectedSql();
            queryMetricsContext.setSqlPattern(normalizedSql);
            RDBMSQueryHistoryDAO.getInstance().insert((QueryMetrics)queryMetricsContext);
        }
        catch (Exception e) {
            logger.error("async query job, save query history failed", (Throwable)e);
        }
    }

    private String constructQueryHistorySqlText(QueryParams queryParams, String originalSql) throws JsonProcessingException, ClassNotFoundException {
        ArrayList<QueryHistorySqlParam> params = null;
        if (queryParams.isPrepareStatementWithParams()) {
            params = new ArrayList<QueryHistorySqlParam>();
            PrepareSqlStateParam[] requestParams = queryParams.getParams();
            for (int i = 0; i < requestParams.length; ++i) {
                PrepareSqlStateParam p = requestParams[i];
                String dataType = QueryHistoryUtil.toDataType((String)p.getClassName());
                QueryHistorySqlParam param = new QueryHistorySqlParam(Integer.valueOf(i + 1), p.getClassName(), dataType, p.getValue());
                params.add(param);
            }
        }
        return QueryHistoryUtil.toQueryHistorySqlText((QueryHistorySql)new QueryHistorySql(originalSql, null, params));
    }

    public static void main(String[] args) {
        AsyncQueryApplication job = new AsyncQueryApplication();
        job.execute(args);
    }
}

