/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.recommendation.candidate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.favorite.FavoriteRuleManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.recommendation.candidate.JdbcRawRecStore;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.ref.LayoutRef;
import org.apache.kylin.metadata.recommendation.ref.OptRecV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class RawRecManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RawRecManager.class);
    private final String project;
    private final JdbcRawRecStore jdbcRawRecStore;

    public static RawRecManager getInstance(String project) {
        return (RawRecManager)Singletons.getInstance((String)project, RawRecManager.class);
    }

    RawRecManager(String project) throws Exception {
        this.project = project;
        this.jdbcRawRecStore = new JdbcRawRecStore(KylinConfig.getInstanceFromEnv());
    }

    public DataSourceTransactionManager getTransactionManager() {
        return this.jdbcRawRecStore.getTransactionManager();
    }

    public Map<String, RawRecItem> queryNonLayoutRecItems(Set<String> modelIdSet) {
        if (CollectionUtils.isNotEmpty(modelIdSet) && modelIdSet.size() == 1) {
            return this.queryNonLayoutRecItems(modelIdSet.iterator().next());
        }
        HashMap allModelMap = Maps.newHashMap();
        NDataModelManager modelManager = NDataModelManager.getInstance(KylinConfig.readSystemKylinConfig(), this.project);
        List<NDataModel> models = modelManager.listAllModels();
        models.removeIf(RootPersistentEntity::isBroken);
        models.forEach(model -> allModelMap.put(model.getUuid(), model));
        if (CollectionUtils.isNotEmpty(modelIdSet)) {
            allModelMap.entrySet().removeIf(entry -> modelIdSet.contains(entry.getKey()));
        }
        List<RawRecItem> rawRecItems = this.jdbcRawRecStore.queryNonLayoutRecItems(this.project);
        HashMap allRecItems = Maps.newHashMap();
        rawRecItems.forEach(recItem -> {
            NDataModel model = (NDataModel)((Object)((Object)allModelMap.get(recItem.getModelID())));
            if (model != null && !recItem.isOutOfDate(model.getSemanticVersion())) {
                allRecItems.put(recItem.getUniqueFlag(), recItem);
            }
        });
        return allRecItems;
    }

    private Map<String, RawRecItem> queryNonLayoutRecItems(String model) {
        HashMap recItemMap = Maps.newHashMap();
        List<RawRecItem> recItems = this.jdbcRawRecStore.queryNonLayoutRecItems(this.project, model);
        if (CollectionUtils.isEmpty(recItems)) {
            log.info("There is no raw recommendations of model({}/{}})", (Object)this.project, (Object)model);
            return recItemMap;
        }
        recItems.forEach(recItem -> recItemMap.putIfAbsent(recItem.getUniqueFlag(), recItem));
        return recItemMap;
    }

    public Map<String, RawRecItem> queryNonAppliedLayoutRawRecItems(String model, boolean isAdditionalRec) {
        List<RawRecItem> rawRecItems = this.jdbcRawRecStore.queryNonAppliedLayoutRecItems(this.project, model, isAdditionalRec);
        HashMap map = Maps.newHashMap();
        rawRecItems.forEach(recItem -> map.put(recItem.getUniqueFlag(), recItem));
        return map;
    }

    public Pair<String, RawRecItem> queryRecItemByMd5(String md5, String content) {
        return this.jdbcRawRecStore.queryRecItemByMd5(md5, content);
    }

    public List<RawRecItem> queryAll() {
        return this.jdbcRawRecStore.queryAll();
    }

    public int clearExistingCandidates(String project, String model) {
        AtomicInteger updateCount = new AtomicInteger();
        long start = System.currentTimeMillis();
        List<RawRecItem> existingCandidates = this.jdbcRawRecStore.queryAdditionalLayoutRecItems(project, model);
        long updateTime = System.currentTimeMillis();
        for (RawRecItem rawRecItem : existingCandidates) {
            AtomicBoolean retry = new AtomicBoolean(false);
            JdbcUtil.withTxAndRetry((DataSourceTransactionManager)this.jdbcRawRecStore.getTransactionManager(), () -> {
                RawRecItem tmpRawRecItem = rawRecItem;
                if (retry.get()) {
                    tmpRawRecItem = this.jdbcRawRecStore.queryById(tmpRawRecItem.getId());
                } else {
                    retry.set(true);
                }
                tmpRawRecItem.setUpdateTime(updateTime);
                if (!"IMPORTED".equalsIgnoreCase(tmpRawRecItem.getRecSource())) {
                    tmpRawRecItem.setState(RawRecItem.RawRecState.INITIAL);
                    updateCount.getAndIncrement();
                }
                this.jdbcRawRecStore.update(tmpRawRecItem);
                return null;
            });
        }
        log.info("clear all existing candidate recommendations of model({}/{}) takes {} ms.", new Object[]{project, model, System.currentTimeMillis() - start});
        return updateCount.get();
    }

    public List<RawRecItem> displayTopNRecItems(String project, String model, int limit) {
        return this.jdbcRawRecStore.chooseTopNCandidates(project, model, limit, 0, RawRecItem.RawRecState.RECOMMENDED);
    }

    public List<RawRecItem> queryIndexPlannerRecItems(String project, String model) {
        return this.jdbcRawRecStore.chooseIndexPlannerCandidates(project, model);
    }

    public List<RawRecItem> queryImportedRawRecItems(String project, String model) {
        return this.jdbcRawRecStore.queryImportedRawRecItems(project, model, RawRecItem.RawRecState.RECOMMENDED);
    }

    public boolean updateRecommendedTopN(String project, String model, int topN) {
        List<RawRecItem> rawRecItems;
        long current = System.currentTimeMillis();
        RawRecManager rawRecManager = RawRecManager.getInstance(project);
        int existCandidateCount = rawRecManager.clearExistingCandidates(project, model);
        OptRecV2 optRecV2 = new OptRecV2(project, model, false);
        ArrayList topNCandidates = Lists.newArrayList();
        int minCost = Integer.parseInt(FavoriteRuleManager.getInstance(project).getValue("min_hit_count"));
        RawRecItem.CostMethod costMethod = RawRecItem.CostMethod.getCostMethod(project);
        minCost = costMethod == RawRecItem.CostMethod.HIT_COUNT ? minCost : -1;
        int offset = 0;
        while (topNCandidates.size() < topN && !CollectionUtils.isEmpty(rawRecItems = this.jdbcRawRecStore.chooseTopNCandidates(project, model, minCost, topN, offset, RawRecItem.RawRecState.INITIAL))) {
            optRecV2.filterExcludedRecPatterns(rawRecItems);
            rawRecItems.forEach(recItem -> {
                LayoutRef layoutRef = optRecV2.getAdditionalLayoutRefs().get(-recItem.getId());
                if (layoutRef.isExcluded()) {
                    return;
                }
                topNCandidates.add(optRecV2.getRawRecItemMap().get(recItem.getId()));
            });
            ++offset;
        }
        topNCandidates.forEach(rawRecItem -> {
            AtomicBoolean retry = new AtomicBoolean(false);
            JdbcUtil.withTxAndRetry((DataSourceTransactionManager)this.jdbcRawRecStore.getTransactionManager(), () -> {
                RawRecItem tmpRawRecItem = rawRecItem;
                if (retry.get()) {
                    tmpRawRecItem = this.jdbcRawRecStore.queryById(tmpRawRecItem.getId());
                } else {
                    retry.set(true);
                }
                tmpRawRecItem.setUpdateTime(current);
                tmpRawRecItem.setRecSource("QUERY_HISTORY");
                tmpRawRecItem.setState(RawRecItem.RawRecState.RECOMMENDED);
                rawRecManager.saveOrUpdate(tmpRawRecItem);
                return null;
            });
        });
        return topNCandidates.size() != existCandidateCount;
    }

    public Map<RawRecItem.RawRecType, Integer> getCandidatesByProject(String project) {
        RawRecItem.RawRecType[] rawRecTypes = new RawRecItem.RawRecType[]{RawRecItem.RawRecType.ADDITIONAL_LAYOUT, RawRecItem.RawRecType.REMOVAL_LAYOUT};
        int additionalCandidateCount = this.jdbcRawRecStore.getRecItemCountByProject(project, rawRecTypes[0]);
        int removalCandidatesCount = this.jdbcRawRecStore.getRecItemCountByProject(project, rawRecTypes[1]);
        HashMap map = Maps.newHashMap();
        map.put(RawRecItem.RawRecType.ADDITIONAL_LAYOUT, additionalCandidateCount);
        map.put(RawRecItem.RawRecType.REMOVAL_LAYOUT, removalCandidatesCount);
        return map;
    }

    public List<RawRecItem> getCandidatesByProjectAndBenefit(String project, int limit) {
        throw new NotImplementedException("get candidate raw recommendations by project not implement!");
    }

    public void saveOrUpdate(RawRecItem recItem) {
        this.jdbcRawRecStore.addOrUpdate(recItem);
    }

    public void discardRecItemsOfBrokenModel(String model) {
        this.jdbcRawRecStore.discardRecItemsOfBrokenModel(model);
    }

    public void deleteByProject(String project) {
        this.jdbcRawRecStore.deleteByProject(project);
    }

    public void cleanForDeletedProject(List<String> projectList) {
        this.jdbcRawRecStore.cleanForDeletedProject(projectList);
    }

    public void removeByIds(List<Integer> idList) {
        this.jdbcRawRecStore.updateState(idList, RawRecItem.RawRecState.BROKEN);
    }

    public void applyByIds(List<Integer> idList) {
        this.jdbcRawRecStore.updateState(idList, RawRecItem.RawRecState.APPLIED);
    }

    public void discardByIds(List<Integer> idList) {
        this.jdbcRawRecStore.updateState(idList, RawRecItem.RawRecState.DISCARD);
    }

    public Set<String> updateAllCost(String project) {
        return this.jdbcRawRecStore.updateAllCost(project);
    }

    public int getMaxId() {
        return this.jdbcRawRecStore.getMaxId();
    }

    public int getMinId() {
        return this.jdbcRawRecStore.getMinId();
    }

    public RawRecItem getRawRecItemByUniqueFlag(String project, String modelId, String uniqueFlag, Integer semanticVersion) {
        return this.jdbcRawRecStore.queryByUniqueFlag(project, modelId, uniqueFlag, semanticVersion);
    }

    public void importRecommendations(String project, String targetModelId, List<RawRecItem> recItems) {
        this.jdbcRawRecStore.importRecommendations(project, targetModelId, recItems);
    }
}

