/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.transaction;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.AuditLog;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.UnitMessages;
import org.apache.kylin.common.persistence.event.Event;
import org.apache.kylin.common.persistence.event.ResourceCreateOrUpdateEvent;
import org.apache.kylin.common.persistence.metadata.JdbcAuditLogStoreTool;
import org.apache.kylin.common.persistence.transaction.MessageSynchronization;
import org.apache.kylin.common.util.TestUtils;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.apache.kylin.junit.annotation.OverwriteProp;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@MetadataInfo(onlyProps=true)
public class MessageSynchronizationTest {
    @Test
    public void replayTest() {
        MessageSynchronization synchronize = MessageSynchronization.getInstance((KylinConfig)TestUtils.getTestConfig());
        List<Event> events = JdbcAuditLogStoreTool.createEvents();
        synchronize.replayInTransaction(new UnitMessages(events));
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        RawResource raw = resourceStore.getResource("PROJECT/abc");
        Assertions.assertEquals((long)1L, (long)raw.getMvcc());
        RawResource empty = resourceStore.getResource("PROJECT/abc3");
        Assertions.assertNull((Object)empty);
    }

    @OverwriteProp(key="kylin.server.mode", value="query")
    @Test
    public void testKE19979() throws InterruptedException {
        final AtomicInteger mvcc = new AtomicInteger(0);
        ResourceCreateOrUpdateEvent initEvent = (ResourceCreateOrUpdateEvent)Event.fromLog((AuditLog)JdbcAuditLogStoreTool.createProjectAuditLog("abc", 0L));
        final MessageSynchronization synchronize = MessageSynchronization.getInstance((KylinConfig)TestUtils.getTestConfig());
        synchronize.replayInTransaction(new UnitMessages((List)Lists.newArrayList((Object[])new Event[]{initEvent})));
        final ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        int loopTime = 1000;
        final CountDownLatch starter = new CountDownLatch(1);
        final CountDownLatch latch1 = new CountDownLatch(1000);
        final CountDownLatch latch2 = new CountDownLatch(1000);
        final AtomicInteger nullCount = new AtomicInteger(0);
        Thread t1 = new Thread(new Runnable(){

            @Override
            public void run() {
                starter.await();
                while (latch1.getCount() > 0L) {
                    ResourceCreateOrUpdateEvent updateEvent = (ResourceCreateOrUpdateEvent)Event.fromLog((AuditLog)JdbcAuditLogStoreTool.createProjectAuditLog("abc", mvcc.incrementAndGet()));
                    synchronize.replayInTransaction(new UnitMessages((List)Lists.newArrayList((Object[])new Event[]{updateEvent})));
                    latch1.countDown();
                }
            }
        });
        Thread t2 = new Thread(new Runnable(){

            @Override
            public void run() {
                starter.await();
                while (latch2.getCount() > 0L) {
                    if (null == resourceStore.getResource("PROJECT/abc")) {
                        nullCount.incrementAndGet();
                    }
                    latch2.countDown();
                }
            }
        });
        t1.start();
        t2.start();
        starter.countDown();
        latch1.await();
        latch2.await();
        Assertions.assertEquals((int)0, (int)nullCount.get());
    }
}

