/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.IOException;
import org.apache.kylin.common.util.HeadBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HeadBuilderTest {
    HeadBuilderTest() {
    }

    private static boolean isFull(HeadBuilder stringWriter) {
        return stringWriter.length() == stringWriter.capacity();
    }

    @Test
    void testWriteLimited() throws IOException {
        HeadBuilder stringWriter = new HeadBuilder(10);
        stringWriter.append('1');
        Assertions.assertEquals((Object)"1", (Object)stringWriter.toString());
        Assertions.assertEquals((int)10, (int)stringWriter.capacity());
        Assertions.assertFalse((boolean)HeadBuilderTest.isFull(stringWriter));
        stringWriter.append('2');
        Assertions.assertEquals((Object)"12", (Object)stringWriter.toString());
        Assertions.assertEquals((int)10, (int)stringWriter.capacity());
        Assertions.assertEquals((int)2, (int)stringWriter.length());
        Assertions.assertFalse((boolean)HeadBuilderTest.isFull(stringWriter));
        stringWriter.append("345");
        Assertions.assertEquals((Object)"12345", (Object)stringWriter.toString());
        Assertions.assertFalse((boolean)HeadBuilderTest.isFull(stringWriter));
        stringWriter.append("678910");
        HeadBuilderTest.assertWhenFull(stringWriter);
        stringWriter.append('a');
        HeadBuilderTest.assertWhenFull(stringWriter);
        stringWriter.append((CharSequence)"aa", 1, 2);
        HeadBuilderTest.assertWhenFull(stringWriter);
        HeadBuilderTest.testFull(20, 12345);
        HeadBuilderTest.testFull(16, 12345);
        HeadBuilderTest.testFull(1204, 10024);
        HeadBuilderTest.testFull(1, 52431);
    }

    @Test
    void testConstructor() {
        new HeadBuilder(0);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HeadBuilder(-1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HeadBuilder(-1, 0));
    }

    private static void testFull(int initCapacity, int maxCapacity) {
        HeadBuilder stringWriter = new HeadBuilder(initCapacity, maxCapacity);
        String APPEND_STR = new String(new char[123]);
        int APPEND_CHAR = 97;
        int SUB_APPEND_LENGTH = 89;
        while (!HeadBuilderTest.isFull(stringWriter)) {
            HeadBuilderTest.append(stringWriter, APPEND_STR, 'a', 89);
        }
        HeadBuilderTest.append(stringWriter, APPEND_STR, 'a', 89);
        Assertions.assertEquals((int)maxCapacity, (int)stringWriter.capacity());
        Assertions.assertEquals((int)maxCapacity, (int)stringWriter.length());
    }

    private static void append(HeadBuilder stringWriter, String appendStr, char appendChar, int subAppendLength) {
        int length = stringWriter.length();
        stringWriter.append(appendStr);
        if (!HeadBuilderTest.isFull(stringWriter)) {
            Assertions.assertEquals((int)123, (int)(stringWriter.length() - length));
        }
        length = stringWriter.length();
        stringWriter.append(appendChar);
        if (!HeadBuilderTest.isFull(stringWriter)) {
            Assertions.assertEquals((int)1, (int)(stringWriter.length() - length));
        }
        length = stringWriter.length();
        stringWriter.append((CharSequence)appendStr, 0, subAppendLength);
        if (!HeadBuilderTest.isFull(stringWriter)) {
            Assertions.assertEquals((int)subAppendLength, (int)(stringWriter.length() - length));
        }
    }

    private static void assertWhenFull(HeadBuilder stringWriter) {
        Assertions.assertEquals((Object)"1234567891", (Object)stringWriter.toString());
        Assertions.assertEquals((int)10, (int)stringWriter.capacity());
        Assertions.assertEquals((int)10, (int)stringWriter.length());
        Assertions.assertTrue((boolean)HeadBuilderTest.isFull(stringWriter));
    }
}

