/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.merger;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.engine.spark.ExecutableUtils;
import org.apache.kylin.engine.spark.merger.MetadataMerger;
import org.apache.kylin.job.execution.MergerInfo;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;

public class AfterSamplingMerger
extends MetadataMerger {
    public AfterSamplingMerger(KylinConfig config, String project) {
        super(config, project);
    }

    private void mergeRemoteMetaAfterSampling(String outputMetaUrl, String tableIdentity, long createTime) {
        String project = this.getProject();
        try (ResourceStore remoteStore = ExecutableUtils.getRemoteStore((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)outputMetaUrl);){
            NTableMetadataManager remoteTblMgr = NTableMetadataManager.getInstance((KylinConfig)remoteStore.getConfig(), (String)project);
            NTableMetadataManager localTblMgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            localTblMgr.mergeAndUpdateTableExt(localTblMgr.getOrCreateTableExt(tableIdentity), remoteTblMgr.getOrCreateTableExt(tableIdentity));
            TableDesc tableDesc = localTblMgr.getTableDesc(tableIdentity);
            TableExtDesc tableExt = localTblMgr.getTableExtIfExists(tableDesc);
            TableExtDesc copyForWrite = localTblMgr.copyForWrite(tableExt);
            copyForWrite.setCreateTime(createTime);
            localTblMgr.saveTableExt(copyForWrite);
        }
    }

    @Override
    public <T> T merge(MergerInfo.TaskMergeInfo info) {
        this.mergeRemoteMetaAfterSampling(info.getOutputMetaUrl(), info.getTableIdentity(), info.getCreateTime());
        return null;
    }
}

