/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal;

import io.delta.standalone.DeltaLog;
import io.delta.standalone.OptimisticTransaction;
import io.delta.standalone.VersionLog;
import io.delta.standalone.actions.CommitInfo;
import io.delta.standalone.internal.CheckpointInstance;
import io.delta.standalone.internal.CheckpointMetaData;
import io.delta.standalone.internal.Checkpoints;
import io.delta.standalone.internal.DeltaConfigs$;
import io.delta.standalone.internal.DeltaHistoryManager;
import io.delta.standalone.internal.DeltaLogImpl$;
import io.delta.standalone.internal.LogSegment;
import io.delta.standalone.internal.MemoryOptimizedVersionLog;
import io.delta.standalone.internal.MetadataCleanup;
import io.delta.standalone.internal.OptimisticTransactionImpl;
import io.delta.standalone.internal.SnapshotImpl;
import io.delta.standalone.internal.SnapshotManagement;
import io.delta.standalone.internal.actions.Action$;
import io.delta.standalone.internal.actions.Metadata;
import io.delta.standalone.internal.actions.Metadata$;
import io.delta.standalone.internal.actions.Protocol;
import io.delta.standalone.internal.exception.DeltaErrors;
import io.delta.standalone.internal.exception.DeltaErrors$;
import io.delta.standalone.internal.logging.Logging;
import io.delta.standalone.internal.sources.StandaloneHadoopConf$;
import io.delta.standalone.internal.storage.LogStoreProvider;
import io.delta.standalone.internal.util.Clock;
import io.delta.standalone.internal.util.ConversionUtils$;
import io.delta.standalone.internal.util.FileNames$;
import io.delta.storage.CloseableIterator;
import io.delta.storage.LogStore;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\tMd!\u0002\u0016,\u0001-\u001a\u0004\u0002\u0003,\u0001\u0005\u000b\u0007I\u0011\u0001-\t\u0011\u0015\u0004!\u0011!Q\u0001\neC\u0001B\u001a\u0001\u0003\u0006\u0004%\ta\u001a\u0005\t]\u0002\u0011\t\u0011)A\u0005Q\"Aq\u000e\u0001BC\u0002\u0013\u0005q\r\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003i\u0011!\t\bA!b\u0001\n\u0003\u0011\b\u0002C=\u0001\u0005\u0003\u0005\u000b\u0011B:\t\u000bi\u0004A\u0011B>\t\u0015\u0005\r\u0001\u0001#b\u0001\n\u0003\t)\u0001C\u0005l\u0001!\u0015\r\u0011\"\u0001\u0002\u0012!9\u0011\u0011\u0004\u0001\u0005\u0012\u0005m\u0001bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003s\u0001A\u0011AA\u0016\u0011\u001d\tY\u0004\u0001C\u0001\u0003{A\u0011\"!\u0016\u0001\u0005\u0004%I!a\u0016\t\u0011\u0005-\u0004\u0001)A\u0005\u00033B!\"!\u001c\u0001\u0011\u000b\u0007I\u0011CA8\u0011\u001d\t9\b\u0001C\u0001\u0003sBq!!!\u0001\t\u0003\t\u0019\tC\u0004\u0002\u000e\u0002!\t%a$\t\u000f\u0005E\u0005\u0001\"\u0011\u0002\u0014\"9\u00111\u0015\u0001\u0005B\u0005\u0015\u0006bBAa\u0001\u0011\u0005\u00131\u0019\u0005\b\u0003\u0013\u0004A\u0011IAf\u0011\u001d\ty\r\u0001C!\u0003#Dq!!7\u0001\t\u0003\nY\u000eC\u0004\u0002^\u0002!\t!a8\t\u000f\t\r\u0001\u0001\"\u0001\u0003\u0006!9!Q\u0002\u0001\u0005\u0002\t=\u0001b\u0002B\u000e\u0001\u0011\u0005!Q\u0004\u0005\b\u0005C\u0001A\u0011\u0001B\u0003\u000f!\u0011\u0019c\u000bE\u0001[\t\u0015ba\u0002\u0016,\u0011\u0003i#q\u0005\u0005\u0007u\n\"\tAa\f\t\u000f\tE\"\u0005\"\u0001\u00034!9!\u0011\u0007\u0012\u0005\u0002\te\u0002b\u0002B\u0019E\u0011\u0005!q\b\u0005\b\u0005c\u0011C\u0011\u0001B$\u0011\u001d\u0011yE\tC\u0005\u0005#B\u0011Ba\u0017##\u0003%IA!\u0018\u0003\u0019\u0011+G\u000e^1M_\u001eLU\u000e\u001d7\u000b\u00051j\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u00059z\u0013AC:uC:$\u0017\r\\8oK*\u0011\u0001'M\u0001\u0006I\u0016dG/\u0019\u0006\u0002e\u0005\u0011\u0011n\\\n\t\u0001Qb\u0004\tR$N!B\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0005Y\u0006twMC\u0001:\u0003\u0011Q\u0017M^1\n\u0005m2$AB(cU\u0016\u001cG\u000f\u0005\u0002>}5\tQ&\u0003\u0002@[\tAA)\u001a7uC2{w\r\u0005\u0002B\u00056\t1&\u0003\u0002DW\tY1\t[3dWB|\u0017N\u001c;t!\t\tU)\u0003\u0002GW\tyQ*\u001a;bI\u0006$\u0018m\u00117fC:,\b\u000f\u0005\u0002I\u00176\t\u0011J\u0003\u0002KW\u000591\u000f^8sC\u001e,\u0017B\u0001'J\u0005AaunZ*u_J,\u0007K]8wS\u0012,'\u000f\u0005\u0002B\u001d&\u0011qj\u000b\u0002\u0013':\f\u0007o\u001d5pi6\u000bg.Y4f[\u0016tG\u000f\u0005\u0002R)6\t!K\u0003\u0002TW\u00059An\\4hS:<\u0017BA+S\u0005\u001daunZ4j]\u001e\f!\u0002[1e_>\u00048i\u001c8g\u0007\u0001)\u0012!\u0017\t\u00035\u000el\u0011a\u0017\u0006\u00039v\u000bAaY8oM*\u0011alX\u0001\u0007Q\u0006$wn\u001c9\u000b\u0005\u0001\f\u0017AB1qC\u000eDWMC\u0001c\u0003\ry'oZ\u0005\u0003In\u0013QbQ8oM&<WO]1uS>t\u0017a\u00035bI>|\u0007oQ8oM\u0002\nq\u0001\\8h!\u0006$\b.F\u0001i!\tIG.D\u0001k\u0015\tYW,\u0001\u0002gg&\u0011QN\u001b\u0002\u0005!\u0006$\b.\u0001\u0005m_\u001e\u0004\u0016\r\u001e5!\u0003!!\u0017\r^1QCRD\u0017!\u00033bi\u0006\u0004\u0016\r\u001e5!\u0003\u0015\u0019Gn\\2l+\u0005\u0019\bC\u0001;x\u001b\u0005)(B\u0001<,\u0003\u0011)H/\u001b7\n\u0005a,(!B\"m_\u000e\\\u0017AB2m_\u000e\\\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0007yvtx0!\u0001\u0011\u0005\u0005\u0003\u0001\"\u0002,\n\u0001\u0004I\u0006\"\u00024\n\u0001\u0004A\u0007\"B8\n\u0001\u0004A\u0007\"B9\n\u0001\u0004\u0019\u0018!B:u_J,WCAA\u0004!\u0011\tI!!\u0004\u000e\u0005\u0005-!B\u0001&0\u0013\u0011\ty!a\u0003\u0003\u00111{wm\u0015;pe\u0016,\"!a\u0005\u0011\u0007%\f)\"C\u0002\u0002\u0018)\u0014!BR5mKNK8\u000f^3n\u0003!iW\r^1eCR\fWCAA\u000f!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012W\u00059\u0011m\u0019;j_:\u001c\u0018\u0002BA\u0014\u0003C\u0011\u0001\"T3uC\u0012\fG/Y\u0001\u0019i>l'm\u001d;p]\u0016\u0014V\r^3oi&|g.T5mY&\u001cXCAA\u0017!\u0011\ty#!\u000e\u000e\u0005\u0005E\"BAA\u001a\u0003\u0015\u00198-\u00197b\u0013\u0011\t9$!\r\u0003\t1{gnZ\u0001\u001a[&tg)\u001b7f%\u0016$XM\u001c;j_:$\u0016.\\3ti\u0006l\u0007/A\u0004uC\ndW-\u00133\u0016\u0005\u0005}\u0002\u0003BA!\u0003\u001frA!a\u0011\u0002LA!\u0011QIA\u0019\u001b\t\t9EC\u0002\u0002J]\u000ba\u0001\u0010:p_Rt\u0014\u0002BA'\u0003c\ta\u0001\u0015:fI\u00164\u0017\u0002BA)\u0003'\u0012aa\u0015;sS:<'\u0002BA'\u0003c\tA\u0002Z3mi\u0006dun\u001a'pG.,\"!!\u0017\u0011\t\u0005m\u0013qM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005)An\\2lg*!\u00111MA3\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003mbJA!!\u001b\u0002^\ti!+Z3oiJ\fg\u000e\u001e'pG.\fQ\u0002Z3mi\u0006dun\u001a'pG.\u0004\u0013a\u00025jgR|'/_\u000b\u0003\u0003c\u00022!QA:\u0013\r\t)h\u000b\u0002\u0014\t\u0016dG/\u0019%jgR|'/_'b]\u0006<WM]\u0001\u0013G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG.\u0006\u0002\u0002|A!\u0011qFA?\u0013\u0011\ty(!\r\u0003\u0007%sG/\u0001\u0005uS6,'p\u001c8f+\t\t)\t\u0005\u0003\u0002\b\u0006%UBAA3\u0013\u0011\tY)!\u001a\u0003\u0011QKW.\u001a.p]\u0016\fqaZ3u!\u0006$\b\u000eF\u0001i\u0003=9W\r^\"p[6LG/\u00138g_\u0006#H\u0003BAK\u0003?\u0003B!a&\u0002\u001c6\u0011\u0011\u0011\u0014\u0006\u0004\u0003Gi\u0013\u0002BAO\u00033\u0013!bQ8n[&$\u0018J\u001c4p\u0011\u001d\t\tK\u0006a\u0001\u0003[\tqA^3sg&|g.\u0001\u0006hKR\u001c\u0005.\u00198hKN$b!a*\u00024\u0006]\u0006CBAD\u0003S\u000bi+\u0003\u0003\u0002,\u0006\u0015$\u0001C%uKJ\fGo\u001c:\u0011\u0007u\ny+C\u0002\u000226\u0012!BV3sg&|g\u000eT8h\u0011\u001d\t)l\u0006a\u0001\u0003[\tAb\u001d;beR4VM]:j_:Dq!!/\u0018\u0001\u0004\tY,\u0001\bgC&dwJ\u001c#bi\u0006dun]:\u0011\t\u0005=\u0012QX\u0005\u0005\u0003\u007f\u000b\tDA\u0004C_>dW-\u00198\u0002;\u001d,GOV3sg&|gNQ3g_J,wJ]!u)&lWm\u001d;b[B$B!!\f\u0002F\"9\u0011q\u0019\rA\u0002\u00055\u0012!\u0003;j[\u0016\u001cH/Y7q\u0003q9W\r\u001e,feNLwN\\!u\u001fJ\fe\r^3s)&lWm\u001d;b[B$B!!\f\u0002N\"9\u0011qY\rA\u0002\u00055\u0012\u0001E:uCJ$HK]1og\u0006\u001cG/[8o)\t\t\u0019\u000eE\u0002>\u0003+L1!a6.\u0005Uy\u0005\u000f^5nSN$\u0018n\u0019+sC:\u001c\u0018m\u0019;j_:\f1\u0002^1cY\u0016,\u00050[:ugR\u0011\u00111X\u0001\u0012Y>\u001c7.\u00138uKJ\u0014X\u000f\u001d;jE2LX\u0003BAq\u0003O$B!a9\u0002zB!\u0011Q]At\u0019\u0001!q!!;\u001d\u0005\u0004\tYOA\u0001U#\u0011\ti/a=\u0011\t\u0005=\u0012q^\u0005\u0005\u0003c\f\tDA\u0004O_RD\u0017N\\4\u0011\t\u0005=\u0012Q_\u0005\u0005\u0003o\f\tDA\u0002B]fD\u0001\"a?\u001d\t\u0003\u0007\u0011Q`\u0001\u0005E>$\u0017\u0010\u0005\u0004\u00020\u0005}\u00181]\u0005\u0005\u0005\u0003\t\tD\u0001\u0005=Eft\u0017-\\3?\u0003])gn];sK2{w\rR5sK\u000e$xN]=Fq&\u001cH\u000f\u0006\u0002\u0003\bA!\u0011q\u0006B\u0005\u0013\u0011\u0011Y!!\r\u0003\tUs\u0017\u000e^\u0001\u0013CN\u001cXM\u001d;Qe>$xnY8m%\u0016\fG\r\u0006\u0003\u0003\b\tE\u0001b\u0002B\n=\u0001\u0007!QC\u0001\taJ|Go\\2pYB!\u0011q\u0004B\f\u0013\u0011\u0011I\"!\t\u0003\u0011A\u0013x\u000e^8d_2\f1#Y:tKJ$\bK]8u_\u000e|Gn\u0016:ji\u0016$BAa\u0002\u0003 !9!1C\u0010A\u0002\tU\u0011aD1tg\u0016\u0014HOU3n_Z\f'\r\\3\u0002\u0019\u0011+G\u000e^1M_\u001eLU\u000e\u001d7\u0011\u0005\u0005\u00133c\u0001\u0012\u0003*A!\u0011q\u0006B\u0016\u0013\u0011\u0011i#!\r\u0003\r\u0005s\u0017PU3g)\t\u0011)#\u0001\u0005g_J$\u0016M\u00197f)\u0015a(Q\u0007B\u001c\u0011\u00151F\u00051\u0001Z\u0011\u0019yG\u00051\u0001\u0002@Q)APa\u000f\u0003>!)a+\na\u00013\")q.\na\u0001QR9AP!\u0011\u0003D\t\u0015\u0003\"\u0002,'\u0001\u0004I\u0006BB8'\u0001\u0004\ty\u0004C\u0003rM\u0001\u00071\u000fF\u0004}\u0005\u0013\u0012YE!\u0014\t\u000bY;\u0003\u0019A-\t\u000b=<\u0003\u0019\u00015\t\u000bE<\u0003\u0019A:\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fq\u0014\u0019F!\u0016\u0003Z!)a\u000b\u000ba\u00013\"1!q\u000b\u0015A\u0002!\fqA]1x!\u0006$\b\u000eC\u0004rQA\u0005\t\u0019A:\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM*\"Aa\u0018+\u0007M\u0014\tg\u000b\u0002\u0003dA!!Q\rB8\u001b\t\u00119G\u0003\u0003\u0003j\t-\u0014!C;oG\",7m[3e\u0015\u0011\u0011i'!\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003r\t\u001d$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class DeltaLogImpl
implements DeltaLog,
Checkpoints,
MetadataCleanup,
LogStoreProvider,
SnapshotManagement,
Logging {
    private LogStore store;
    private FileSystem fs;
    private DeltaHistoryManager history;
    private final Configuration hadoopConf;
    private final Path logPath;
    private final Path dataPath;
    private final Clock clock;
    private final ReentrantLock deltaLogLock;
    private transient Logger io$delta$standalone$internal$logging$Logging$$log_;
    private volatile SnapshotImpl currentSnapshot;
    private final String acceptedLogStoreClassConfKeyRegex;
    private final String acceptedLogStoreSchemeConfKeyRegex;
    private final String logStoreClassConfKey;
    private final String defaultLogStoreClass;
    private final Path LAST_CHECKPOINT;
    private volatile byte bitmap$0;

    public static DeltaLogImpl forTable(Configuration configuration, Path path, Clock clock) {
        return DeltaLogImpl$.MODULE$.forTable(configuration, path, clock);
    }

    public static DeltaLogImpl forTable(Configuration configuration, String string, Clock clock) {
        return DeltaLogImpl$.MODULE$.forTable(configuration, string, clock);
    }

    public static DeltaLogImpl forTable(Configuration configuration, Path path) {
        return DeltaLogImpl$.MODULE$.forTable(configuration, path);
    }

    public static DeltaLogImpl forTable(Configuration configuration, String string) {
        return DeltaLogImpl$.MODULE$.forTable(configuration, string);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public SnapshotImpl snapshot() {
        return SnapshotManagement.snapshot$(this);
    }

    @Override
    public SnapshotImpl update() {
        return SnapshotManagement.update$(this);
    }

    @Override
    public SnapshotImpl getSnapshotForVersionAsOf(long version) {
        return SnapshotManagement.getSnapshotForVersionAsOf$(this, version);
    }

    @Override
    public SnapshotImpl getSnapshotForTimestampAsOf(long timestamp) {
        return SnapshotManagement.getSnapshotForTimestampAsOf$(this, timestamp);
    }

    @Override
    public LogSegment getLogSegmentForVersion(Option<Object> startCheckpoint, Option<Object> versionToLoad) {
        return SnapshotManagement.getLogSegmentForVersion$(this, startCheckpoint, versionToLoad);
    }

    @Override
    public Option<Object> getLogSegmentForVersion$default$2() {
        return SnapshotManagement.getLogSegmentForVersion$default$2$(this);
    }

    @Override
    public String logStoreSchemeConfKey(String scheme) {
        return LogStoreProvider.logStoreSchemeConfKey$(this, scheme);
    }

    @Override
    public LogStore createLogStore(Configuration hadoopConf) {
        return LogStoreProvider.createLogStore$(this, hadoopConf);
    }

    @Override
    public LogStore createLogStoreWithClassName(String className, Configuration hadoopConf) {
        return LogStoreProvider.createLogStoreWithClassName$(this, className, hadoopConf);
    }

    @Override
    public void normalizeHadoopConf(Configuration hadoopConf) {
        LogStoreProvider.normalizeHadoopConf$(this, hadoopConf);
    }

    @Override
    public void checkLogStoreConfConflicts(Configuration hadoopConf) {
        LogStoreProvider.checkLogStoreConfConflicts$(this, hadoopConf);
    }

    @Override
    public boolean enableExpiredLogCleanup() {
        return MetadataCleanup.enableExpiredLogCleanup$(this);
    }

    @Override
    public long deltaRetentionMillis() {
        return MetadataCleanup.deltaRetentionMillis$(this);
    }

    @Override
    public void doLogCleanup() {
        MetadataCleanup.doLogCleanup$(this);
    }

    @Override
    public void cleanUpExpiredLogs() {
        MetadataCleanup.cleanUpExpiredLogs$(this);
    }

    @Override
    public Option<CheckpointMetaData> lastCheckpoint() {
        return Checkpoints.lastCheckpoint$(this);
    }

    @Override
    public void checkpoint() {
        Checkpoints.checkpoint$(this);
    }

    @Override
    public void checkpoint(SnapshotImpl snapshotToCheckpoint) {
        Checkpoints.checkpoint$(this, snapshotToCheckpoint);
    }

    @Override
    public Option<CheckpointInstance> findLastCompleteCheckpoint(CheckpointInstance cv) {
        return Checkpoints.findLastCompleteCheckpoint$(this, cv);
    }

    @Override
    public Option<CheckpointInstance> getLatestCompleteCheckpointFromList(CheckpointInstance[] instances, CheckpointInstance notLaterThan) {
        return Checkpoints.getLatestCompleteCheckpointFromList$(this, instances, notLaterThan);
    }

    @Override
    public Logger io$delta$standalone$internal$logging$Logging$$log_() {
        return this.io$delta$standalone$internal$logging$Logging$$log_;
    }

    @Override
    public void io$delta$standalone$internal$logging$Logging$$log__$eq(Logger x$1) {
        this.io$delta$standalone$internal$logging$Logging$$log_ = x$1;
    }

    @Override
    public SnapshotImpl currentSnapshot() {
        return this.currentSnapshot;
    }

    @Override
    public void currentSnapshot_$eq(SnapshotImpl x$1) {
        this.currentSnapshot = x$1;
    }

    @Override
    public String acceptedLogStoreClassConfKeyRegex() {
        return this.acceptedLogStoreClassConfKeyRegex;
    }

    @Override
    public String acceptedLogStoreSchemeConfKeyRegex() {
        return this.acceptedLogStoreSchemeConfKeyRegex;
    }

    @Override
    public String logStoreClassConfKey() {
        return this.logStoreClassConfKey;
    }

    @Override
    public String defaultLogStoreClass() {
        return this.defaultLogStoreClass;
    }

    @Override
    public void io$delta$standalone$internal$storage$LogStoreProvider$_setter_$acceptedLogStoreClassConfKeyRegex_$eq(String x$1) {
        this.acceptedLogStoreClassConfKeyRegex = x$1;
    }

    @Override
    public void io$delta$standalone$internal$storage$LogStoreProvider$_setter_$acceptedLogStoreSchemeConfKeyRegex_$eq(String x$1) {
        this.acceptedLogStoreSchemeConfKeyRegex = x$1;
    }

    @Override
    public void io$delta$standalone$internal$storage$LogStoreProvider$_setter_$logStoreClassConfKey_$eq(String x$1) {
        this.logStoreClassConfKey = x$1;
    }

    @Override
    public void io$delta$standalone$internal$storage$LogStoreProvider$_setter_$defaultLogStoreClass_$eq(String x$1) {
        this.defaultLogStoreClass = x$1;
    }

    @Override
    public Path LAST_CHECKPOINT() {
        return this.LAST_CHECKPOINT;
    }

    @Override
    public void io$delta$standalone$internal$Checkpoints$_setter_$LAST_CHECKPOINT_$eq(Path x$1) {
        this.LAST_CHECKPOINT = x$1;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public Path logPath() {
        return this.logPath;
    }

    public Path dataPath() {
        return this.dataPath;
    }

    public Clock clock() {
        return this.clock;
    }

    private LogStore store$lzycompute() {
        DeltaLogImpl deltaLogImpl = this;
        synchronized (deltaLogImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.store = this.createLogStore(this.hadoopConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.store;
    }

    public LogStore store() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.store$lzycompute() : this.store;
    }

    private FileSystem fs$lzycompute() {
        DeltaLogImpl deltaLogImpl = this;
        synchronized (deltaLogImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.fs = this.logPath().getFileSystem(this.hadoopConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.fs;
    }

    public FileSystem fs() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.fs$lzycompute() : this.fs;
    }

    public Metadata metadata() {
        return this.snapshot() == null ? new Metadata(Metadata$.MODULE$.apply$default$1(), Metadata$.MODULE$.apply$default$2(), Metadata$.MODULE$.apply$default$3(), Metadata$.MODULE$.apply$default$4(), Metadata$.MODULE$.apply$default$5(), Metadata$.MODULE$.apply$default$6(), Metadata$.MODULE$.apply$default$7(), Metadata$.MODULE$.apply$default$8()) : this.snapshot().metadataScala();
    }

    public long tombstoneRetentionMillis() {
        return DeltaConfigs$.MODULE$.getMilliSeconds(DeltaConfigs$.MODULE$.TOMBSTONE_RETENTION().fromMetadata(this.metadata()));
    }

    public long minFileRetentionTimestamp() {
        return this.clock().getTimeMillis() - this.tombstoneRetentionMillis();
    }

    public String tableId() {
        return this.metadata().id();
    }

    private ReentrantLock deltaLogLock() {
        return this.deltaLogLock;
    }

    private DeltaHistoryManager history$lzycompute() {
        DeltaLogImpl deltaLogImpl = this;
        synchronized (deltaLogImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.history = new DeltaHistoryManager(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.history;
    }

    public DeltaHistoryManager history() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.history$lzycompute() : this.history;
    }

    public int checkpointInterval() {
        return BoxesRunTime.unboxToInt((Object)DeltaConfigs$.MODULE$.CHECKPOINT_INTERVAL().fromMetadata(this.metadata()));
    }

    public TimeZone timezone() {
        return this.hadoopConf().get(StandaloneHadoopConf$.MODULE$.PARQUET_DATA_TIME_ZONE_ID()) == null ? TimeZone.getDefault() : TimeZone.getTimeZone(this.hadoopConf().get(StandaloneHadoopConf$.MODULE$.PARQUET_DATA_TIME_ZONE_ID()));
    }

    @Override
    public Path getPath() {
        return this.dataPath();
    }

    @Override
    public CommitInfo getCommitInfoAt(long version) {
        this.history().checkVersionExists(version);
        return ConversionUtils$.MODULE$.convertCommitInfo(this.history().getCommitInfo(version));
    }

    @Override
    public java.util.Iterator<VersionLog> getChanges(long startVersion, boolean failOnDataLoss) {
        if (startVersion < 0L) {
            throw new IllegalArgumentException(new StringBuilder(22).append("Invalid startVersion: ").append(startVersion).toString());
        }
        Iterator deltaPaths = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.store().listFrom(FileNames$.MODULE$.deltaFile(this.logPath(), startVersion), this.hadoopConf())).asScala()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileNames$.MODULE$.isDeltaFile(f.getPath())));
        LongRef lastSeenVersion = LongRef.create((long)(startVersion - 1L));
        return (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(deltaPaths.map((Function1 & Serializable & scala.Serializable)status -> {
            Path p = status.getPath();
            long version = FileNames$.MODULE$.deltaVersion(p);
            if (failOnDataLoss && version > lastSeenVersion$1.elem + 1L) {
                throw DeltaErrors$.MODULE$.failOnDataLossException(lastSeenVersion$1.elem + 1L, version);
            }
            lastSeenVersion$1.elem = version;
            return new MemoryOptimizedVersionLog(version, (Function0<CloseableIterator<String>>)(Function0 & Serializable & scala.Serializable)() -> this.store().read(p, this.hadoopConf()));
        })).asJava();
    }

    @Override
    public long getVersionBeforeOrAtTimestamp(long timestamp) {
        if (!this.tableExists()) {
            return -1L;
        }
        return this.history().getActiveCommitAtTime(new Timestamp(timestamp), true, false, false).version();
    }

    @Override
    public long getVersionAtOrAfterTimestamp(long timestamp) {
        if (!this.tableExists()) {
            return -1L;
        }
        DeltaHistoryManager.Commit commit2 = this.history().getActiveCommitAtTime(new Timestamp(timestamp), false, false, true);
        return commit2.timestamp() >= timestamp ? commit2.version() : commit2.version() + 1L;
    }

    @Override
    public OptimisticTransaction startTransaction() {
        this.update();
        return new OptimisticTransactionImpl(this, this.snapshot());
    }

    @Override
    public boolean tableExists() {
        return this.snapshot().version() >= 0L;
    }

    public <T> T lockInterruptibly(Function0<T> body) {
        Object object;
        this.deltaLogLock().lockInterruptibly();
        try {
            object = body.apply();
        }
        finally {
            this.deltaLogLock().unlock();
        }
        return (T)object;
    }

    public void ensureLogDirectoryExist() {
        if (!this.fs().exists(this.logPath()) && !this.fs().mkdirs(this.logPath())) {
            throw new IOException(new StringBuilder(14).append("Cannot create ").append(this.logPath()).toString());
        }
    }

    public void assertProtocolRead(Protocol protocol) {
        if (protocol != null && Action$.MODULE$.readerVersion() < protocol.minReaderVersion()) {
            throw new DeltaErrors.InvalidProtocolVersionException(Action$.MODULE$.protocolVersion(), protocol);
        }
    }

    public void assertProtocolWrite(Protocol protocol) {
        if (protocol != null && Action$.MODULE$.writerVersion() < protocol.minWriterVersion()) {
            throw new DeltaErrors.InvalidProtocolVersionException(Action$.MODULE$.protocolVersion(), protocol);
        }
    }

    public void assertRemovable() {
        if (BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.IS_APPEND_ONLY().fromMetadata(this.metadata()))) {
            throw DeltaErrors$.MODULE$.modifyAppendOnlyTableException();
        }
    }

    public DeltaLogImpl(Configuration hadoopConf, Path logPath, Path dataPath, Clock clock) {
        this.hadoopConf = hadoopConf;
        this.logPath = logPath;
        this.dataPath = dataPath;
        this.clock = clock;
        Checkpoints.$init$(this);
        MetadataCleanup.$init$(this);
        LogStoreProvider.$init$(this);
        SnapshotManagement.$init$(this);
        Logging.$init$(this);
        this.deltaLogLock = new ReentrantLock();
    }
}

