/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.GeoCoordinates;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.OutputFactory;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GeoCoordinatesListOutput<K, V>
extends CommandOutput<K, V, List<GeoCoordinates>>
implements StreamingOutput<GeoCoordinates> {
    private Double x;
    private boolean initialized;
    private StreamingOutput.Subscriber<GeoCoordinates> subscriber;

    public GeoCoordinatesListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<GeoCoordinates>)ListSubscriber.instance());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes == null) {
            this.subscriber.onNext((Collection)this.output, null);
            return;
        }
        double value = bytes == null ? 0.0 : Double.parseDouble(this.decodeAscii(bytes));
        this.set(value);
    }

    @Override
    public void set(double number) {
        if (this.x == null) {
            this.x = number;
            return;
        }
        this.subscriber.onNext((Collection)this.output, new GeoCoordinates(this.x, number));
        this.x = null;
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
        if (count == -1) {
            this.subscriber.onNext((Collection)this.output, null);
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<GeoCoordinates> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<GeoCoordinates> getSubscriber() {
        return this.subscriber;
    }
}

