/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.hive.metastore;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.shaded.hive.common.classification.RetrySemantics;
import org.apache.kyuubi.shaded.hive.metastore.HiveMetaStoreClient;
import org.apache.kyuubi.shaded.hive.metastore.IMetaStoreClient;
import org.apache.kyuubi.shaded.hive.metastore.annotation.NoReconnect;
import org.apache.kyuubi.shaded.hive.metastore.api.MetaException;
import org.apache.kyuubi.shaded.hive.metastore.conf.MetastoreConf;
import org.apache.kyuubi.shaded.hive.metastore.utils.JavaUtils;
import org.apache.kyuubi.shaded.hive.metastore.utils.SecurityUtils;
import org.apache.kyuubi.shaded.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class RetryingMetaStoreClient
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)RetryingMetaStoreClient.class.getName());
    private final IMetaStoreClient base;
    private final UserGroupInformation ugi = this.getUGI();
    private final int retryLimit;
    private final long retryDelaySeconds;
    private final ConcurrentHashMap<String, Long> metaCallTimeMap;
    private final long connectionLifeTimeInMillis;
    private long lastConnectionTime;
    private boolean localMetaStore;

    protected RetryingMetaStoreClient(Configuration conf, Class<?>[] constructorArgTypes, Object[] constructorArgs, ConcurrentHashMap<String, Long> metaCallTimeMap, Class<? extends IMetaStoreClient> msClientClass) throws MetaException {
        if (this.ugi == null) {
            LOG.warn("RetryingMetaStoreClient unable to determine current user UGI.");
        }
        this.retryLimit = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.THRIFT_FAILURE_RETRIES);
        this.retryDelaySeconds = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.CLIENT_CONNECT_RETRY_DELAY, TimeUnit.SECONDS);
        this.metaCallTimeMap = metaCallTimeMap;
        this.connectionLifeTimeInMillis = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.CLIENT_SOCKET_LIFETIME, TimeUnit.MILLISECONDS);
        this.lastConnectionTime = System.currentTimeMillis();
        String msUri = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.THRIFT_URIS);
        this.localMetaStore = msUri == null || msUri.trim().isEmpty();
        SecurityUtils.reloginExpiringKeytabUser();
        this.base = JavaUtils.newInstance(msClientClass, constructorArgTypes, constructorArgs);
        LOG.info("RetryingMetaStoreClient proxy=" + msClientClass + " ugi=" + this.ugi + " retries=" + this.retryLimit + " delay=" + this.retryDelaySeconds + " lifetime=" + this.connectionLifeTimeInMillis);
    }

    public static IMetaStoreClient getProxy(Configuration hiveConf) throws MetaException {
        return RetryingMetaStoreClient.getProxy(hiveConf, new Class[]{Configuration.class}, new Object[]{hiveConf}, null, HiveMetaStoreClient.class.getName());
    }

    public static IMetaStoreClient getProxy(Configuration hiveConf, Class<?>[] constructorArgTypes, Object[] constructorArgs, ConcurrentHashMap<String, Long> metaCallTimeMap, String mscClassName) throws MetaException {
        Class<IMetaStoreClient> baseClass = JavaUtils.getClass(mscClassName, IMetaStoreClient.class);
        RetryingMetaStoreClient handler = new RetryingMetaStoreClient(hiveConf, constructorArgTypes, constructorArgs, metaCallTimeMap, baseClass);
        return (IMetaStoreClient)Proxy.newProxyInstance(RetryingMetaStoreClient.class.getClassLoader(), baseClass.getInterfaces(), (InvocationHandler)handler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret;
        int retriesMade = 0;
        boolean allowReconnect = !method.isAnnotationPresent(NoReconnect.class);
        boolean allowRetry = true;
        Annotation[] directives = method.getDeclaredAnnotations();
        if (directives != null) {
            for (Annotation a : directives) {
                if (!(a instanceof RetrySemantics.CannotRetry)) continue;
                allowRetry = false;
            }
        }
        while (true) {
            try {
                SecurityUtils.reloginExpiringKeytabUser();
                if (allowReconnect && (retriesMade > 0 || this.hasConnectionLifeTimeReached(method))) {
                    if (this.ugi != null) {
                        try {
                            LOG.info("RetryingMetaStoreClient trying reconnect as " + this.ugi);
                            this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                                @Override
                                public Object run() throws MetaException {
                                    RetryingMetaStoreClient.this.base.reconnect();
                                    return null;
                                }
                            });
                        }
                        catch (UndeclaredThrowableException e) {
                            Throwable te = e.getCause();
                            if (te instanceof PrivilegedActionException) {
                                throw te.getCause();
                            }
                            throw te;
                        }
                        this.lastConnectionTime = System.currentTimeMillis();
                    } else {
                        LOG.warn("RetryingMetaStoreClient unable to reconnect. No UGI information.");
                        throw new MetaException("UGI information unavailable. Will not attempt a reconnect.");
                    }
                }
                if (this.metaCallTimeMap == null) {
                    ret = method.invoke((Object)this.base, args);
                    break;
                }
                long startTime = System.currentTimeMillis();
                ret = method.invoke((Object)this.base, args);
                long timeTaken = System.currentTimeMillis() - startTime;
                this.addMethodTime(method, timeTaken);
            }
            catch (UndeclaredThrowableException e) {
                throw e.getCause();
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (!TTransportException.class.isAssignableFrom(t.getClass())) {
                    throw t;
                }
                TTransportException caughtException = (TTransportException)t;
                if (retriesMade >= this.retryLimit || this.base.isLocalMetaStore() || !allowRetry) {
                    throw caughtException;
                }
                LOG.warn("MetaStoreClient lost connection. Attempting to reconnect (" + ++retriesMade + " of " + this.retryLimit + ") after " + this.retryDelaySeconds + "s. " + method.getName(), (Throwable)caughtException);
                Thread.sleep(this.retryDelaySeconds * 1000L);
                continue;
            }
            break;
        }
        return ret;
    }

    private UserGroupInformation getUGI() {
        UserGroupInformation ugi = null;
        try {
            ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ugi;
    }

    private void addMethodTime(Method method, long timeTaken) {
        Long newTime;
        Long curTime;
        String methodStr = this.getMethodString(method);
        do {
            curTime = this.metaCallTimeMap.get(methodStr);
            newTime = timeTaken;
        } while ((curTime == null || !this.metaCallTimeMap.replace(methodStr, curTime, newTime + curTime)) && (curTime != null || null != this.metaCallTimeMap.putIfAbsent(methodStr, newTime)));
    }

    private String getMethodString(Method method) {
        StringBuilder methodSb = new StringBuilder(method.getName());
        methodSb.append("_(");
        if (method.getParameterTypes().length != 0) {
            Iterator it = Arrays.stream(method.getParameterTypes()).iterator();
            methodSb.append(((Class)it.next()).getSimpleName());
            while (it.hasNext()) {
                methodSb.append(", ");
                methodSb.append(((Class)it.next()).getSimpleName());
            }
        }
        methodSb.append(")");
        return methodSb.toString();
    }

    private boolean hasConnectionLifeTimeReached(Method method) {
        boolean shouldReconnect;
        if (this.connectionLifeTimeInMillis <= 0L || this.localMetaStore) {
            return false;
        }
        boolean bl = shouldReconnect = System.currentTimeMillis() - this.lastConnectionTime >= this.connectionLifeTimeInMillis;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reconnection status for Method: " + method.getName() + " is " + shouldReconnect);
        }
        return shouldReconnect;
    }
}

