/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication;

import java.lang.reflect.Constructor;
import javax.security.sasl.AuthenticationException;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.authentication.AnonymousAuthenticationProviderImpl;
import org.apache.kyuubi.service.authentication.AuthMethods$;
import org.apache.kyuubi.service.authentication.EngineSecureAuthenticationProviderImpl;
import org.apache.kyuubi.service.authentication.LdapAuthenticationProviderImpl;
import org.apache.kyuubi.service.authentication.PasswdAuthenticationProvider;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class AuthenticationProviderFactory$ {
    public static AuthenticationProviderFactory$ MODULE$;

    static {
        new AuthenticationProviderFactory$();
    }

    public PasswdAuthenticationProvider getAuthenticationProvider(Enumeration.Value method, KyuubiConf conf, boolean isServer) throws AuthenticationException {
        return isServer ? this.getAuthenticationProviderForServer(method, conf) : this.getAuthenticationProviderForEngine(conf);
    }

    public boolean getAuthenticationProvider$default$3() {
        return true;
    }

    private PasswdAuthenticationProvider getAuthenticationProviderForServer(Enumeration.Value method, KyuubiConf conf) {
        PasswdAuthenticationProvider passwdAuthenticationProvider;
        Enumeration.Value value = method;
        Enumeration.Value value2 = AuthMethods$.MODULE$.NONE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            passwdAuthenticationProvider = new AnonymousAuthenticationProviderImpl();
        } else {
            Enumeration.Value value4 = AuthMethods$.MODULE$.LDAP();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                passwdAuthenticationProvider = new LdapAuthenticationProviderImpl(conf);
            } else {
                Enumeration.Value value6 = AuthMethods$.MODULE$.CUSTOM();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    Class<?> cls;
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    Option className = (Option)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_CUSTOM_CLASS());
                    if (className.isEmpty()) {
                        throw new AuthenticationException("authentication.custom.class must be set when auth method was CUSTOM.");
                    }
                    Class<?> clazz = cls = Class.forName((String)className.get(), true, classLoader);
                    if (!PasswdAuthenticationProvider.class.isAssignableFrom(cls)) {
                        throw new AuthenticationException(new StringBuilder(45).append(className).append(" must extend of PasswdAuthenticationProvider.").toString());
                    }
                    boolean confConstructor = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clazz.getConstructors())).exists((Function1 & java.io.Serializable & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AuthenticationProviderFactory$.$anonfun$getAuthenticationProviderForServer$1(p)));
                    PasswdAuthenticationProvider passwdAuthenticationProvider2 = confConstructor ? (PasswdAuthenticationProvider)clazz.getConstructor(KyuubiConf.class).newInstance(conf) : (PasswdAuthenticationProvider)clazz.newInstance();
                    passwdAuthenticationProvider = passwdAuthenticationProvider2;
                } else {
                    throw new AuthenticationException("Not a valid authentication method");
                }
            }
        }
        return passwdAuthenticationProvider;
    }

    private PasswdAuthenticationProvider getAuthenticationProviderForEngine(KyuubiConf conf) {
        return BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_ENABLED())) ? new EngineSecureAuthenticationProviderImpl() : new AnonymousAuthenticationProviderImpl();
    }

    public static final /* synthetic */ boolean $anonfun$getAuthenticationProviderForServer$1(Constructor p) {
        Class<?>[] params = p.getParameterTypes();
        return params.length == 1 && KyuubiConf.class.isAssignableFrom(params[0]);
    }

    private AuthenticationProviderFactory$() {
        MODULE$ = this;
    }
}

