/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.flink.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.kyuubi.operation.ArrayFetchIterator;
import org.apache.kyuubi.operation.FetchIterator;
import org.apache.kyuubi.shade.com.google.common.collect.Iterators;

public class ResultSet {
    private final ResultKind resultKind;
    private final List<Column> columns;
    private final FetchIterator<Row> data;
    private final List<Boolean> changeFlags;

    private ResultSet(ResultKind resultKind, List<Column> columns, FetchIterator<Row> data, @Nullable List<Boolean> changeFlags) {
        this.resultKind = (ResultKind)Preconditions.checkNotNull((Object)resultKind, (String)"resultKind must not be null");
        this.columns = (List)Preconditions.checkNotNull(columns, (String)"columns must not be null");
        this.data = (FetchIterator)Preconditions.checkNotNull(data, (String)"data must not be null");
        this.changeFlags = changeFlags;
        if (changeFlags != null) {
            Preconditions.checkArgument((Iterators.size((Iterator)((Object)data)) == changeFlags.size() ? 1 : 0) != 0, (Object)"the size of data and the size of changeFlags should be equal");
        }
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public FetchIterator<Row> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultSet resultSet = (ResultSet)o;
        return this.resultKind.equals((Object)resultSet.resultKind) && this.columns.equals(resultSet.columns) && this.data.equals(resultSet.data) && Objects.equals(this.changeFlags, resultSet.changeFlags);
    }

    public int hashCode() {
        return Objects.hash(this.resultKind, this.columns, this.data, this.changeFlags);
    }

    public String toString() {
        return "ResultSet{resultKind=" + this.resultKind + ", columns=" + this.columns + ", data=" + this.data + ", changeFlags=" + this.changeFlags + '}';
    }

    public static ResultSet fromTableResult(TableResult tableResult) {
        ResolvedSchema schema = tableResult.getResolvedSchema();
        ArrayList rows = new ArrayList();
        tableResult.collect().forEachRemaining(rows::add);
        return ResultSet.builder().resultKind(tableResult.getResultKind()).columns(schema.getColumns()).data(rows.toArray(new Row[0])).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ResultKind resultKind = null;
        private List<Column> columns = null;
        private FetchIterator<Row> data = null;
        private List<Boolean> changeFlags = null;

        private Builder() {
        }

        public Builder resultKind(ResultKind resultKind) {
            this.resultKind = resultKind;
            return this;
        }

        public Builder columns(Column ... columns) {
            this.columns = Arrays.asList(columns);
            return this;
        }

        public Builder columns(List<Column> columns) {
            this.columns = columns;
            return this;
        }

        public Builder data(FetchIterator<Row> data) {
            this.data = data;
            return this;
        }

        public Builder data(Row[] data) {
            this.data = new ArrayFetchIterator<Row>(data);
            return this;
        }

        public Builder changeFlags(List<Boolean> changeFlags) {
            this.changeFlags = changeFlags;
            return this;
        }

        public ResultSet build() {
            return new ResultSet(this.resultKind, this.columns, this.data, this.changeFlags);
        }
    }
}

